/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.generator.GenericElementStack;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.NullElement;
import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.NullFSM;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.vm.VM;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LdxHandler
extends DefaultHandler {
    private static Class CLASS = LdxHandler.class;
    public static final String OPEN_TAG = "<";
    public static final String CLOSE_TAG = ">";
    public static final String OPEN_ETAG = "</";
    public static final String NS = " xmlns=\"http://developer.cognos.com/schemas/rds/contentmodel/1\"";
    public static final int NULL_TOKEN = -1;
    public static final int TOKEN_NOTFOUND = -1;
    public static final int TOKEN_aaa_O = 1000;
    public static final int TOKEN_aaa_C = 1001;
    public static final int TOKEN_ID_O = 1010;
    public static final int TOKEN_ID_C = 1011;
    public static final int TOKEN_LST_O = 1020;
    public static final int TOKEN_LST_C = 1021;
    public static final int TOKEN_CTAB_O = 1030;
    public static final int TOKEN_CTAB_C = 1031;
    public static final int TOKEN_ROW_O = 1040;
    public static final int TOKEN_ROW_C = 1041;
    public static final int TOKEN_COLUMN_O = 1050;
    public static final int TOKEN_COLUMN_C = 1051;
    public static final int TOKEN_MEASURE_O = 1060;
    public static final int TOKEN_MEASURE_C = 1061;
    public static final int TOKEN_TABLE_O = 1070;
    public static final int TOKEN_TABLE_C = 1071;
    public static final int TOKEN_VAL_O = 1080;
    public static final int TOKEN_VAL_C = 1081;
    public static final int TOKEN_NDIM_O = 1090;
    public static final int TOKEN_NDIM_C = 1091;
    public static final int TOKEN_NAME_O = 1100;
    public static final int TOKEN_NAME_C = 1101;
    public static final int TOKEN_START_O = 1200;
    public static final int TOKEN_START_C = 1201;
    public static final int TOKEN_CELL_O = 1300;
    public static final int TOKEN_CELL_C = 1301;
    public static final int TOKEN_CORNER_O = 1400;
    public static final int TOKEN_CORNER_C = 1401;
    public static final int TOKEN_CSPAN_O = 1500;
    public static final int TOKEN_CSPAN_C = 1501;
    public static final int TOKEN_RSPAN_O = 1600;
    public static final int TOKEN_RSPAN_C = 1601;
    public static final int TOKEN_COLTITLE_O = 1700;
    public static final int TOKEN_COLTITLE_C = 1701;
    public static final int TOKEN_GROUP_O = 1800;
    public static final int TOKEN_GROUP_C = 1801;
    public static final int TOKEN_GRP_O = 1900;
    public static final int TOKEN_GRP_C = 1901;
    public static final int TOKEN_FOOTER_O = 2000;
    public static final int TOKEN_FOOTER_C = 2001;
    public static final int TOKEN_HEADER_O = 2100;
    public static final int TOKEN_HEADER_C = 2101;
    public static final int TOKEN_REF_O = 2200;
    public static final int TOKEN_REF_C = 2201;
    public static final int TOKEN_ITEM_O = 2300;
    public static final int TOKEN_ITEM_C = 2301;
    public static final int TOKEN_STYLE_O = 2400;
    public static final int TOKEN_STYLE_C = 2401;
    public static final int TOKEN_TXT_O = 2500;
    public static final int TOKEN_TXT_C = 2501;
    public static final int TOKEN_IMG_O = 2600;
    public static final int TOKEN_IMG_C = 2601;
    public static final int TOKEN_CHT_O = 2700;
    public static final int TOKEN_CHT_C = 2701;
    public static final int TOKEN_CHART_DETAILS_O = 2704;
    public static final int TOKEN_CHART_DETAILS_C = 2705;
    public static final int TOKEN_PAGE_O = 2800;
    public static final int TOKEN_PAGE_C = 2801;
    public static final int TOKEN_PAGES_O = 2802;
    public static final int TOKEN_PAGES_C = 2803;
    public static final int TOKEN_BODY_O = 2900;
    public static final int TOKEN_BODY_C = 2901;
    public static final int TOKEN_STYLEGROUP_O = 3000;
    public static final int TOKEN_STYLEGROUP_C = 3001;
    public static final int TOKEN_VERSBASE_O = 3100;
    public static final int TOKEN_VERSBASE_C = 3101;
    public static final int TOKEN_URL_O = 3200;
    public static final int TOKEN_URL_C = 3201;
    public static final int TOKEN_DOCUMENT_O = 3300;
    public static final int TOKEN_DOCUMENT_C = 3301;
    public static final int TOKEN_FILTERRESULTSET_O = 3400;
    public static final int TOKEN_FILTERRESULTSET_C = 3401;
    public static final int TOKEN_FILTERRESULT_O = 3402;
    public static final int TOKEN_FILTERRESULT_C = 3403;
    public static final int TOKEN_LOCATIONREFERENCE_O = 3500;
    public static final int TOKEN_LOCATIONREFERENCE_C = 3501;
    public static final int TOKEN_DI_O = 3600;
    public static final int TOKEN_DI_C = 3601;
    public static final int TOKEN_DV_O = 3700;
    public static final int TOKEN_DV_C = 3701;
    public static final int TOKEN_FMTVAL_O = 3800;
    public static final int TOKEN_FMTVAL_C = 3801;
    public static final int TOKEN_HTML_O = 3900;
    public static final int TOKEN_HTML_C = 3901;
    public static final int TOKEN_BMRK_O = 4001;
    public static final int TOKEN_BMRK_C = 4002;
    public static final int TOKEN_RPT_O = 5000;
    public static final int TOKEN_RPT_C = 5001;
    public static final int TOKEN_RPTTBL_O = 5003;
    public static final int TOKEN_RPTTBL_C = 5004;
    public static final int TOKEN_TOC_O = 6000;
    public static final int TOKEN_TOC_C = 6001;
    public static final int TOKEN_TOC_BMRK_O = 6002;
    public static final int TOKEN_TOC_BMRK_C = 6003;
    public static final int TOKEN_TOC_ENTRY_O = 6006;
    public static final int TOKEN_TOC_ENTRY_C = 6007;
    public static final int TOKEN_RTXT_O = 7000;
    public static final int TOKEN_RTXT_C = 7001;
    public static final int TOKEN_RTXT_SPAN_O = 7002;
    public static final int TOKEN_RTXT_SPAN_C = 7003;
    public static final int TOKEN_RTXT_DIV_O = 7004;
    public static final int TOKEN_RTXT_DIV_C = 7005;
    public static final int TOKEN_RTLST_ORDER_O = 7006;
    public static final int TOKEN_RTLST_ORDER_C = 7007;
    public static final int TOKEN_RTLST_ITEM_O = 7008;
    public static final int TOKEN_RTLST_ITEM_C = 7009;
    public static final int TOKEN_RTLST_O = 7010;
    public static final int TOKEN_RTLST_C = 7011;
    public static final int TOKEN_CTX_O = 8000;
    public static final int TOKEN_CTX_C = 8001;
    public static final int TOKEN_PAGEGROUP_O = 9000;
    public static final int TOKEN_PAGEGROUP_C = 9001;
    public static final int TOKEN_DRILLS_O = 10000;
    public static final int TOKEN_DRILLS_C = 10001;
    public static final int TOKEN_DEPTH_O = 11000;
    public static final int TOKEN_DEPTH_C = 11001;
    public static final int TOKEN_HLINK_O = 12000;
    public static final int TOKEN_HLINK_C = 12001;
    public static final int TOKEN_LCR_O = 13000;
    public static final int TOKEN_LCR_C = 13001;
    public static final int TOKEN_CANDRILLUP_O = 15000;
    public static final int TOKEN_CANDRILLUP_C = 15001;
    public static final int TOKEN_CANDRILLDN_O = 15002;
    public static final int TOKEN_CANDRILLDN_C = 15003;
    public static final int TOKEN_ITEMS_O = 16300;
    public static final int TOKEN_ITEMS_C = 16301;
    public static final int TOKEN_SIZE_O = 16500;
    public static final int TOKEN_SIZE_C = 16501;
    public static final int TOKEN_INDENT_O = 16600;
    public static final int TOKEN_INDENT_C = 16601;
    public static final int TOKEN_TARGET_O = 16700;
    public static final int TOKEN_TARGET_C = 16701;
    public static final int TOKEN_HRLAYOUT_O = 16800;
    public static final int TOKEN_HRLAYOUT_C = 16801;
    public static final int TOKEN_HRSIZE_O = 16900;
    public static final int TOKEN_HRSIZE_C = 16901;
    public static final int TOKEN_VRSIZE_O = 17000;
    public static final int TOKEN_VRSIZE_C = 17001;
    public static final int TOKEN_CONTENTS_O = 17100;
    public static final int TOKEN_CONTENTS_C = 17101;
    public static final int TOKEN_ANNURL_O = 17200;
    public static final int TOKEN_ANNURL_C = 17201;
    public static final int TOKEN_REPORTPATH_O = 17300;
    public static final int TOKEN_REPORTPATH_C = 17301;
    public static final int TOKEN_VALIGN_O = 17400;
    public static final int TOKEN_VALIGN_C = 17401;
    public static final int TOKEN_DRILLACTION_O = 17500;
    public static final int TOKEN_DRILLACTION_C = 17501;
    public static final int TOKEN_DIRECTION_O = 17600;
    public static final int TOKEN_DIRECTION_C = 17601;
    public static final int TOKEN_ISCMMMAP_O = 17700;
    public static final int TOKEN_ISCMMMAP_C = 17701;
    public static final int TOKEN_WIDGET_O = 17800;
    public static final int TOKEN_WIDGET_C = 17801;
    public static final int TOKEN_WIDGETURI_O = 17900;
    public static final int TOKEN_WIDGETURI_C = 17901;
    public static final int TOKEN_STOREID_O = 18000;
    public static final int TOKEN_STOREID_C = 18001;
    public static final int TOKEN_FONT_O = 100000;
    public static final int TOKEN_FONT_C = 100001;
    public static final int TOKEN_FAMILY_O = 100002;
    public static final int TOKEN_FAMILY_C = 100003;
    public static final int TOKEN_UNITS_O = 100006;
    public static final int TOKEN_UNITS_C = 100007;
    public static final int TOKEN_FONTSTYLE_O = 100008;
    public static final int TOKEN_FONTSTYLE_C = 100009;
    public static final int TOKEN_BOLD_O = 100010;
    public static final int TOKEN_BOLD_C = 100011;
    public static final int TOKEN_UNDERLINE_O = 100012;
    public static final int TOKEN_UNDERLINE_C = 100013;
    public static final int TOKEN_BOXSTYLE_O = 100014;
    public static final int TOKEN_BOXSTYLE_C = 100015;
    public static final int TOKEN_BORDER_O = 100016;
    public static final int TOKEN_BORDER_C = 100017;
    public static final int TOKEN_TOP_O = 100018;
    public static final int TOKEN_TOP_C = 100019;
    public static final int TOKEN_WIDTH_O = 100020;
    public static final int TOKEN_WIDTH_C = 100021;
    public static final int TOKEN_HEIGHT_O = 100022;
    public static final int TOKEN_HEIGHT_C = 100023;
    public static final int TOKEN_LEFT_O = 100024;
    public static final int TOKEN_LEFT_C = 100025;
    public static final int TOKEN_RIGHT_O = 100026;
    public static final int TOKEN_RIGHT_C = 100027;
    public static final int TOKEN_BOTTOM_O = 100028;
    public static final int TOKEN_BOTTOM_C = 100029;
    public static final int TOKEN_FGCOLOR_O = 100030;
    public static final int TOKEN_FGCOLOR_C = 100031;
    public static final int TOKEN_RED_O = 100032;
    public static final int TOKEN_RED_C = 100033;
    public static final int TOKEN_GREEN_O = 100034;
    public static final int TOKEN_GREEN_C = 100035;
    public static final int TOKEN_BLUE_O = 100036;
    public static final int TOKEN_BLUE_C = 100037;
    public static final int TOKEN_HALIGN_O = 100038;
    public static final int TOKEN_HALIGN_C = 100039;
    public static final int TOKEN_BGCOLOR_O = 100042;
    public static final int TOKEN_BGCOLOR_C = 100043;
    public static final int TOKEN_TEXTSTYLE_O = 100044;
    public static final int TOKEN_TEXTSTYLE_C = 100045;
    public static final int TOKEN_STRICTLINEBREAKING_O = 100046;
    public static final int TOKEN_STRICTLINEBREAKING_C = 100047;
    public static final int TOKEN_WRAPPING_O = 100048;
    public static final int TOKEN_WRAPPING_C = 100049;
    public static final int TOKEN_LOC_O = 100050;
    public static final int TOKEN_LOC_C = 100051;
    public static final int TOKEN_REGIONS_O = 110000;
    public static final int TOKEN_REGIONS_C = 110001;
    public static final int TOKEN_AREA_O = 110002;
    public static final int TOKEN_AREA_C = 110003;
    public static final int TOKEN_TYPE_O = 110004;
    public static final int TOKEN_TYPE_C = 110005;
    public static final int TOKEN_LABEL_O = 110006;
    public static final int TOKEN_LABEL_C = 110007;
    public static final int TOKEN_COORD_O = 110008;
    public static final int TOKEN_COORD_C = 110009;
    public static final int TOKEN_X_O = 110010;
    public static final int TOKEN_X_C = 110011;
    public static final int TOKEN_Y_O = 110012;
    public static final int TOKEN_Y_C = 110013;
    public static final int TOKEN_DRILLREF_O = 110016;
    public static final int TOKEN_DRILLREF_C = 110017;
    public static final int TOKEN_DRILL_O = 110018;
    public static final int TOKEN_DRILL_C = 110019;
    public static final int TOKEN_TARGETPATH_O = 110020;
    public static final int TOKEN_TARGETPATH_C = 110021;
    public static final int TOKEN_MODELPATHS_O = 110022;
    public static final int TOKEN_MODELPATHS_C = 110023;
    public static final int TOKEN_OBJECTPATH_O = 110024;
    public static final int TOKEN_OBJECTPATH_C = 110025;
    public static final int TOKEN_PARM_O = 110026;
    public static final int TOKEN_PARM_C = 110027;
    public static final int TOKEN_VALUE_O = 110028;
    public static final int TOKEN_VALUE_C = 110029;
    public static final int TOKEN_DRILLDEFINITIONS_O = 110030;
    public static final int TOKEN_DRILLDEFINITIONS_C = 110031;
    public static final int TOKEN_PARAMETERS_O = 110032;
    public static final int TOKEN_PARAMETERS_C = 110033;
    public static final int TOKEN_PARAMETER_O = 110034;
    public static final int TOKEN_PARAMETER_C = 110035;
    public static final int TOKEN_RDSERROR_O = 110036;
    public static final int TOKEN_RDSERROR_C = 110037;
    public static final int TOKEN_RDSMESSAGE_O = 110038;
    public static final int TOKEN_RDSMESSAGE_C = 110039;
    public static final int TOKEN_ERROR_O = 110040;
    public static final int TOKEN_ERROR_C = 110041;
    public static final int TOKEN_MESSAGE_O = 110042;
    public static final int TOKEN_MESSAGE_C = 110043;
    public static final int TOKEN_LINESTYLE_O = 110044;
    public static final int TOKEN_LINESTYLE_C = 110045;
    public static final int TOKEN_ITALICS_O = 110048;
    public static final int TOKEN_ITALICS_C = 110049;
    public static final int TOKEN_RDSTRACE_O = 110050;
    public static final int TOKEN_RDSTRACE_C = 110051;
    public static final int TOKEN_TBL_O = 120000;
    public static final int TOKEN_TBL_C = 120001;
    public static final int TOKEN_TROW_O = 120002;
    public static final int TOKEN_TROW_C = 120003;
    public static final int TOKEN_TCELL_O = 120004;
    public static final int TOKEN_TCELL_C = 120005;
    public static final int TOKEN_BLK_O = 120006;
    public static final int TOKEN_BLK_C = 120007;
    public static final int TOKEN_SNGL_O = 120008;
    public static final int TOKEN_SNGL_C = 120009;
    public static final int TOKEN_POSID_O = 130000;
    public static final int TOKEN_POSID_C = 130001;
    public static final int TOKEN_RDSCMID_O = 130002;
    public static final int TOKEN_RDSCMID_C = 130003;
    public static final int TOKEN_RDSCMSTYLE_O = 130004;
    public static final int TOKEN_RDSCMSTYLE_C = 130005;
    public static final int TOKEN_LTABLE_O = 130006;
    public static final int TOKEN_LTABLE_C = 130007;
    public static final int TOKEN_LCONTAINER_O = 130008;
    public static final int TOKEN_LCONTAINER_C = 130009;
    public static final int TOKEN_LREFERENCE_O = 130010;
    public static final int TOKEN_LREFERENCE_C = 130011;
    public static final int TOKEN_RDSCMSTYLEGROUP_O = 130012;
    public static final int TOKEN_RDSCMSTYLEGROUP_C = 130013;
    public static final int TOKEN_RDSCMNAME_O = 130014;
    public static final int TOKEN_RDSCMNAME_C = 130015;
    public static final int TOKEN_RDSCMHALIGN_O = 130016;
    public static final int TOKEN_RDSCMHALIGN_C = 130017;
    public static final int TOKEN_RDSCMVALIGN_O = 130018;
    public static final int TOKEN_RDSCMVALIGN_C = 130019;
    public static final int TOKEN_RDSCMHEIGHT_O = 130020;
    public static final int TOKEN_RDSCMHEIGHT_C = 130021;
    public static final int TOKEN_RDSCMWIDTH_O = 130022;
    public static final int TOKEN_RDSCMWIDTH_C = 130023;
    public static final int TOKEN_RDSCMVAL_O = 130024;
    public static final int TOKEN_RDSCMVAL_C = 130025;
    public static final int TOKEN_RDSCMUNITS_O = 130026;
    public static final int TOKEN_RDSCMUNITS_C = 130027;
    public static final int TOKEN_SECONDARYOPERATIONS_O = 130028;
    public static final int TOKEN_SECONDARYOPERATIONS_C = 130029;
    public static final int TOKEN_ALPHA_O = 130030;
    public static final int TOKEN_ALPHA_C = 130031;
    public static final int TOKEN_HIDDEN_O = 130032;
    public static final int TOKEN_HIDDEN_C = 130033;
    public static final int TOKEN_DISPLAY_O = 130034;
    public static final int TOKEN_DISPLAY_C = 130035;
    public static final int TOKEN_COLOR_O = 130036;
    public static final int TOKEN_COLOR_C = 130037;
    public static final int TOKEN_MUN_O = 130038;
    public static final int TOKEN_MUN_C = 130039;
    public static final int TOKEN_CGSDATA_O = 130040;
    public static final int TOKEN_CGSDATA_C = 130041;
    public static final int TOKEN_CGSDATAINFO_O = 130042;
    public static final int TOKEN_CGSDATAINFO_C = 130043;
    public static final int TOKEN_CGSCOLINFO_O = 130044;
    public static final int TOKEN_CGSCOLINFO_C = 130045;
    public static final int TOKEN_EXTENSION_O = 130050;
    public static final int TOKEN_EXTENSION_C = 130051;
    public static final int TOKEN_P_PNAME_O = 140001;
    public static final int TOKEN_P_PNAME_C = 140002;
    public static final int TOKEN_P_ID_O = 140003;
    public static final int TOKEN_P_ID_C = 140004;
    public static final int TOKEN_P_MULTI_O = 140005;
    public static final int TOKEN_P_MULTI_C = 140006;
    public static final int TOKEN_P_RANGE_O = 140007;
    public static final int TOKEN_P_RANGE_C = 140008;
    public static final int TOKEN_P_NOADORN_O = 140009;
    public static final int TOKEN_P_NOADORN_C = 1400010;
    public static final int TOKEN_P_USE_O = 1400011;
    public static final int TOKEN_P_USE_C = 0x155CCC;
    public static final int TOKEN_P_DISP_O = 1400013;
    public static final int TOKEN_P_DISP_C = 1400014;
    public static final int TOKEN_P_SVAL_O = 1400015;
    public static final int TOKEN_P_SVAL_C = 1400016;
    public static final int TOKEN_P_MIN_O = 1400017;
    public static final int TOKEN_P_MIN_C = 1400018;
    public static final int TOKEN_P_MAX_O = 1400019;
    public static final int TOKEN_P_MAX_C = 1400020;
    public static final int TOKEN_P_RVAL_O = 1400021;
    public static final int TOKEN_P_RVAL_C = 1400022;
    public static final int TOKEN_P_REQ_O = 1400023;
    public static final int TOKEN_P_REQ_C = 1400024;
    public static final int TOKEN_P_CNAME_O = 1400025;
    public static final int TOKEN_P_CNAME_C = 1400026;
    public static final int TOKEN_P_SELCHOICES_O = 1400027;
    public static final int TOKEN_P_SELCHOICES_C = 1400028;
    public static final int TOKEN_P_NULL_USE_O = 1400029;
    public static final int TOKEN_P_NULL_USE_C = 1400030;
    public static final int TOKEN_P_NULL_DISP_O = 1400031;
    public static final int TOKEN_P_NULL_DISP_C = 1400032;
    public static final int TOKEN_P_BTN_O = 141001;
    public static final int TOKEN_P_BTN_C = 141002;
    public static final int TOKEN_P_BTN_BTYPE_O = 141003;
    public static final int TOKEN_P_BTN_BTYPE_C = 141004;
    public static final int TOKEN_P_TXTBOX_O = 142001;
    public static final int TOKEN_P_TXTBOX_C = 142002;
    public static final int TOKEN_P_TXTBOX_NUM_O = 142003;
    public static final int TOKEN_P_TXTBOX_NUM_C = 142004;
    public static final int TOKEN_P_TXTBOX_MLINE_O = 142005;
    public static final int TOKEN_P_TXTBOX_MLINE_C = 142006;
    public static final int TOKEN_P_TXTBOX_HTXT_O = 142007;
    public static final int TOKEN_P_TXTBOX_HTXT_C = 142008;
    public static final int TOKEN_P_TXTBOX_THSEP_O = 142009;
    public static final int TOKEN_P_TXTBOX_THSEP_C = 142010;
    public static final int TOKEN_P_VALUE_O = 143001;
    public static final int TOKEN_P_VALUE_C = 143002;
    public static final int TOKEN_P_VALUE_SELECTUI_O = 143003;
    public static final int TOKEN_P_VALUE_SELECTUI_C = 143004;
    public static final int TOKEN_P_VALUE_AUTO_O = 143007;
    public static final int TOKEN_P_VALUE_AUTO_C = 143008;
    public static final int TOKEN_P_VALUE_CASCADEON_O = 143009;
    public static final int TOKEN_P_VALUE_CASCADEON_C = 143010;
    public static final int TOKEN_P_VALUE_PREPOPULATE_O = 143011;
    public static final int TOKEN_P_VALUE_PREPOPULATE_C = 143012;
    public static final int TOKEN_P_VALUE_ROWS_O = 143013;
    public static final int TOKEN_P_VALUE_ROWS_C = 143014;
    public static final int TOKEN_P_VALUE_DISABLED_O = 143015;
    public static final int TOKEN_P_VALUE_DISABLED_C = 143016;
    public static final int TOKEN_P_VALUE_AUTOCASCADE_O = 143017;
    public static final int TOKEN_P_VALUE_AUTOCASCADE_C = 143018;
    public static final int TOKEN_P_VALUE_SELOPTIONS_O = 143019;
    public static final int TOKEN_P_VALUE_SELOPTIONS_C = 143020;
    public static final int TOKEN_P_DATE_O = 144001;
    public static final int TOKEN_P_DATE_C = 144002;
    public static final int TOKEN_P_DATE_DATEUI_O = 144003;
    public static final int TOKEN_P_DATE_DATEUI_C = 144004;
    public static final int TOKEN_P_DATE_CLNDR_O = 144005;
    public static final int TOKEN_P_DATE_CLNDR_C = 144006;
    public static final int TOKEN_P_DATE_FDATE_O = 144007;
    public static final int TOKEN_P_DATE_FDATE_C = 144008;
    public static final int TOKEN_P_DATE_LDATE_O = 144009;
    public static final int TOKEN_P_DATE_LDATE_C = 144010;
    public static final int TOKEN_P_TIME_O = 145001;
    public static final int TOKEN_P_TIME_C = 145002;
    public static final int TOKEN_P_TIME_TIMEUI_O = 145003;
    public static final int TOKEN_P_TIME_TIMEUI_C = 145004;
    public static final int TOKEN_P_TIME_CMODE_O = 145005;
    public static final int TOKEN_P_TIME_CMODE_C = 145006;
    public static final int TOKEN_P_TIME_SECNDS_O = 145007;
    public static final int TOKEN_P_TIME_SECNDS_C = 145008;
    public static final int TOKEN_P_TIME_MILISECS_O = 145009;
    public static final int TOKEN_P_TIME_MILISECS_C = 145010;
    public static final int TOKEN_P_DTIME_O = 146001;
    public static final int TOKEN_P_DTIME_C = 146002;
    public static final int TOKEN_P_INTRVL_O = 147001;
    public static final int TOKEN_P_INTRVL_C = 147002;
    public static final int TOKEN_P_DSRC_O = 148001;
    public static final int TOKEN_P_DSRC_C = 148002;
    public static final int TOKEN_P_DSRC_SRCNAME_O = 148003;
    public static final int TOKEN_P_DSRC_SRCNAME_C = 148004;
    public static final int TOKEN_P_DSRC_CONN_O = 148005;
    public static final int TOKEN_P_DSRC_CONN_C = 148006;
    public static final int TOKEN_P_DSRC_PATH_O = 148007;
    public static final int TOKEN_P_DSRC_PATH_C = 148008;
    public static final int TOKEN_P_DSRC_SELECTED_O = 148009;
    public static final int TOKEN_P_DSRC_SELECTED_C = 148010;
    public static final int TOKEN_P_DSRC_SIGNON_O = 148011;
    public static final int TOKEN_P_DSRC_SIGNON_C = 148012;
    public static final int TOKEN_P_DSRC_FAULTCODE_O = 148013;
    public static final int TOKEN_P_DSRC_FAULTCODE_C = 148014;
    public static final int TOKEN_P_DSRC_FAULTSTRING_O = 148015;
    public static final int TOKEN_P_DSRC_FAULTSTRING_C = 148016;
    public static final int TOKEN_P_SRCH_O = 149001;
    public static final int TOKEN_P_SRCH_C = 149002;
    public static final int TOKEN_P_SRCH_MTCHANY_O = 149003;
    public static final int TOKEN_P_SRCH_MTCHANY_C = 149004;
    public static final int TOKEN_P_SRCH_NORESULTS_O = 149005;
    public static final int TOKEN_P_SRCH_NORESULTS_C = 149006;
    public static final int TOKEN_P_SRCH_MTCHALL_O = 149007;
    public static final int TOKEN_P_SRCH_MTCHALL_C = 149008;
    public static final int TOKEN_P_SRCH_SRCHVAL_O = 149009;
    public static final int TOKEN_P_SRCH_SRCHVAL_C = 149010;
    public static final int TOKEN_P_SRCH_NOCASE_O = 149011;
    public static final int TOKEN_P_SRCH_NOCASE_C = 149012;
    public static final int TOKEN_P_SRCH_PREPOP_O = 149013;
    public static final int TOKEN_P_SRCH_PREPOP_C = 149014;
    public static final int TOKEN_P_SRCH_SHOWOPT_O = 149015;
    public static final int TOKEN_P_SRCH_SHOWOPT_C = 149016;
    public static final int TOKEN_P_TREE_O = 150001;
    public static final int TOKEN_P_TREE_C = 150002;
    public static final int TOKEN_P_TREE_UI_O = 150003;
    public static final int TOKEN_P_TREE_UI_C = 150004;
    public static final int TOKEN_P_TREE_CASCADEON_O = 143009;
    public static final int TOKEN_P_TREE_CASCADEON_C = 143010;
    public static final int TOKEN_P_TREE_PREPOP_O = 149013;
    public static final int TOKEN_P_TREE_PREPOP_C = 149014;
    public static final int TOKEN_P_TREE_DISABLED_O = 143015;
    public static final int TOKEN_P_TREE_DISABLED_C = 143016;
    public static final int TOKEN_P_TREE_PREPOPLEVELS_O = 150011;
    public static final int TOKEN_P_TREE_PREPOPLEVELS_C = 150012;
    public static final int TOKEN_P_TREE_CANEXPAND_O = 150013;
    public static final int TOKEN_P_TREE_CANEXPAND_C = 150014;
    public static final int TOKEN_P_TREE_MOREDATA_O = 150015;
    public static final int TOKEN_P_TREE_MOREDATA_C = 150016;
    public static final int TOKEN_P_TREE_ANCESTORS_O = 150017;
    public static final int TOKEN_P_TREE_ANCESTORS_C = 150018;
    public static final int TOKEN_BUX_WIDGET_O = 160001;
    public static final int TOKEN_BUX_WIDGET_C = 160002;
    public static final int TOKEN_CAN_FINISH_O = 161001;
    public static final int TOKEN_CAN_FINISH_C = 161002;
    public static final int TOKEN_CAN_NEXT_O = 161003;
    public static final int TOKEN_CAN_NEXT_C = 161004;
    public static final int TOKEN_CAN_BACK_O = 161005;
    public static final int TOKEN_CAN_BACK_C = 161006;
    protected IDocument document;
    protected IGenericElement m_currentElement;
    protected GenericElementStack m_elementStack;
    protected StringBuffer m_recordingBuffer;
    protected int depthElement;
    protected int depthFsm;
    protected boolean m_processPage;
    private String m_handlerID;
    protected boolean m_testing;
    private boolean inStyleElement;
    private boolean inStyleGroupElement;
    private boolean inStyleGroupNameElement;
    private boolean ignoreNextElements;
    private boolean firstPages;
    private boolean hasWidget;
    private boolean inPageGroup;
    public static final Map<String, Integer> m_TokenMap;
    protected BufferedWriter m_OutputWriter = null;
    protected FilterFSM m_fsm = NullFSM.getNullFsmRef();
    protected Stack m_fsmStack = new Stack();
    protected Vector m_XpathLoc = new Vector();
    protected int m_XpathCursor = 0;
    protected HashMap m_globalValues = new HashMap();
    protected StringBuffer m_textnodeBuff = null;
    protected boolean m_bEcho = false;
    protected boolean m_bEraseLastTag = false;
    protected int m_pendingEvent = -1;
    protected boolean m_skipNext = false;
    protected OutputStream out;
    private String recordNode;

    public LdxHandler(IDocument document, boolean processPage, boolean testing) {
        this.setOutStream(new NullOutputStream());
        this.document = document;
        this.depthElement = -1;
        this.depthFsm = -1;
        this.m_processPage = processPage;
        this.m_testing = testing;
        this.m_handlerID = this.generateHandlerID();
        this.ignoreNextElements = false;
        this.firstPages = true;
        this.inPageGroup = false;
        this.m_elementStack = document.createGenericElementStack();
        this.m_currentElement = this.m_elementStack.emptyInstance();
    }

    public static int lookupToken(String node, boolean open) {
        Integer val;
        int iToken = 0;
        if (!open) {
            ++iToken;
        }
        if ((val = m_TokenMap.get(node)) == null) {
            return -1;
        }
        return iToken + val;
    }

    public int getToken(String node, boolean open) {
        return LdxHandler.lookupToken(node, open);
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setCurrentElement(IGenericElement reportElement) {
        this.m_currentElement = reportElement;
    }

    public IGenericElement getCurrentElement() {
        return this.m_currentElement;
    }

    public IGenericElement createElement(int elementType) {
        return this.document.createElement(elementType, this.getCurrentElement());
    }

    public IGenericElement createElement(int elementType, IGenericElement parentElement) {
        return this.document.createElement(elementType, parentElement);
    }

    public void createAndAddElement(int elementType) {
        IGenericElement element = this.document.createElement(elementType, this.getCurrentElement());
        this.addElement(element, this.getCurrentElement());
    }

    public void createAndAddElement(int elementType, IElement parentElement) {
        IGenericElement element = this.document.createElement(elementType, this.getCurrentElement());
        this.addElement(element, parentElement);
    }

    public void addElement(IGenericElement reportElement, IGenericElement parentElement) {
        this.addElement(reportElement, parentElement, this.getCurrentElement());
    }

    public void addElement(IGenericElement reportElement, IGenericElement treeParentElement, IGenericElement stackParentElement) {
        this.m_elementStack.push(stackParentElement);
        if (treeParentElement == null) {
            treeParentElement = this.getCurrentElement();
        }
        treeParentElement.addChild(reportElement);
        this.setCurrentElement(reportElement);
        ++this.depthElement;
    }

    public void popCurrentElement() {
        this.setCurrentElement(this.m_elementStack.pop());
        if (this.getCurrentElement() == null) {
            this.setCurrentElement(NullElement.instance());
        }
        --this.depthElement;
    }

    public void clearElements() {
        this.m_elementStack.empty();
        this.setCurrentElement(NullElement.instance());
        this.depthElement = -1;
    }

    public IGenericElement getParentElement() {
        try {
            return this.m_elementStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public boolean useInlineStyles() {
        return false;
    }

    public static String encodeName(String name) {
        return name;
    }

    public String nameElement(String specRef) {
        String root = specRef.substring(specRef.lastIndexOf(47) + 1);
        int indexPortion = root.lastIndexOf(91);
        if (indexPortion > -1) {
            root = root.substring(indexPortion + 1, root.length() - 2);
        }
        return root;
    }

    public void startRecording() {
        this.m_recordingBuffer = new StringBuffer();
    }

    public void stopRecording() {
        this.m_recordingBuffer = null;
    }

    public String getRecordedText() {
        return this.m_recordingBuffer == null ? "" : this.m_recordingBuffer.toString();
    }

    public String getTextNode() {
        return this.m_textnodeBuff == null ? "" : this.m_textnodeBuff.toString();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name;
        String string = name = localName.length() == 0 ? qName : localName;
        if ("pageGroup".equals(name)) {
            this.inPageGroup = true;
        }
        if ("widget".equals(name)) {
            this.hasWidget = true;
        }
        if ("pages".equals(name) && !this.inPageGroup) {
            if (this.firstPages) {
                this.firstPages = false;
            } else if (this.hasWidget) {
                this.ignoreNextElements = true;
            }
        }
        if (!this.ignoreNextElements) {
            this.m_XpathLoc.add(name);
            ++this.m_XpathCursor;
            int eventToken = this.getToken(name, true);
            if (eventToken != -1) {
                this.m_fsm.processEvent(eventToken);
                if (this.m_pendingEvent != -1) {
                    int eventToSend = this.m_pendingEvent;
                    this.m_pendingEvent = -1;
                    this.m_fsm.processEvent(eventToSend);
                }
            }
            if ("document".equals(name) && this.getProcessPage() || this.m_bEcho && !this.m_skipNext) {
                try {
                    this.m_OutputWriter.write(OPEN_TAG);
                    this.m_OutputWriter.write(name);
                    int attrCount = attributes.getLength();
                    if (attrCount > 0) {
                        for (int i = 0; i < attrCount; ++i) {
                            this.m_OutputWriter.write(" " + (attributes.getLocalName(i).length() == 0 ? attributes.getQName(i) : attributes.getLocalName(i)));
                            this.m_OutputWriter.write("=\"" + attributes.getValue(i) + "\"");
                        }
                    }
                    this.m_OutputWriter.write(CLOSE_TAG);
                    if (eventToken == 2400) {
                        this.inStyleElement = true;
                    } else if (eventToken == 3000) {
                        this.inStyleGroupElement = true;
                    } else if (eventToken == 1100 && this.inStyleGroupElement) {
                        this.inStyleGroupNameElement = true;
                    }
                }
                catch (IOException e) {
                    VM.log(CLASS, 3, "failed writing to output writer in 'startElement'", e);
                    throw new SAXException(e);
                }
            }
            this.m_skipNext = false;
            if (this.m_recordingBuffer != null) {
                this.m_recordingBuffer.append(OPEN_TAG);
                this.m_recordingBuffer.append(name);
                if (localName.equals("styleGroup")) {
                    this.m_recordingBuffer.append(NS);
                }
                this.m_recordingBuffer.append(CLOSE_TAG);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.m_textnodeBuff != null) {
                this.m_textnodeBuff.append(ch, start, length);
            }
            if (this.m_bEcho) {
                String text = this.inStyleElement || this.inStyleGroupNameElement ? this.generateStyleName(this.escapeIfNeeded(ch, start, length)) : this.escapeIfNeeded(ch, start, length);
                this.m_OutputWriter.write(text);
            }
        }
        catch (IOException e) {
            VM.log(CLASS, 3, "failed writing to output writer in 'characters'", e);
            throw new SAXException(e);
        }
        if (this.m_recordingBuffer != null) {
            this.m_recordingBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name = localName.length() == 0 ? qName : localName;
        if (!this.ignoreNextElements) {
            try {
                int eventToken = this.getToken(name, false);
                this.m_XpathLoc.removeElementAt(--this.m_XpathCursor);
                if (eventToken != -1) {
                    this.m_fsm.processEvent(eventToken);
                    if (this.m_pendingEvent != -1) {
                        int eventToSend = this.m_pendingEvent;
                        this.m_pendingEvent = -1;
                        this.m_fsm.processEvent(eventToSend);
                    }
                }
                if (this.m_bEcho && !this.m_skipNext) {
                    this.m_OutputWriter.write(OPEN_ETAG);
                    this.m_OutputWriter.write(name);
                    this.m_OutputWriter.write(CLOSE_TAG);
                    if (eventToken == 2401) {
                        this.inStyleElement = false;
                    } else if (eventToken == 3001) {
                        this.inStyleGroupElement = false;
                    } else if (eventToken == 1101) {
                        this.inStyleGroupNameElement = false;
                    }
                } else if (this.m_skipNext) {
                    this.m_skipNext = false;
                }
            }
            catch (IOException e) {
                VM.log(CLASS, 3, "failed writing to output writer in 'endElement'", e);
                throw new SAXException(e);
            }
            if (this.m_recordingBuffer != null) {
                this.m_recordingBuffer.append(OPEN_ETAG);
                this.m_recordingBuffer.append(name);
                this.m_recordingBuffer.append(CLOSE_TAG);
            }
        }
        if ("pages".equals(name) && this.ignoreNextElements) {
            this.ignoreNextElements = false;
        } else if ("pageGroup".equals(name)) {
            this.inPageGroup = false;
        }
    }

    public void pushFsm(FilterFSM pFsm) {
        ++this.depthFsm;
        this.m_fsmStack.push(this.m_fsm);
        this.m_fsm = pFsm;
    }

    public void pushFsm(LdxElement pFsm) {
        this.pushFsm((FilterFSM)pFsm);
    }

    public void popFsm() {
        this.m_fsm = (FilterFSM)this.m_fsmStack.pop();
        if (this.m_fsm == null) {
            this.m_fsm = NullFSM.getNullFsmRef();
        }
        --this.depthFsm;
    }

    public FilterFSM getParentFSM() {
        return (FilterFSM)this.m_fsmStack.get(this.m_fsmStack.size() - 1);
    }

    public boolean getProcessPage() {
        return this.m_processPage;
    }

    private String generateHandlerID() {
        if (this.isTesting()) {
            return "test";
        }
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return token.substring(0, 4);
    }

    public String generateStyleName(String initName) {
        if (initName == null) {
            return null;
        }
        return this.m_processPage ? initName : initName + "-" + this.m_handlerID;
    }

    public boolean isTesting() {
        return this.m_testing;
    }

    public Prompt getPrompt() {
        return this.m_currentElement.getPrompt();
    }

    private String generateIndent(int depth) {
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            indent.append("      ");
        }
        return indent.toString();
    }

    public String tokenDisplayName(int event) {
        switch (event) {
            case -1: {
                return "NOTFOUND";
            }
            case 1000: {
                return "aaa_O";
            }
            case 1001: {
                return "aaa_C";
            }
            case 1010: {
                return "ID_O";
            }
            case 1011: {
                return "ID_C";
            }
            case 1020: {
                return "LST_O";
            }
            case 1021: {
                return "LST_C";
            }
            case 1030: {
                return "CTAB_O";
            }
            case 1031: {
                return "CTAB_C";
            }
            case 1040: {
                return "ROW_O";
            }
            case 1041: {
                return "ROW_C";
            }
            case 1050: {
                return "COLUMN_O";
            }
            case 1051: {
                return "COLUMN_C";
            }
            case 1060: {
                return "MEASURE_O";
            }
            case 1061: {
                return "MEASURE_C";
            }
            case 1070: {
                return "TABLE_O";
            }
            case 1071: {
                return "TABLE_C";
            }
            case 1080: {
                return "VAL_O";
            }
            case 1081: {
                return "VAL_C";
            }
            case 1090: {
                return "NDIM_O";
            }
            case 1091: {
                return "NDIM_C";
            }
            case 1100: {
                return "NAME_O";
            }
            case 1101: {
                return "NAME_C";
            }
            case 1200: {
                return "START_O";
            }
            case 1201: {
                return "START_C";
            }
            case 1300: {
                return "CELL_O";
            }
            case 1301: {
                return "CELL_C";
            }
            case 1400: {
                return "CORNER_O";
            }
            case 1401: {
                return "CORNER_C";
            }
            case 1500: {
                return "CSPAN_O";
            }
            case 1501: {
                return "CSPAN_C";
            }
            case 1600: {
                return "RSPAN_O";
            }
            case 1601: {
                return "RSPAN_C";
            }
            case 1700: {
                return "COLTITLE_O";
            }
            case 1701: {
                return "COLTITLE_C";
            }
            case 1800: {
                return "GROUP_O";
            }
            case 1801: {
                return "GROUP_C";
            }
            case 1900: {
                return "GRP_O";
            }
            case 1901: {
                return "GRP_C ";
            }
            case 2000: {
                return "FOOTER_O";
            }
            case 2001: {
                return "FOOTER_C";
            }
            case 2100: {
                return "HEADER_O";
            }
            case 2101: {
                return "HEADER_C";
            }
            case 2200: {
                return "REF_O";
            }
            case 2201: {
                return "REF_C";
            }
            case 2300: {
                return "ITEM_O";
            }
            case 2301: {
                return "ITEM_C";
            }
            case 2400: {
                return "STYLE_O";
            }
            case 2401: {
                return "STYLE_C";
            }
            case 2500: {
                return "TXT_O";
            }
            case 2501: {
                return "TXT_C";
            }
            case 2600: {
                return "IMG_O";
            }
            case 2601: {
                return "IMG_C";
            }
            case 2700: {
                return "CHT_O";
            }
            case 2701: {
                return "CHT_C";
            }
            case 2800: {
                return "PAGE_O";
            }
            case 2801: {
                return "PAGE_C";
            }
            case 2900: {
                return "BODY_O";
            }
            case 2901: {
                return "BODY_C";
            }
            case 3000: {
                return "STYLEGROUP_O";
            }
            case 3001: {
                return "STYLEGROUP_C";
            }
            case 3100: {
                return "VERSBASE_O";
            }
            case 3101: {
                return "VERSBASE_C";
            }
            case 3200: {
                return "URL_O";
            }
            case 3201: {
                return "URL_C";
            }
            case 3300: {
                return "DOCUMENT_O";
            }
            case 3301: {
                return "DOCUMENT_C";
            }
            case 3400: {
                return "FILTERRESULTSET_O";
            }
            case 3401: {
                return "FILTERRESULTSET_C";
            }
            case 3402: {
                return "FILTERRESULT_O";
            }
            case 3403: {
                return "FILTERRESULT_C";
            }
            case 3500: {
                return "LOCATIONREFERENCE_O";
            }
            case 3501: {
                return "LOCATIONREFERENCE_C";
            }
            case 3600: {
                return "DI_O";
            }
            case 3601: {
                return "DI_C";
            }
            case 3700: {
                return "DV_O";
            }
            case 3701: {
                return "DV_C";
            }
            case 3800: {
                return "FMTVAL_O";
            }
            case 3801: {
                return "FMTVAL_C";
            }
            case 3900: {
                return "HTML_O";
            }
            case 3901: {
                return "HTML_C";
            }
            case 4001: {
                return "BMRK_O";
            }
            case 4002: {
                return "BMRK_C";
            }
            case 5000: {
                return "RPT_O";
            }
            case 5001: {
                return "RPT_C";
            }
            case 5003: {
                return "RPTTBL_O";
            }
            case 5004: {
                return "RPTTBL_C";
            }
            case 6000: {
                return "TOC_O";
            }
            case 6001: {
                return "TOC_C";
            }
            case 6002: {
                return "TOC_BMRK_O";
            }
            case 6003: {
                return "TOC_BMRK_C";
            }
            case 6006: {
                return "TOC_ENTRY_O";
            }
            case 6007: {
                return "TOC_ENTRY_C";
            }
            case 7000: {
                return "RTXT_O";
            }
            case 7001: {
                return "RTXT_C";
            }
            case 7002: {
                return "RTXT_SPAN_O";
            }
            case 7003: {
                return "RTXT_SPAN_C";
            }
            case 7004: {
                return "RTXT_DIV_O";
            }
            case 7005: {
                return "RTXT_DIV_C";
            }
            case 7006: {
                return "RTLST_ORDER_O";
            }
            case 7007: {
                return "RTLST_ORDER_C";
            }
            case 7008: {
                return "RTLST_ITEM_O";
            }
            case 7009: {
                return "RTLST_ITEM_C";
            }
            case 7010: {
                return "RTLST_O";
            }
            case 7011: {
                return "RTLST_C";
            }
            case 8000: {
                return "CTX_O";
            }
            case 8001: {
                return "CTX_C";
            }
            case 110048: {
                return "ITALICS_O";
            }
            case 110049: {
                return "ITALICS_C";
            }
            case 120000: {
                return "TBL_O";
            }
            case 120001: {
                return "TBL_C";
            }
            case 120002: {
                return "TROW_O";
            }
            case 120003: {
                return "TROW_C";
            }
            case 120004: {
                return "TCELL_O";
            }
            case 120005: {
                return "TCELL_C";
            }
            case 120006: {
                return "BLK_O";
            }
            case 120007: {
                return "BLK_C";
            }
            case 120008: {
                return "SNGL_O";
            }
            case 120009: {
                return "SNGL_C";
            }
            case 100000: {
                return "FONT_O";
            }
            case 100001: {
                return "FONT_C";
            }
            case 100002: {
                return "FAMILY_O";
            }
            case 100003: {
                return "FAMILY_C";
            }
            case 16500: {
                return "SIZE_O";
            }
            case 16501: {
                return "SIZE_C";
            }
            case 100006: {
                return "UNITS_O";
            }
            case 100007: {
                return "UNITS_C";
            }
            case 100008: {
                return "FONTSTYLE_O";
            }
            case 100009: {
                return "FONTSTYLE_C";
            }
            case 100010: {
                return "BOLD_O";
            }
            case 100011: {
                return "BOLD_C";
            }
            case 100012: {
                return "UNDERLINE_O";
            }
            case 100013: {
                return "UNDERLINE_C";
            }
            case 100014: {
                return "BOXSTYLE_O";
            }
            case 100015: {
                return "BOXSTYLE_C";
            }
            case 100016: {
                return "BORDER_O";
            }
            case 100017: {
                return "BORDER_C";
            }
            case 100018: {
                return "TOP_O";
            }
            case 100019: {
                return "TOP_C";
            }
            case 100020: {
                return "WIDTH_O";
            }
            case 100021: {
                return "WIDTH_C";
            }
            case 100022: {
                return "HEIGHT_O";
            }
            case 100023: {
                return "HEIGHT_C";
            }
            case 100024: {
                return "LEFT_O";
            }
            case 100025: {
                return "LEFT_C";
            }
            case 100026: {
                return "RIGHT_O";
            }
            case 100027: {
                return "RIGHT_C";
            }
            case 100028: {
                return "BOTTOM_O";
            }
            case 100029: {
                return "BOTTOM_C";
            }
            case 100030: {
                return "FGCOLOR_O";
            }
            case 100031: {
                return "FGCOLOR_C";
            }
            case 100032: {
                return "RED_O";
            }
            case 100033: {
                return "RED_C";
            }
            case 100034: {
                return "GREEN_O";
            }
            case 100035: {
                return "GREEN_C";
            }
            case 100036: {
                return "BLUE_O";
            }
            case 100037: {
                return "BLUE_C";
            }
            case 100038: {
                return "HALIGN_O";
            }
            case 100039: {
                return "HALIGN_C";
            }
            case 17400: {
                return "VALIGN_O";
            }
            case 17401: {
                return "VALIGN_C";
            }
            case 100042: {
                return "BGCOLOR_O";
            }
            case 100043: {
                return "BGCOLOR_C";
            }
            case 100044: {
                return "TEXTSTYLE_O";
            }
            case 100045: {
                return "TEXTSTYLE_C";
            }
            case 100046: {
                return "STRICTLINEBREAKING_O";
            }
            case 100047: {
                return "STRICTLINEBREAKING_C";
            }
            case 100048: {
                return "WRAPPING_O";
            }
            case 100049: {
                return "WRAPPING_C";
            }
            case 100050: {
                return "LOC_O";
            }
            case 100051: {
                return "LOC_C";
            }
            case 110000: {
                return "REGIONS_O";
            }
            case 110001: {
                return "REGIONS_C";
            }
            case 110002: {
                return "AREA_O";
            }
            case 110003: {
                return "AREA_C";
            }
            case 110004: {
                return "TYPE_O";
            }
            case 110005: {
                return "TYPE_C";
            }
            case 110006: {
                return "LABEL_O";
            }
            case 110007: {
                return "LABEL_C";
            }
            case 110008: {
                return "COORD_O";
            }
            case 110009: {
                return "COORD_C";
            }
            case 110010: {
                return "X_O";
            }
            case 110011: {
                return "X_C";
            }
            case 110012: {
                return "Y_O";
            }
            case 110013: {
                return "Y_C";
            }
            case 10000: {
                return "DRILLS_O";
            }
            case 10001: {
                return "DRILLS_C";
            }
            case 110016: {
                return "DRILLREF_O";
            }
            case 110017: {
                return "DRILLREF_C";
            }
            case 110018: {
                return "TOKEN_DRILL_O";
            }
            case 110019: {
                return "TOKEN_DRILL_C";
            }
            case 110020: {
                return "TOKEN_TARGETPATH_O";
            }
            case 110021: {
                return "TOKEN_TARGETPATH_C";
            }
            case 110022: {
                return "MODELPATHS_O";
            }
            case 110023: {
                return "MODELPATHS_C";
            }
            case 110024: {
                return "OBJECTPATH_O";
            }
            case 110025: {
                return "OBJECTPATH_C";
            }
            case 110026: {
                return "PARM_O";
            }
            case 110027: {
                return "PARM_C";
            }
            case 110028: {
                return "VALUE_O";
            }
            case 110029: {
                return "VALUE_C";
            }
            case 110030: {
                return "TOKEN_DRILLDEFINITIONS_O";
            }
            case 110031: {
                return "TOKEN_DRILLDEFINITIONS_C";
            }
            case 110032: {
                return "PARAMETERS_O";
            }
            case 110033: {
                return "PARAMETERS_C";
            }
            case 110034: {
                return "PARAMETER_O";
            }
            case 110035: {
                return "PARAMETER_C";
            }
            case 110040: {
                return "ERROR_O";
            }
            case 110041: {
                return "ERROR_C";
            }
            case 110042: {
                return "MESSAGE_O";
            }
            case 110043: {
                return "MESSAGE_C";
            }
            case 110044: {
                return "LINESTYLE_O";
            }
            case 110045: {
                return "LINESTYLE_C";
            }
            case 17800: {
                return "TOKEN_WIDGET_O";
            }
            case 17801: {
                return "TOKEN_WIDGET_C";
            }
            case 17900: {
                return "TOKEN_WIDGETURI_O";
            }
            case 17901: {
                return "TOKEN_WIDGETURI_C";
            }
            case 130028: {
                return "TOKEN_SECONDARYOPERATIONS_O";
            }
            case 130029: {
                return "TOKEN_SECONDARYOPERATIONS_C";
            }
            case 160001: {
                return "TOKEN_BUX_WIDGET_O";
            }
            case 160002: {
                return "TOKEN_BUX_WIDGET_C";
            }
            case 130030: {
                return "TOKEN_ALPHA_O";
            }
            case 130031: {
                return "TOKEN_ALPHA_C";
            }
            case 130032: {
                return "TOKEN_HIDDEN_O";
            }
            case 130033: {
                return "TOKEN_HIDDEN_C";
            }
            case 130034: {
                return "TOKEN_DISPLAY_O";
            }
            case 130035: {
                return "TOKEN_DISPLAY_C";
            }
            case 161001: {
                return "TOKEN_CAN_FINISH_O";
            }
            case 161002: {
                return "TOKEN_CAN_FINISH_C";
            }
            case 161003: {
                return "TOKEN_CAN_NEXT_O";
            }
            case 161004: {
                return "TOKEN_CAN_NEXT_C";
            }
            case 161005: {
                return "TOKEN_CAN_BACK_O";
            }
            case 161006: {
                return "TOKEN_CAN_BACK_C";
            }
            case 130036: {
                return "TOKEN_COLOR_O";
            }
            case 130037: {
                return "TOKEN_COLOR_C";
            }
            case 130038: {
                return "TOKEN_MUN_O";
            }
            case 130039: {
                return "TOKEN_MUN_C";
            }
            case 130040: {
                return "TOKEN_CGSDATA_O";
            }
            case 130041: {
                return "TOKEN_CGSDATA_C";
            }
            case 130042: {
                return "TOKEN_CGSDATAINFO_O";
            }
            case 130043: {
                return "TOKEN_CGSDATAINFO_C";
            }
            case 130044: {
                return "TOKEN_CGSCOLINFO_O";
            }
            case 130045: {
                return "TOKEN_CGSCOLINFO_C";
            }
        }
        return "**MISSING** - " + event;
    }

    public void setOutStream(OutputStream out) {
        this.out = out;
        try {
            this.m_OutputWriter = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

    public void setGlobal(String name, Object value) {
        this.m_globalValues.put(name, value);
    }

    public Object getGlobal(String name) {
        return this.m_globalValues.get(name);
    }

    public void injectEvent(int event) {
        this.m_pendingEvent = event;
    }

    public void SetFsm(FilterFSM pFsm) {
        this.m_fsm = pFsm;
    }

    public int getXpathDepth() {
        return this.m_XpathCursor;
    }

    public String getXpathLoc(int start) {
        StringBuffer retval = new StringBuffer();
        for (int i = start; i < this.m_XpathCursor; ++i) {
            retval.append("/");
            retval.append(this.m_XpathLoc.get(i));
        }
        return retval.toString();
    }

    public void RecordTextNodeOn() {
        this.m_textnodeBuff = new StringBuffer();
    }

    public void RecordTextNodeOff() {
        this.m_textnodeBuff = null;
        this.recordNode = null;
    }

    public boolean getEchoMode() {
        return this.m_bEcho;
    }

    public void setEchoMode(boolean echo) {
        this.m_bEcho = echo;
    }

    public void skipNextElement() {
        this.m_skipNext = true;
    }

    public void skipLastElement() {
        this.m_bEraseLastTag = true;
    }

    public void write(String tag) {
        try {
            this.m_OutputWriter.write(tag);
        }
        catch (IOException e) {
            VM.log(CLASS, 3, "failed writing to output writer", e);
        }
    }

    public void writeOpen(String tag) {
        this.write(OPEN_TAG);
        this.write(tag);
        this.write(CLOSE_TAG);
    }

    public void writeClose(String tag) {
        this.write(OPEN_ETAG);
        this.write(tag);
        this.write(CLOSE_TAG);
    }

    public void writeElement(String tag, String text) {
        this.writeOpen(tag);
        this.write(this.escapeIfNeeded(text));
        this.writeClose(tag);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.m_OutputWriter.flush();
            if (this.out instanceof PipedOutputStream) {
                this.m_OutputWriter.close();
            }
            if (this.m_fsmStack.size() > 0) {
                throw new SAXException("STACK NOT EMPTY");
            }
        }
        catch (IOException e) {
            VM.log(CLASS, 3, "failed writing to output writer in 'endDocument'", e);
            throw new SAXException(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.ignoreNextElements = false;
            this.firstPages = true;
            this.inPageGroup = false;
            this.hasWidget = false;
        }
        catch (Exception e) {
            VM.log(CLASS, 3, "failed writing to output writer in 'startDocument'", e);
            throw new SAXException(e);
        }
    }

    public void writeAttribute(String name, String value) {
        try {
            this.m_OutputWriter.write(" ");
            this.m_OutputWriter.write(name);
            this.m_OutputWriter.write("=\"");
            this.m_OutputWriter.write(value);
            this.m_OutputWriter.write("\"");
        }
        catch (IOException e) {
            VM.log(CLASS, 3, "failed writing to output writer in 'writeAttribute'", e);
        }
    }

    public String escapeIfNeeded(char[] ch, int start, int length) {
        String value = new String(ch, start, length);
        return this.escapeIfNeeded(value);
    }

    public String escapeIfNeeded(String value) {
        boolean escape = false;
        if (value.indexOf(62) > -1) {
            escape = true;
        } else if (value.indexOf(38) > -1) {
            escape = true;
        } else if (value.indexOf(60) > -1) {
            escape = true;
        } else if (value.indexOf(34) > -1) {
            escape = true;
        } else if (value.indexOf(39) > -1) {
            escape = true;
        }
        if (escape) {
            value = LdxHandler.escapeXML(value);
        }
        return value;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flushOutput() {
        try {
            this.m_OutputWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getRecordNode() {
        return this.recordNode;
    }

    public void setRecordNode(String recordNode) {
        this.recordNode = recordNode;
    }

    public static String escapeXML(String sXML) {
        StringBuffer sBuffer = new StringBuffer(sXML);
        int iPos = 0;
        while (sBuffer.toString().indexOf(38, iPos) != -1) {
            iPos = sBuffer.toString().indexOf(38, iPos);
            sBuffer.deleteCharAt(iPos);
            sBuffer.insert(iPos, "&amp;");
            ++iPos;
        }
        iPos = 0;
        while (sBuffer.toString().indexOf(60, iPos) != -1) {
            iPos = sBuffer.toString().indexOf(60, iPos);
            sBuffer.deleteCharAt(iPos);
            sBuffer.insert(iPos, "&lt;");
            ++iPos;
        }
        iPos = 0;
        while (sBuffer.toString().indexOf(62, iPos) != -1) {
            iPos = sBuffer.toString().indexOf(62, iPos);
            sBuffer.deleteCharAt(iPos);
            sBuffer.insert(iPos, "&gt;");
            ++iPos;
        }
        iPos = 0;
        while (sBuffer.toString().indexOf(39, iPos) != -1) {
            iPos = sBuffer.toString().indexOf(39, iPos);
            sBuffer.deleteCharAt(iPos);
            sBuffer.insert(iPos, "&apos;");
            ++iPos;
        }
        iPos = 0;
        while (sBuffer.toString().indexOf(34, iPos) != -1) {
            iPos = sBuffer.toString().indexOf(34, iPos);
            sBuffer.deleteCharAt(iPos);
            sBuffer.insert(iPos, "&quot;");
            ++iPos;
        }
        return sBuffer.toString();
    }

    static {
        HashMap<String, Integer> tokenMap = new HashMap<String, Integer>();
        tokenMap.put("lst", 1020);
        tokenMap.put("ctab", 1030);
        tokenMap.put("id", 1010);
        tokenMap.put("row", 1040);
        tokenMap.put("column", 1050);
        tokenMap.put("measure", 1060);
        tokenMap.put("table", 1070);
        tokenMap.put("val", 1080);
        tokenMap.put("nestedDimension", 1090);
        tokenMap.put("name", 1100);
        tokenMap.put("start", 1200);
        tokenMap.put("cell", 1300);
        tokenMap.put("corner", 1400);
        tokenMap.put("cspan", 1500);
        tokenMap.put("rspan", 1600);
        tokenMap.put("colTitle", 1700);
        tokenMap.put("group", 1800);
        tokenMap.put("grp", 1900);
        tokenMap.put("header", 2100);
        tokenMap.put("footer", 2000);
        tokenMap.put("ref", 2200);
        tokenMap.put("item", 2300);
        tokenMap.put("style", 2400);
        tokenMap.put("txt", 2500);
        tokenMap.put("img", 2600);
        tokenMap.put("cht", 2700);
        tokenMap.put("page", 2800);
        tokenMap.put("pages", 2802);
        tokenMap.put("body", 2900);
        tokenMap.put("styleGroup", 3000);
        tokenMap.put("versionBase", 3100);
        tokenMap.put("url", 3200);
        tokenMap.put("document", 3300);
        tokenMap.put("filterResultSet", 3400);
        tokenMap.put("filterResult", 3402);
        tokenMap.put("locationReference", 3500);
        tokenMap.put("di", 3600);
        tokenMap.put("dv", 3700);
        tokenMap.put("fmtVal", 3800);
        tokenMap.put("html", 3900);
        tokenMap.put("bmrk", 4001);
        tokenMap.put("rept", 5000);
        tokenMap.put("reptbl", 5003);
        tokenMap.put("toc", 6000);
        tokenMap.put("entry", 6006);
        tokenMap.put("bookmark", 6002);
        tokenMap.put("rtxt", 7000);
        tokenMap.put("span", 7002);
        tokenMap.put("div", 7004);
        tokenMap.put("ordered", 7006);
        tokenMap.put("rtList", 7010);
        tokenMap.put("listItem", 7008);
        tokenMap.put("details", 2704);
        tokenMap.put("ctx", 8000);
        tokenMap.put("pageGroup", 9000);
        tokenMap.put("drills", 10000);
        tokenMap.put("depth", 11000);
        tokenMap.put("hlink", 12000);
        tokenMap.put("lcr", 13000);
        tokenMap.put("drillDefinitions", 110030);
        tokenMap.put("canDrillUp", 15000);
        tokenMap.put("canDrillDown", 15002);
        tokenMap.put("items", 16300);
        tokenMap.put("size", 16500);
        tokenMap.put("indent", 16600);
        tokenMap.put("target", 16700);
        tokenMap.put("horizontalLayout", 16800);
        tokenMap.put("horizontalSize", 16900);
        tokenMap.put("verticalSize", 17000);
        tokenMap.put("contents", 17100);
        tokenMap.put("annURL", 17200);
        tokenMap.put("reportPath", 17300);
        tokenMap.put("drillAction", 17500);
        tokenMap.put("direction", 17600);
        tokenMap.put("isCMMMap", 17700);
        tokenMap.put("widget", 17800);
        tokenMap.put("widgetURI", 17900);
        tokenMap.put("storeID", 18000);
        tokenMap.put("font", 100000);
        tokenMap.put("family", 100002);
        tokenMap.put("units", 100006);
        tokenMap.put("fontStyle", 100008);
        tokenMap.put("bold", 100010);
        tokenMap.put("underline", 100012);
        tokenMap.put("boxstyle", 100014);
        tokenMap.put("border", 100016);
        tokenMap.put("top", 100018);
        tokenMap.put("width", 100020);
        tokenMap.put("height", 100022);
        tokenMap.put("left", 100024);
        tokenMap.put("right", 100026);
        tokenMap.put("bottom", 100028);
        tokenMap.put("fgColor", 100030);
        tokenMap.put("Red", 100032);
        tokenMap.put("Green", 100034);
        tokenMap.put("Blue", 100036);
        tokenMap.put("hAlign", 100038);
        tokenMap.put("vAlign", 17400);
        tokenMap.put("bgColor", 100042);
        tokenMap.put("textStyle", 100044);
        tokenMap.put("strictLineBreaking", 100046);
        tokenMap.put("wrapping", 100048);
        tokenMap.put("loc", 100050);
        tokenMap.put("regions", 110000);
        tokenMap.put("area", 110002);
        tokenMap.put("type", 110004);
        tokenMap.put("label", 110006);
        tokenMap.put("coord", 110008);
        tokenMap.put("x", 110010);
        tokenMap.put("y", 110012);
        tokenMap.put("drillRef", 110016);
        tokenMap.put("drill", 110018);
        tokenMap.put("targetPath", 110020);
        tokenMap.put("modelPaths", 110022);
        tokenMap.put("objectPath", 110024);
        tokenMap.put("parm", 110026);
        tokenMap.put("value", 110028);
        tokenMap.put("parameters", 110032);
        tokenMap.put("parameter", 110034);
        tokenMap.put("rds:error", 110036);
        tokenMap.put("rds:message", 110038);
        tokenMap.put("rds:trace", 110050);
        tokenMap.put("error", 110040);
        tokenMap.put("message", 110042);
        tokenMap.put("lineStyle", 110044);
        tokenMap.put("italics", 110048);
        tokenMap.put("tbl", 120000);
        tokenMap.put("trow", 120002);
        tokenMap.put("tcell", 120004);
        tokenMap.put("blk", 120006);
        tokenMap.put("extension", 130050);
        tokenMap.put("sngl", 120008);
        tokenMap.put("posId", 130000);
        tokenMap.put("rdsCM:id", 130002);
        tokenMap.put("rdsCM:style", 130004);
        tokenMap.put("LTable", 130006);
        tokenMap.put("LContainer", 130008);
        tokenMap.put("LReference", 130010);
        tokenMap.put("rdsCM:styleGroup", 130012);
        tokenMap.put("rdsCM:name", 130014);
        tokenMap.put("rdsCM:hAlign", 130016);
        tokenMap.put("rdsCM:vAlign", 130018);
        tokenMap.put("rdsCM:height", 130020);
        tokenMap.put("rdsCM:width", 130022);
        tokenMap.put("rdsCM:val", 130024);
        tokenMap.put("rdsCM:units", 130026);
        tokenMap.put("secondaryOperations", 130028);
        tokenMap.put("buxWidget", 160001);
        tokenMap.put("Alpha", 130030);
        tokenMap.put("hidden", 130032);
        tokenMap.put("display", 130034);
        tokenMap.put("canFinish", 161001);
        tokenMap.put("canNext", 161003);
        tokenMap.put("canBack", 161005);
        tokenMap.put("color", 130036);
        tokenMap.put("mun", 130038);
        tokenMap.put("cgsData", 130040);
        tokenMap.put("cgsDataInfo", 130042);
        tokenMap.put("cgsColInfo", 130044);
        tokenMap.put("p_btn", 141001);
        tokenMap.put("p_txtbox", 142001);
        tokenMap.put("p_date", 144001);
        tokenMap.put("p_time", 145001);
        tokenMap.put("p_dtime", 146001);
        tokenMap.put("p_intrvl", 147001);
        tokenMap.put("p_value", 143001);
        tokenMap.put("p_tree", 150001);
        tokenMap.put("p_srch", 149001);
        tokenMap.put("p_dsrc", 148001);
        tokenMap.put("req", 1400023);
        tokenMap.put("noadorn", 140009);
        tokenMap.put("pname", 140001);
        tokenMap.put("multi", 140005);
        tokenMap.put("range", 140007);
        tokenMap.put("cname", 1400025);
        tokenMap.put("selChoices", 1400027);
        tokenMap.put("bType", 141003);
        tokenMap.put("num", 142003);
        tokenMap.put("mline", 142005);
        tokenMap.put("htxt", 142007);
        tokenMap.put("thSep", 142009);
        tokenMap.put("use", 1400011);
        tokenMap.put("disp", 1400013);
        tokenMap.put("sval", 1400015);
        tokenMap.put("nullUse", 1400029);
        tokenMap.put("nullDisp", 1400031);
        tokenMap.put("rval", 1400021);
        tokenMap.put("min", 1400017);
        tokenMap.put("max", 1400019);
        tokenMap.put("dateUI", 144003);
        tokenMap.put("clndr", 144005);
        tokenMap.put("fdate", 144007);
        tokenMap.put("ldate", 144009);
        tokenMap.put("timeUI", 145003);
        tokenMap.put("cmode", 145005);
        tokenMap.put("secnds", 145007);
        tokenMap.put("milisecs", 145009);
        tokenMap.put("selectUI", 143003);
        tokenMap.put("auto", 143007);
        tokenMap.put("selOptions", 143019);
        tokenMap.put("disabled", 143015);
        tokenMap.put("cascadeon", 143009);
        tokenMap.put("autocascade", 143017);
        tokenMap.put("treeUI", 150003);
        tokenMap.put("prepopulate", 149013);
        tokenMap.put("prepopulatelevels", 150011);
        tokenMap.put("canExpand", 150013);
        tokenMap.put("moreData", 150015);
        tokenMap.put("ancestors", 150017);
        tokenMap.put("noresults", 149005);
        tokenMap.put("mtchany", 149003);
        tokenMap.put("mtchall", 149007);
        tokenMap.put("srchval", 149009);
        tokenMap.put("nocase", 149011);
        tokenMap.put("showopt", 149015);
        tokenMap.put("dataSourceName", 148003);
        tokenMap.put("searchPath", 148007);
        tokenMap.put("selected", 148009);
        tokenMap.put("signon", 148011);
        tokenMap.put("connection", 148005);
        tokenMap.put("faultcode", 148013);
        tokenMap.put("faultstring", 148015);
        m_TokenMap = Collections.unmodifiableMap(tokenMap);
    }

    public static interface FilterFSM {
        public void processEvent(int var1);

        public void reset();
    }

    protected class NullOutputStream
    extends OutputStream {
        protected NullOutputStream() {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

