/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.xml.XMLHelper;

public abstract class LdxPromptElement
extends LdxElement {
    private String use;
    private String disp;
    private boolean nullUse;
    private boolean nullDisp;
    private String minUse;
    private String minDisp;
    private String maxUse;
    private String maxDisp;
    private boolean inSelChoices;

    public LdxPromptElement(LdxSourceHandler handler) {
        super(handler);
    }

    protected Prompt getPrompt() {
        return this.handler.getPrompt();
    }

    protected String getUse() {
        if (this.nullUse) {
            return null;
        }
        return XMLHelper.encodeXml(this.use);
    }

    protected String getDisp() {
        if (this.nullDisp) {
            return "";
        }
        return XMLHelper.encodeXml(this.disp);
    }

    protected String getMinUse() {
        return this.minUse;
    }

    protected String getMinDisp() {
        return this.minUse;
    }

    protected String getMaxUse() {
        return this.maxUse;
    }

    protected String getMaxDisp() {
        return this.maxUse;
    }

    @Override
    public void processEvent(int event) {
        if (this.getPrompt() == null) {
            return;
        }
        switch (event) {
            case 1010: {
                this.recordText(true);
                break;
            }
            case 1011: {
                this.getPrompt().setId(this.getText());
                break;
            }
            case 1400025: {
                this.recordText(true);
                break;
            }
            case 1400026: {
                this.getPrompt().setColumnName(this.getText());
                break;
            }
            case 1400027: {
                this.inSelChoices = true;
                break;
            }
            case 1400028: {
                this.inSelChoices = false;
                break;
            }
            case 140001: {
                this.recordText(true);
                break;
            }
            case 140002: {
                this.getPrompt().setName(this.getText());
                break;
            }
            case 140009: {
                this.recordText(true);
                break;
            }
            case 1400010: {
                this.getPrompt().setNoAdorn(this.getText().startsWith("t"));
                break;
            }
            case 1400023: {
                this.recordText(true);
                break;
            }
            case 1400024: {
                this.getPrompt().setRequired(this.getText().startsWith("t"));
                break;
            }
            case 140005: {
                this.recordText(true);
                break;
            }
            case 140006: {
                this.getPrompt().setMultiSelect(this.getText().startsWith("t"));
                break;
            }
            case 140007: {
                this.recordText(true);
                break;
            }
            case 140008: {
                this.getPrompt().setRange(this.getText().startsWith("t"));
                break;
            }
            case 142003: {
                this.recordText(true);
                break;
            }
            case 1400021: {
                this.use = null;
                this.disp = null;
                this.minUse = null;
                this.minDisp = null;
                this.maxUse = null;
                this.maxDisp = null;
                this.nullUse = false;
                this.nullDisp = false;
                break;
            }
            case 1400022: {
                if (!this.inSelChoices) break;
                this.getPrompt().addRangeSelection(this.minUse, this.minDisp, this.maxUse, this.maxDisp);
                break;
            }
            case 1400017: {
                break;
            }
            case 1400018: {
                this.minUse = this.use;
                this.minDisp = this.disp;
                break;
            }
            case 1400019: {
                this.use = null;
                this.disp = null;
                this.maxUse = null;
                this.maxDisp = null;
                break;
            }
            case 1400020: {
                this.maxUse = this.use;
                this.maxDisp = this.disp;
                break;
            }
            case 1400015: {
                this.use = null;
                this.disp = null;
                this.nullUse = false;
                this.nullDisp = false;
                break;
            }
            case 1400016: {
                if (!this.inSelChoices) break;
                this.getPrompt().addSelection(this.getUse(), this.getDisp());
                break;
            }
            case 1400011: {
                this.recordText(true);
                break;
            }
            case 0x155CCC: {
                this.use = this.getText();
                break;
            }
            case 1400013: {
                this.recordText(true);
                break;
            }
            case 1400014: {
                this.disp = this.getText();
                break;
            }
            case 1400029: {
                this.recordText(true);
                break;
            }
            case 1400030: {
                this.nullUse = this.getText().startsWith("t");
                break;
            }
            case 1400031: {
                this.recordText(true);
                break;
            }
            case 1400032: {
                this.nullDisp = this.getText().startsWith("t");
                break;
            }
            default: {
                super.processEvent(event);
            }
        }
    }
}

