/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.c8.IReportOutputProcessor;
import com.cognos.mobile.c8.IRunResponse;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IDocumentBasedReport;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LdxReport
implements IReport,
IDocumentBasedReport {
    private static Class CLASS = LdxReport.class;
    private final int m_renderID;
    private final String m_sourcePath;
    private final String m_gatewayUrl;
    private final String m_dispatcherUrl;
    private final String m_cmPath;
    private final String m_label;
    private final String m_drillSignature;
    private final String m_storeID;
    private IDocument m_document;
    private String errorTrace;
    private String m_errorMsg;
    private int m_maxPages;
    private int sourceCode;
    private String m_description;
    private ReportCompiler reportCompiler;
    private final IReportOutputProcessor reportProcessorHost;
    private final String m_burstValue;

    public LdxReport(int renderID, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String cmPath, int maxPages, String drillSignature, String burstValue, int sourceCode, String description, ReportCompiler reportCompiler, IReportOutputProcessor reportRunnerHost, IDocument document) {
        this.m_renderID = renderID;
        this.m_sourcePath = sourcePath;
        this.m_gatewayUrl = gatewayUrl;
        this.m_dispatcherUrl = dispatcherUrl;
        this.m_storeID = storeID;
        this.m_maxPages = maxPages;
        this.m_label = null;
        this.m_drillSignature = drillSignature;
        this.m_cmPath = cmPath;
        this.sourceCode = sourceCode;
        this.m_description = description;
        this.reportCompiler = reportCompiler;
        this.reportProcessorHost = reportRunnerHost;
        this.m_burstValue = burstValue;
        this.m_document = document;
    }

    public LdxReport(int renderID, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String cmPath, int maxPages, String drillSignature, String burstValue, int sourceCode, String description, IReportOutputProcessor reportRunnerHost, IDocument document) {
        this(renderID, sourcePath, gatewayUrl, dispatcherUrl, storeID, cmPath, maxPages, drillSignature, burstValue, sourceCode, description, null, reportRunnerHost, document);
    }

    @Override
    public int processReportOutput(int pageIndex, IRunResponse runResponse, boolean testing) throws CMException {
        this.m_document.ensureDocuments(pageIndex);
        return this.processReportOutput(this.m_document, runResponse, testing, true, null);
    }

    @Override
    public int processReportOutput(IDocument outputDocuments, IRunResponse runResponse, boolean testing, boolean processPage, IGenericElement currentElement) throws CMException {
        if (this.reportCompiler.getReport() == null) {
            this.reportCompiler.setReport(this);
        }
        LdxSourceHandler handler = new LdxSourceHandler(this.m_document, processPage, testing);
        if (currentElement != null) {
            handler.setCurrentElement(currentElement);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(runResponse.getRunOutput(), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException ex) {
            String details = "failed to create page parser: " + ex.toString();
            VM.log(CLASS, 3, details);
            throw new CMException(1111, details);
        }
        catch (SAXException ex) {
            String details = "failed to parse page: " + ex.toString();
            VM.log(CLASS, 3, details);
            throw new CMException(1111, details);
        }
        catch (IOException ex) {
            String details = "failed to parse page: " + ex.toString();
            VM.log(CLASS, 3, details);
            throw new CMException(1111, details);
        }
        if (processPage) {
            try {
                if (this.m_document.getPageCount() > 0) {
                    for (int i = 0; i < this.m_document.getPageCount(); ++i) {
                        IGenericElement pageElement = this.m_document.getPageElement(i);
                        pageElement.resetNodePath(null, 0);
                        pageElement.removeHidden();
                    }
                }
            }
            catch (StackOverflowError ex) {
                String details = "failed to reset node path: " + ex.toString();
                VM.log(CLASS, 3, details);
            }
            return this.m_document.getPageCount();
        }
        return 1;
    }

    @Override
    public String getLabel() {
        if (this.m_label == null) {
            return this.getDefaultLabel();
        }
        return this.m_label;
    }

    @Override
    public String getSourcePath() {
        return this.m_sourcePath;
    }

    @Override
    public String getGatewayUrl() {
        return this.m_gatewayUrl;
    }

    @Override
    public String getDispatcherUrl() {
        return this.m_dispatcherUrl;
    }

    @Override
    public String getCmPath() {
        return this.m_cmPath;
    }

    @Override
    public String getDrillParams() {
        return this.m_drillSignature;
    }

    @Override
    public int getPageCount() {
        return this.m_document == null ? 0 : this.m_document.getPageCount();
    }

    @Override
    public IElement getPage(Document doc, int index) {
        return doc.getPageElement(index);
    }

    @Override
    public String getTrace() {
        return this.errorTrace;
    }

    @Override
    public void setTrace(String trace) {
        this.errorTrace = trace;
    }

    @Override
    public String getErrorMsg() {
        return this.m_errorMsg;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.m_errorMsg = errorMsg;
    }

    @Override
    public int getMaxPages() {
        return this.m_maxPages;
    }

    @Override
    public void setMaxPages(int maxPages) {
        this.m_maxPages = maxPages;
    }

    @Override
    public int getRenderID() {
        return this.m_renderID;
    }

    @Override
    public String getStoreID() {
        return this.m_storeID;
    }

    @Override
    public int getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public InputStream runReport(String storeID) throws CMException {
        return this.reportCompiler == null ? null : this.reportCompiler.runReport(storeID, this.getRenderID(), this.m_document.getCurrentWidget(), this.m_document.getCurrentWidgetPage());
    }

    @Override
    public InputStream nextPage() throws CMException {
        return this.reportCompiler == null ? null : this.reportCompiler.nextPage(this.m_document.getCurrentWidget(), this.m_document.getCurrentWidgetPage());
    }

    @Override
    public boolean getHasNextPage() {
        return this.m_document == null ? false : this.m_document.getHasNextPage();
    }

    @Override
    public boolean isBuxReport() {
        return this.m_document == null ? false : this.m_document.isBuxReport();
    }

    @Override
    public IReportOutputProcessor getReportProcessorHost() {
        return this.reportProcessorHost;
    }

    @Override
    public boolean isMemberUniqueNameUsed() {
        return this.m_document == null ? false : this.m_document.isMemberUniqueNameUsed();
    }

    @Override
    public boolean compareDrillthroughModelPath(String modelPath, Hashtable targetModelPaths) {
        if (this.m_document != null && modelPath != null) {
            return this.m_document.compareDrillthroughModelPath(modelPath, targetModelPaths);
        }
        return false;
    }

    @Override
    public void setUnsupportedDrillFlag(boolean flag) {
        if (this.m_document != null) {
            this.m_document.setUnsupportedDrillFlag(flag);
        }
    }

    @Override
    public String[] getDrillTargetCMPaths() {
        Hashtable cmPaths = new Hashtable();
        if (this.m_document != null) {
            this.m_document.getDrillTargetCMPaths(cmPaths);
        }
        String[] results = new String[cmPaths.size()];
        int index = 0;
        Enumeration keys = cmPaths.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            results[index] = (String)key;
            ++index;
        }
        return results;
    }

    private String getDefaultLabel() {
        CMPathHelper.SplitPathResult splitPathResult = CMPathHelper.splitSourcePath(this.m_sourcePath);
        return splitPathResult.file;
    }

    @Override
    public String getBurstValue() {
        return this.m_burstValue;
    }

    @Override
    public IDocument getDocument() {
        return this.m_document;
    }
}

