/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.ldx;

import com.cognos.mobile.generator.IGenericStyle;
import com.cognos.mobile.generator.Style;
import com.cognos.mobile.generator.input.ldx.LdxElement;
import com.cognos.mobile.generator.input.ldx.LdxHandler;
import com.cognos.mobile.generator.input.ldx.LdxSourceHandler;
import com.cognos.mobile.vm.VM;

public class LdxStyleGroupElement
extends LdxElement {
    public IGenericStyle m_styleElement;
    private boolean m_inFgColour = false;
    private boolean m_inBgColour = false;
    private String[] m_fgColour;
    private String[] m_bgColour;
    private boolean m_useFgColour = true;
    private boolean m_useBgColour = true;
    private final int RED_COMPONENT = 0;
    private final int GREEN_COMPONENT = 1;
    private final int BLUE_COMPONENT = 2;
    private final String LINESTYLE_SOLID = "SOLID";
    private final String LINESTYLE_NONE = "NONE";
    private final String UNIT_PERCENT = "percent";

    public LdxStyleGroupElement(LdxSourceHandler handler) {
        super(handler);
    }

    @Override
    public void reset() {
        this.m_styleElement = null;
        this.m_fgColour = null;
        this.m_bgColour = null;
        this.m_useFgColour = true;
        this.m_useBgColour = true;
    }

    @Override
    public void processEvent(int event) {
        super.processEvent(event);
        switch (event) {
            case 3000: {
                this.m_styleElement = this.document.createStyle();
                break;
            }
            case 1100: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 1101: {
                this.m_styleElement.setName(this.handler.generateStyleName(this.handler.getTextNode()));
                this.handler.RecordTextNodeOff();
                break;
            }
            case 100030: {
                this.m_inFgColour = true;
                this.m_fgColour = new String[3];
                break;
            }
            case 100031: {
                if (this.m_useFgColour) {
                    this.m_styleElement.setFontColor(this.document, this.m_fgColour);
                    this.m_styleElement.setForegroundColor(this.document, this.m_fgColour);
                }
                this.m_inFgColour = false;
                this.m_fgColour = null;
                this.m_useFgColour = true;
                break;
            }
            case 100042: {
                this.m_inBgColour = true;
                this.m_bgColour = new String[3];
                break;
            }
            case 100043: {
                if (this.m_useBgColour) {
                    this.m_styleElement.setBackgroundColor(this.document, this.m_bgColour);
                }
                this.m_inBgColour = false;
                this.m_bgColour = null;
                this.m_useBgColour = true;
                break;
            }
            case 100032: 
            case 100034: 
            case 100036: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 100033: {
                if (this.m_inFgColour) {
                    this.m_fgColour[0] = this.handler.getTextNode();
                } else if (this.m_inBgColour) {
                    this.m_bgColour[0] = this.handler.getTextNode();
                }
                this.handler.RecordTextNodeOff();
                break;
            }
            case 100035: {
                if (this.m_inFgColour) {
                    this.m_fgColour[1] = this.handler.getTextNode();
                } else if (this.m_inBgColour) {
                    this.m_bgColour[1] = this.handler.getTextNode();
                }
                this.handler.RecordTextNodeOff();
                break;
            }
            case 100037: {
                if (this.m_inFgColour) {
                    this.m_fgColour[2] = this.handler.getTextNode();
                } else if (this.m_inBgColour) {
                    this.m_bgColour[2] = this.handler.getTextNode();
                }
                this.handler.RecordTextNodeOff();
                break;
            }
            case 130030: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 130031: {
                String alpha = this.handler.getTextNode();
                if (alpha != null && (alpha.equals("0.0") || alpha.equals("0"))) {
                    if (this.m_inFgColour) {
                        this.m_useFgColour = false;
                    } else {
                        this.m_useBgColour = false;
                    }
                }
                this.handler.RecordTextNodeOff();
                break;
            }
            case 100038: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 100039: {
                this.m_styleElement.setTextAlign(this.document, this.handler.getTextNode().toLowerCase());
                this.handler.RecordTextNodeOff();
                break;
            }
            case 100016: {
                this.handler.pushFsm(new BorderElement(this.handler));
                this.handler.injectEvent(event);
                break;
            }
            case 100022: {
                this.handler.pushFsm(new HeightElement(this.handler, this.m_styleElement));
                this.handler.injectEvent(event);
                break;
            }
            case 100020: {
                this.handler.pushFsm(new WidthElement(this.handler, this.m_styleElement));
                this.handler.injectEvent(event);
                break;
            }
            case 100000: {
                this.handler.pushFsm(new FontElement(this.handler, this.m_styleElement));
                this.handler.injectEvent(event);
                break;
            }
            case 130032: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 130033: {
                if (!this.handler.getTextNode().equals("true")) break;
                this.m_styleElement.setHidden(true);
                break;
            }
            case 130034: {
                this.handler.RecordTextNodeOn();
                break;
            }
            case 130035: {
                if (!this.handler.getTextNode().equals("none")) break;
                this.m_styleElement.setHidden(true);
                break;
            }
            case 3001: {
                this.document.addNamedStyle(this.m_styleElement);
                this.handler.popFsm();
            }
        }
    }

    static /* synthetic */ String[] access$102(LdxStyleGroupElement x0, String[] x1) {
        x0.m_bgColour = x1;
        return x1;
    }

    private class FontElement
    implements LdxHandler.FilterFSM {
        protected LdxSourceHandler m_handler = null;
        protected IGenericStyle m_styleElement = null;
        protected String m_currentFamily = null;
        protected Style.Size m_currentSize = null;

        public FontElement(LdxSourceHandler handler, IGenericStyle styleElement) {
            this.m_handler = handler;
            this.m_styleElement = styleElement;
        }

        @Override
        public void reset() {
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 100002: {
                    this.m_handler.RecordTextNodeOn();
                    break;
                }
                case 100003: {
                    String family = this.m_handler.getTextNode().trim();
                    if (!"".equals(family)) {
                        this.m_styleElement.setFontFamily(family);
                    }
                    this.m_handler.RecordTextNodeOff();
                    break;
                }
                case 16500: {
                    this.m_handler.pushFsm(new FontSizeElement(this.m_handler, this.m_styleElement));
                    this.m_handler.injectEvent(event);
                    break;
                }
                case 100010: {
                    this.m_handler.RecordTextNodeOn();
                    break;
                }
                case 100011: {
                    if (this.m_handler.getTextNode().equals("true")) {
                        this.m_styleElement.setBold(true);
                    }
                    this.m_handler.RecordTextNodeOff();
                    break;
                }
                case 100012: {
                    this.m_handler.RecordTextNodeOn();
                    break;
                }
                case 100013: {
                    if (this.m_handler.getTextNode().equals("true")) {
                        this.m_styleElement.setUnderline(true);
                    }
                    this.m_handler.RecordTextNodeOff();
                    break;
                }
                case 110048: {
                    this.m_handler.RecordTextNodeOn();
                    break;
                }
                case 110049: {
                    if (this.m_handler.getTextNode().equals("true")) {
                        this.m_styleElement.setItalics(true);
                    }
                    this.m_handler.RecordTextNodeOff();
                    break;
                }
                case 100001: {
                    this.m_handler.popFsm();
                }
            }
        }
    }

    abstract class SizeElement
    implements LdxHandler.FilterFSM {
        protected LdxSourceHandler m_handler = null;
        protected IGenericStyle m_styleElement = null;
        protected Style.Size m_currentSize = null;

        public SizeElement(LdxSourceHandler handler, IGenericStyle styleElement) {
            this.m_handler = handler;
            this.m_styleElement = styleElement;
            this.m_currentSize = new Style.Size();
        }

        @Override
        public void reset() {
            this.m_currentSize = new Style.Size();
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 1080: {
                    this.m_handler.RecordTextNodeOn();
                    break;
                }
                case 1081: {
                    try {
                        Float width = new Float(this.m_handler.getTextNode().trim());
                        this.m_currentSize.setValue(width.doubleValue());
                    }
                    catch (NumberFormatException e) {
                        VM.log(LdxStyleGroupElement.class, 3, "Problem converting width to integer: " + this.m_handler.getTextNode());
                    }
                    this.m_handler.RecordTextNodeOff();
                    break;
                }
                case 100006: {
                    this.m_handler.RecordTextNodeOn();
                    break;
                }
                case 100007: {
                    String units = this.m_handler.getTextNode().trim().toLowerCase();
                    if ("percent".equals(units)) {
                        units = "%";
                    }
                    this.m_currentSize.setUnits(units);
                    this.m_handler.RecordTextNodeOff();
                }
            }
        }
    }

    private class BorderWidthElement
    extends WidthElement {
        protected int m_border;

        public BorderWidthElement(LdxSourceHandler handler, IGenericStyle styleElement, int border) {
            super(handler, styleElement);
            this.m_border = border;
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 100021: {
                    this.m_styleElement.setBorderWidth(this.m_border, this.m_currentSize);
                    this.m_handler.popFsm();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    private class FontSizeElement
    extends SizeElement {
        public FontSizeElement(LdxSourceHandler handler, IGenericStyle styleElement) {
            super(handler, styleElement);
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 16501: {
                    this.m_styleElement.setFontSize(this.m_currentSize);
                    this.m_handler.popFsm();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    private class WidthElement
    extends SizeElement {
        public WidthElement(LdxSourceHandler handler, IGenericStyle styleElement) {
            super(handler, styleElement);
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 100021: {
                    this.m_styleElement.setWidth(this.m_currentSize);
                    this.m_handler.popFsm();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    private class HeightElement
    extends SizeElement {
        public HeightElement(LdxSourceHandler handler, IGenericStyle styleElement) {
            super(handler, styleElement);
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 100023: {
                    this.m_styleElement.setHeight(this.m_currentSize);
                    this.m_handler.popFsm();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    private class BorderEdge {
        public String m_lineStyle = "NONE";

        private BorderEdge() {
        }
    }

    private class Border {
        public BorderEdge[] edges = new BorderEdge[4];

        public Border() {
            this.edges[0] = new BorderEdge();
            this.edges[1] = new BorderEdge();
            this.edges[2] = new BorderEdge();
            this.edges[3] = new BorderEdge();
        }
    }

    private class BorderEdgeElement
    implements LdxHandler.FilterFSM {
        private LdxSourceHandler m_handler = null;
        protected int m_startEvent;
        protected int m_closeEvent;
        private int m_border;

        public BorderEdgeElement(LdxSourceHandler handler, Border currentBorder, int border, int start) {
            this.m_handler = handler;
            this.m_startEvent = start;
            this.m_closeEvent = start + 1;
            this.m_border = border;
        }

        @Override
        public void reset() {
        }

        @Override
        public void processEvent(int event) {
            if (event == this.m_closeEvent) {
                this.m_handler.popFsm();
            } else {
                switch (event) {
                    case 110044: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 110045: {
                        String lineStyle = this.m_handler.getTextNode();
                        if (lineStyle.equalsIgnoreCase("NONE")) {
                            LdxStyleGroupElement.this.m_styleElement.setBorderDisplay(this.m_border, (byte)2);
                        } else {
                            LdxStyleGroupElement.this.m_styleElement.setBorderDisplay(this.m_border, (byte)1);
                        }
                        LdxStyleGroupElement.this.m_styleElement.setBorderStyle(this.m_border, lineStyle);
                        this.m_handler.RecordTextNodeOff();
                        break;
                    }
                    case 100017: {
                        this.m_handler.popFsm();
                        break;
                    }
                    case 130036: {
                        LdxStyleGroupElement.this.m_inBgColour = true;
                        LdxStyleGroupElement.access$102(LdxStyleGroupElement.this, new String[3]);
                        break;
                    }
                    case 130037: {
                        if (LdxStyleGroupElement.this.m_useBgColour) {
                            LdxStyleGroupElement.this.m_styleElement.setBorderColor(LdxStyleGroupElement.this.document, this.m_border, LdxStyleGroupElement.this.m_bgColour);
                        }
                        LdxStyleGroupElement.this.m_inBgColour = false;
                        LdxStyleGroupElement.access$102(LdxStyleGroupElement.this, null);
                        LdxStyleGroupElement.this.m_useBgColour = true;
                        break;
                    }
                    case 100032: 
                    case 100034: 
                    case 100036: {
                        this.m_handler.RecordTextNodeOn();
                        break;
                    }
                    case 100033: {
                        if (LdxStyleGroupElement.this.m_inFgColour) {
                            ((LdxStyleGroupElement)LdxStyleGroupElement.this).m_fgColour[0] = this.m_handler.getTextNode();
                        } else if (LdxStyleGroupElement.this.m_inBgColour) {
                            ((LdxStyleGroupElement)LdxStyleGroupElement.this).m_bgColour[0] = this.m_handler.getTextNode();
                        }
                        this.m_handler.RecordTextNodeOff();
                        break;
                    }
                    case 100035: {
                        if (LdxStyleGroupElement.this.m_inFgColour) {
                            ((LdxStyleGroupElement)LdxStyleGroupElement.this).m_fgColour[1] = this.m_handler.getTextNode();
                        } else if (LdxStyleGroupElement.this.m_inBgColour) {
                            ((LdxStyleGroupElement)LdxStyleGroupElement.this).m_bgColour[1] = this.m_handler.getTextNode();
                        }
                        this.m_handler.RecordTextNodeOff();
                        break;
                    }
                    case 100037: {
                        if (LdxStyleGroupElement.this.m_inFgColour) {
                            ((LdxStyleGroupElement)LdxStyleGroupElement.this).m_fgColour[2] = this.m_handler.getTextNode();
                        } else if (LdxStyleGroupElement.this.m_inBgColour) {
                            ((LdxStyleGroupElement)LdxStyleGroupElement.this).m_bgColour[2] = this.m_handler.getTextNode();
                        }
                        this.m_handler.RecordTextNodeOff();
                        break;
                    }
                    case 100020: {
                        this.m_handler.pushFsm(new BorderWidthElement(this.m_handler, LdxStyleGroupElement.this.m_styleElement, this.m_border));
                        this.m_handler.injectEvent(event);
                    }
                }
            }
        }
    }

    private class BorderElement
    implements LdxHandler.FilterFSM {
        private LdxSourceHandler m_handler = null;
        private Border m_currentBorder = null;

        public BorderElement(LdxSourceHandler handler) {
            this.m_handler = handler;
            this.m_currentBorder = new Border();
        }

        @Override
        public void reset() {
            this.m_currentBorder = null;
        }

        @Override
        public void processEvent(int event) {
            switch (event) {
                case 100018: {
                    this.m_handler.pushFsm(new BorderEdgeElement(this.m_handler, this.m_currentBorder, 0, 100018));
                    break;
                }
                case 100026: {
                    this.m_handler.pushFsm(new BorderEdgeElement(this.m_handler, this.m_currentBorder, 1, 100026));
                    break;
                }
                case 100028: {
                    this.m_handler.pushFsm(new BorderEdgeElement(this.m_handler, this.m_currentBorder, 2, 100028));
                    break;
                }
                case 100024: {
                    this.m_handler.pushFsm(new BorderEdgeElement(this.m_handler, this.m_currentBorder, 3, 100024));
                    break;
                }
                case 100017: {
                    this.m_handler.popFsm();
                }
            }
        }
    }
}

