/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.mht;

import com.cognos.mobile.c8.IReportOutputProcessor;
import com.cognos.mobile.c8.IRunResponse;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.IInputStreamFactory;
import com.cognos.mobile.common.IPersistenceStore;
import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.standardedition.InputStreamFactory;
import com.cognos.mobile.vm.VM;
import com.cognos.pogo.http.mime.MIMEPartParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;

public class MhtReport
implements IReport {
    private static Class CLASS = MhtReport.class;
    public static final String CONTENT_ID = "Content-ID";
    public static final String PROP_SEP = ": ";
    public static final String BOUNDARY_SEP = "--";
    public static final String NEWLINE = "\r\n";
    public static final String NEWLINE2 = "\r\n\r\n";
    public static String CONTENT_TYPE = "Content-Type";
    public static String BOUNDARY = "boundary";
    public static String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static String CONTENT_LOCATION = "Content-Location";
    public static String QUOTED_PRINTABLE = "quoted-printable";
    public static String CHARSET = "charset=";
    public static String DEFAULT_BASEDOC = "irot.htm";
    private final int m_renderID;
    private final String m_sourcePath;
    private final String m_gatewayUrl;
    private final String m_dispatcherUrl;
    private final String m_label;
    private final String m_drillSignature;
    private final String m_storeID;
    private String m_errorMsg;
    private int sourceCode;
    private String m_description;
    private String pathRoot;
    private String fileRoot;
    private final String m_burstValue;
    private final IPersistenceStore tmpStore;
    private final IInputStreamFactory inputStreamFactory;
    private final IReportOutputProcessor reportProcessorHost;
    private final boolean dumpMht;

    public MhtReport(int renderID, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String drillSignature, String burstValue, int sourceCode, String description, IReportOutputProcessor reportProcessorHost, String pathRoot, String fileRoot, IPersistenceStore tmpStore, IInputStreamFactory inputStreamFactory) {
        this.m_renderID = renderID;
        this.m_sourcePath = sourcePath;
        this.m_gatewayUrl = gatewayUrl;
        this.m_dispatcherUrl = dispatcherUrl;
        this.m_storeID = storeID;
        this.m_label = null;
        this.m_drillSignature = drillSignature;
        this.sourceCode = sourceCode;
        this.m_description = description;
        this.pathRoot = pathRoot;
        this.fileRoot = fileRoot;
        this.reportProcessorHost = reportProcessorHost;
        this.dumpMht = reportProcessorHost == null || reportProcessorHost.getConfiguration() == null ? false : reportProcessorHost.getConfiguration().getBoolean("Debug.PersistMobileContentPackage", false);
        this.m_burstValue = burstValue;
        this.tmpStore = tmpStore;
        this.inputStreamFactory = inputStreamFactory;
    }

    @Override
    public int processReportOutput(int pageIndex, IRunResponse runResponse, boolean testing) throws CMException {
        FilterOutputStream ostream = null;
        try {
            if (this.dumpMht) {
                String filePath = this.reportProcessorHost.getC8TempDirectory() + File.separator + "mobile" + System.currentTimeMillis() + ".mht";
                File file = new File(filePath);
                ostream = new BufferedOutputStream(new FileOutputStream(file));
            }
            if (runResponse.getIsPromptPage()) {
                InputStream inStream = runResponse.getRunOutput();
                byte[] pageBytes = this.inputStreamFactory.slurp(inStream);
                String promptPageTempID = ReportCompiler.generatePromptPageTempID(this.m_renderID);
                OutputStream outputStream = this.tmpStore.create(promptPageTempID, true);
                outputStream.write(pageBytes);
                outputStream.close();
                int n = 0;
                return n;
            }
            this.processMht(runResponse.getRunOutput());
        }
        catch (IOException e) {
            throw new CMException(1152, "IOException processing report output", (Throwable)e);
        }
        catch (MessagingException e) {
            throw new CMException(1152, "MessagingException processing report output", (Throwable)e);
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (Exception exception) {}
            }
        }
        return 0;
    }

    private void processMht(InputStream runOutput) throws MessagingException, CMException, IOException {
        InternetHeaders headers = new InternetHeaders(runOutput);
        if (headers == null || !headers.getAllHeaders().hasMoreElements()) {
            throw new CMException(1111, "mht file missing headers");
        }
        String[] mainContentType = headers.getHeader(CONTENT_TYPE);
        if (mainContentType == null || mainContentType[0] == null || mainContentType[0].equals("") || mainContentType[0].indexOf(BOUNDARY) < 0) {
            throw new CMException(1111, "mht file missing boundary info");
        }
        String boundary = MIMEPartParser.getBoundaryFromContentType((String)mainContentType[0]);
        MIMEPartParser parser = new MIMEPartParser(runOutput, boundary);
        int resourcesProcessed = 0;
        while (parser.hasNext()) {
            InputStream partStream = (InputStream)parser.next();
            headers = new InternetHeaders(partStream);
            if (headers != null) {
                String[] encoding = headers.getHeader(CONTENT_TRANSFER_ENCODING);
                if (encoding == null || encoding[0] == null || encoding[0].equals("")) {
                    encoding[0] = QUOTED_PRINTABLE;
                } else {
                    encoding = headers.getHeader(CONTENT_TRANSFER_ENCODING);
                }
                String[] locations = headers.getHeader(CONTENT_LOCATION);
                String location = locations == null || locations[0] == null || locations[0].equals("") ? DEFAULT_BASEDOC : locations[0].trim();
                if (this.reportProcessorHost != null) {
                    byte[] partBytes = InputStreamFactory.slurpStream(MimeUtility.decode((InputStream)partStream, (String)encoding[0]));
                    this.reportProcessorHost.processResource(partBytes, location, encoding[0], this.pathRoot, this.fileRoot, 16, -1, -1, -1, -1, -1);
                    ++resourcesProcessed;
                }
            }
            partStream.close();
        }
        if (resourcesProcessed == 0) {
            VM.log(CLASS, 2, String.format("No resources were processed for MHT: RenderID: %s storeId: %s", this.m_renderID, this.m_storeID));
        }
    }

    @Override
    public String getCmPath() {
        return this.m_description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getDispatcherUrl() {
        return this.m_dispatcherUrl;
    }

    public Document getDocument(int index) {
        return null;
    }

    public Document getDocument(String outputType) {
        return null;
    }

    @Override
    public String getDrillParams() {
        return this.m_drillSignature;
    }

    @Override
    public String getErrorMsg() {
        return this.m_errorMsg;
    }

    @Override
    public String getGatewayUrl() {
        return this.m_gatewayUrl;
    }

    @Override
    public boolean getHasNextPage() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public int getMaxPages() {
        return 0;
    }

    @Override
    public IElement getPage(Document doc, int index) {
        return null;
    }

    @Override
    public int getPageCount() {
        return 0;
    }

    @Override
    public int getRenderID() {
        return this.m_renderID;
    }

    @Override
    public int getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public String getSourcePath() {
        return this.m_sourcePath;
    }

    @Override
    public String getStoreID() {
        return this.m_storeID;
    }

    @Override
    public String getTrace() {
        return null;
    }

    @Override
    public boolean isBuxReport() {
        return false;
    }

    @Override
    public int processReportOutput(IDocument outputDocuments, IRunResponse runResponse, boolean testing, boolean processPage, IGenericElement currentElement) throws CMException {
        return 0;
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.m_errorMsg = errorMsg;
    }

    @Override
    public void setMaxPages(int maxPages) {
    }

    @Override
    public void setTrace(String trace) {
    }

    @Override
    public IReportOutputProcessor getReportProcessorHost() {
        return this.reportProcessorHost;
    }

    @Override
    public InputStream runReport(String storeID) throws CMException {
        return null;
    }

    @Override
    public InputStream nextPage() throws CMException {
        return null;
    }

    @Override
    public boolean isMemberUniqueNameUsed() {
        return false;
    }

    @Override
    public boolean compareDrillthroughModelPath(String sourceModelPath, Hashtable hash) {
        return false;
    }

    @Override
    public String[] getDrillTargetCMPaths() {
        return new String[0];
    }

    @Override
    public void setUnsupportedDrillFlag(boolean flag) {
    }

    @Override
    public String getBurstValue() {
        return this.m_burstValue;
    }
}

