/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.pdf;

import com.cognos.mobile.c8.IReportOutputProcessor;
import com.cognos.mobile.c8.IRunResponse;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.standardedition.InputStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

public class PdfReport
implements IReport {
    private final int m_renderID;
    private final String m_sourcePath;
    private final String m_gatewayUrl;
    private final String m_dispatcherUrl;
    private final String m_label;
    private final String m_drillSignature;
    private final String m_storeID;
    private String m_errorMsg;
    private int sourceCode;
    private String m_description;
    private String pathRoot;
    private String fileRoot;
    private final IReportOutputProcessor reportProcessorHost;
    private final String m_burstValue;

    public PdfReport(int renderID, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String drillSignature, String burstValue, int sourceCode, String description, IReportOutputProcessor reportProcessorHost, String pathRoot, String fileRoot) {
        this.m_renderID = renderID;
        this.m_sourcePath = sourcePath;
        this.m_gatewayUrl = gatewayUrl;
        this.m_dispatcherUrl = dispatcherUrl;
        this.m_storeID = storeID;
        this.m_label = null;
        this.m_drillSignature = drillSignature;
        this.sourceCode = sourceCode;
        this.m_description = description;
        this.pathRoot = pathRoot;
        this.fileRoot = fileRoot;
        this.reportProcessorHost = reportProcessorHost;
        this.m_burstValue = burstValue;
    }

    @Override
    public int processReportOutput(int pageIndex, IRunResponse runResponse, boolean testing) throws CMException {
        try {
            if (this.reportProcessorHost != null) {
                byte[] partBytes = InputStreamFactory.slurpStream(MimeUtility.decode((InputStream)runResponse.getRunOutput(), (String)"binary"));
                this.reportProcessorHost.processResource(partBytes, this.fileRoot + ".pdf", "binary", this.pathRoot, this.fileRoot, 16, -1, -1, -1, -1, -1);
            }
        }
        catch (IOException e) {
            throw new CMException(1152, "IOException processing report output", (Throwable)e);
        }
        catch (MessagingException e) {
            throw new CMException(1152, "MessagingException processing report output", (Throwable)e);
        }
        return 0;
    }

    @Override
    public String getCmPath() {
        return this.m_description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getDispatcherUrl() {
        return this.m_dispatcherUrl;
    }

    public Document getDocument(int index) {
        return null;
    }

    public Document getDocument(String outputType) {
        return null;
    }

    @Override
    public String getDrillParams() {
        return this.m_drillSignature;
    }

    @Override
    public String getErrorMsg() {
        return this.m_errorMsg;
    }

    @Override
    public String getGatewayUrl() {
        return this.m_gatewayUrl;
    }

    @Override
    public boolean getHasNextPage() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public int getMaxPages() {
        return 0;
    }

    @Override
    public IElement getPage(Document doc, int index) {
        return null;
    }

    @Override
    public int getPageCount() {
        return 0;
    }

    @Override
    public int getRenderID() {
        return this.m_renderID;
    }

    @Override
    public int getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public String getSourcePath() {
        return this.m_sourcePath;
    }

    @Override
    public String getStoreID() {
        return this.m_storeID;
    }

    @Override
    public String getTrace() {
        return null;
    }

    @Override
    public boolean isBuxReport() {
        return false;
    }

    @Override
    public int processReportOutput(IDocument outputDocuments, IRunResponse runResponse, boolean testing, boolean processPage, IGenericElement currentElement) throws CMException {
        return 0;
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.m_errorMsg = errorMsg;
    }

    @Override
    public void setMaxPages(int maxPages) {
    }

    @Override
    public void setTrace(String trace) {
    }

    @Override
    public IReportOutputProcessor getReportProcessorHost() {
        return this.reportProcessorHost;
    }

    @Override
    public InputStream runReport(String storeID) throws CMException {
        return null;
    }

    @Override
    public InputStream nextPage() throws CMException {
        return null;
    }

    @Override
    public boolean isMemberUniqueNameUsed() {
        return false;
    }

    @Override
    public boolean compareDrillthroughModelPath(String sourceModelPath, Hashtable hash) {
        return false;
    }

    @Override
    public String[] getDrillTargetCMPaths() {
        return new String[0];
    }

    @Override
    public void setUnsupportedDrillFlag(boolean flag) {
    }

    @Override
    public String getBurstValue() {
        return this.m_burstValue;
    }
}

