/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.rsvp_html;

import com.cognos.mobile.c8.IReportOutputProcessor;
import com.cognos.mobile.c8.IRunResponse;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.standardedition.InputStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

public class RsvpHtmlReport
implements IReport {
    private final int renderID;
    private final String sourcePath;
    private final String gatewayUrl;
    private final String dispatcherUrl;
    private final String label;
    private final String drillSignature;
    private final String storeID;
    private String errorMsg;
    private int sourceCode;
    private String description;
    private String pathRoot;
    private String fileRoot;
    private final String m_burstValue;
    private final IReportOutputProcessor reportProcessorHost;

    public RsvpHtmlReport(int renderID, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String drillSignature, String burstValue, int sourceCode, String description, IReportOutputProcessor reportProcessorHost, String pathRoot, String fileRoot) {
        this.renderID = renderID;
        this.sourcePath = sourcePath;
        this.gatewayUrl = gatewayUrl;
        this.dispatcherUrl = dispatcherUrl;
        this.storeID = storeID;
        this.label = null;
        this.drillSignature = drillSignature;
        this.sourceCode = sourceCode;
        this.description = description;
        this.pathRoot = pathRoot;
        this.fileRoot = fileRoot;
        this.reportProcessorHost = reportProcessorHost;
        this.m_burstValue = burstValue;
    }

    @Override
    public int processReportOutput(int pageIndex, IRunResponse runResponse, boolean testing) throws CMException {
        try {
            if (this.reportProcessorHost != null) {
                byte[] partBytes = InputStreamFactory.slurpStream(MimeUtility.decode((InputStream)runResponse.getRunOutput(), (String)"binary"));
                this.reportProcessorHost.processResource(partBytes, this.fileRoot + ".html", "binary", this.pathRoot, this.fileRoot, 19, -1, -1, -1, -1, pageIndex);
            }
        }
        catch (IOException e) {
            throw new CMException(1152, "IOException processing report output", (Throwable)e);
        }
        catch (MessagingException e) {
            throw new CMException(1152, "MessagingException processing report output", (Throwable)e);
        }
        return 0;
    }

    @Override
    public String getCmPath() {
        return this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDispatcherUrl() {
        return this.dispatcherUrl;
    }

    public Document getDocument(int index) {
        return null;
    }

    public Document getDocument(String outputType) {
        return null;
    }

    @Override
    public String getDrillParams() {
        return this.drillSignature;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    @Override
    public boolean getHasNextPage() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getMaxPages() {
        return 0;
    }

    @Override
    public IElement getPage(Document doc, int index) {
        return null;
    }

    @Override
    public int getPageCount() {
        return 0;
    }

    @Override
    public int getRenderID() {
        return this.renderID;
    }

    @Override
    public int getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public String getStoreID() {
        return this.storeID;
    }

    @Override
    public String getTrace() {
        return null;
    }

    @Override
    public boolean isBuxReport() {
        return false;
    }

    @Override
    public int processReportOutput(IDocument outputDocuments, IRunResponse runResponse, boolean testing, boolean processPage, IGenericElement currentElement) throws CMException {
        return 0;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public void setMaxPages(int maxPages) {
    }

    @Override
    public void setTrace(String trace) {
    }

    @Override
    public IReportOutputProcessor getReportProcessorHost() {
        return this.reportProcessorHost;
    }

    @Override
    public InputStream runReport(String storeID) throws CMException {
        return null;
    }

    @Override
    public InputStream nextPage() throws CMException {
        return null;
    }

    @Override
    public boolean isMemberUniqueNameUsed() {
        return false;
    }

    @Override
    public boolean compareDrillthroughModelPath(String sourceModelPath, Hashtable hash) {
        return false;
    }

    @Override
    public String[] getDrillTargetCMPaths() {
        return new String[0];
    }

    @Override
    public void setUnsupportedDrillFlag(boolean flag) {
    }

    @Override
    public String getBurstValue() {
        return this.m_burstValue;
    }
}

