/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.input.viewer_html;

import com.cognos.mobile.c8.IReportOutputProcessor;
import com.cognos.mobile.c8.IRunResponse;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.IInputStreamFactory;
import com.cognos.mobile.common.IPersistenceStore;
import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.RenderRow;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IDocument;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.IReport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ViewerHtmlReport
implements IReport {
    private final IRenderRow renderRow;
    private final IInputStreamFactory inputStreamFactory;
    private final String sourcePath;
    private final String gatewayUrl;
    private final String dispatcherUrl;
    private final String label;
    private final String drillSignature;
    private final String storeID;
    private String errorMsg;
    private int sourceCode;
    private String description;
    private final String m_burstValue;
    private final IPersistenceStore tmpStore;
    private int pageCount;
    private final IReportOutputProcessor reportProcessorHost;

    public ViewerHtmlReport(IRenderRow renderRow, IInputStreamFactory inputStreamFactory, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String drillSignature, String burstValue, int sourceCode, String description, IReportOutputProcessor reportProcessorHost, IPersistenceStore tmpStore) {
        this.renderRow = renderRow;
        this.inputStreamFactory = inputStreamFactory;
        this.sourcePath = sourcePath;
        this.gatewayUrl = gatewayUrl;
        this.dispatcherUrl = dispatcherUrl;
        this.storeID = storeID;
        this.label = null;
        this.drillSignature = drillSignature;
        this.sourceCode = sourceCode;
        this.description = description;
        this.reportProcessorHost = reportProcessorHost;
        this.m_burstValue = burstValue;
        this.tmpStore = tmpStore;
        this.pageCount = 0;
    }

    @Override
    public int processReportOutput(int pageIndex, IRunResponse runResponse, boolean testing) throws CMException {
        if (this.reportProcessorHost != null) {
            InputStream inStream = runResponse.getRunOutput();
            if (inStream != null) {
                this.processReportOutput(inStream, pageIndex, runResponse);
            } else {
                int pageCount = runResponse.getPageCount();
                for (int i = 0; i < pageCount; ++i) {
                    this.processReportOutput(runResponse.getPage(i), i, runResponse);
                }
            }
        }
        return 0;
    }

    private void processReportOutput(InputStream inStream, int pageIndex, IRunResponse runResponse) throws CMException {
        try {
            byte[] pageBytes = this.inputStreamFactory.slurp(inStream);
            if (pageBytes != null && pageBytes.length > 0) {
                if (runResponse.getIsPromptPage()) {
                    String promptPageTempID = ReportCompiler.generatePromptPageTempID(this.renderRow.getIntField(RenderRow.RenderField.RENDERID));
                    OutputStream outputStream = this.tmpStore.create(promptPageTempID, true);
                    outputStream.write(pageBytes);
                    outputStream.close();
                } else {
                    ++this.pageCount;
                    this.reportProcessorHost.processResource(pageBytes, ReportCompiler.generateWrapperPageName(Math.max(1, pageIndex + 1)), "binary", null, null, 18, -1, -1, -1, -1, pageIndex);
                }
            }
        }
        catch (IOException e) {
            throw new CMException(1152, "IOException processing report output", (Throwable)e);
        }
    }

    @Override
    public String getCmPath() {
        return this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDispatcherUrl() {
        return this.dispatcherUrl;
    }

    @Override
    public String getDrillParams() {
        return this.drillSignature;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    @Override
    public boolean getHasNextPage() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getMaxPages() {
        return 0;
    }

    @Override
    public IElement getPage(Document doc, int index) {
        return null;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public int getRenderID() {
        return this.renderRow.getIntField(RenderRow.RenderField.RENDERID);
    }

    @Override
    public int getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public String getStoreID() {
        return this.storeID;
    }

    @Override
    public String getTrace() {
        return null;
    }

    @Override
    public boolean isBuxReport() {
        return false;
    }

    @Override
    public int processReportOutput(IDocument outputDocuments, IRunResponse runResponse, boolean testing, boolean processPage, IGenericElement currentElement) throws CMException {
        return 0;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public void setMaxPages(int maxPages) {
    }

    @Override
    public void setTrace(String trace) {
    }

    @Override
    public IReportOutputProcessor getReportProcessorHost() {
        return this.reportProcessorHost;
    }

    @Override
    public InputStream runReport(String storeID) throws CMException {
        return null;
    }

    @Override
    public InputStream nextPage() throws CMException {
        return null;
    }

    @Override
    public boolean isMemberUniqueNameUsed() {
        return false;
    }

    @Override
    public boolean compareDrillthroughModelPath(String sourceModelPath, Hashtable hash) {
        return false;
    }

    @Override
    public String[] getDrillTargetCMPaths() {
        return new String[0];
    }

    @Override
    public void setUnsupportedDrillFlag(boolean flag) {
    }

    @Override
    public String getBurstValue() {
        return this.m_burstValue;
    }
}

