/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlElement;
import com.cognos.mobile.vm.VMPoint;
import java.io.PrintStream;

public class HtmlCellElement
extends HtmlElement {
    private boolean m_isTitle;
    private int m_row;
    private int m_column;

    public HtmlCellElement(Document page, IElement parent) {
        super(page, 2, parent);
    }

    public HtmlCellElement(Document page, IElement parent, boolean isTitle) {
        super(page, 2, parent);
        this.setIsTitle(isTitle);
    }

    public HtmlCellElement(Document page) {
        super(page, 2);
    }

    public HtmlCellElement(HtmlCellElement other) {
        super(other);
    }

    public boolean isTitle() {
        return this.m_isTitle;
    }

    @Override
    public void setIsTitle(boolean isTitle) {
        this.m_isTitle = isTitle;
    }

    public int getRow() {
        return this.m_row;
    }

    public void setRow(int row) {
        this.m_row = row;
    }

    public int getColumn() {
        return this.m_column;
    }

    public void setColumn(int column) {
        this.m_column = column;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        IElement[] children;
        String drillUpDown;
        int colspan = 1;
        int rowspan = 1;
        if (this.getColspan() != null) {
            colspan = this.getColspan();
        }
        if (this.getRowspan() != null) {
            rowspan = this.getRowspan();
        }
        String spanText = "";
        if (colspan != 1) {
            spanText = spanText + " colspan=\"" + Integer.toString(colspan) + "\"";
        }
        if (rowspan != 1) {
            spanText = spanText + " rowspan=\"" + Integer.toString(rowspan) + "\"";
        }
        if ((drillUpDown = this.generateDrillUpDownAttribute(this.drillUpDownCtx)).length() == 0) {
            children = this.getChildren();
            for (int i = 0; i < children.length && (drillUpDown = this.generateDrillUpDownAttribute(children[i].getDrillUpDownContext())).length() == 0; ++i) {
            }
        }
        out.print(this.generateTagOpen("<td", drillUpDown + spanText + ">"));
        children = this.getChildren();
        this.generateProgram(children, generator, out);
    }

    public void generateStyles(boolean isLayout, VMPoint tableFreeze, IGenerator generator, PrintStream out) {
        if (!isLayout) {
            this.setTablePartClass(tableFreeze);
            this.processStyles();
        }
        super.generateStyles(generator, out);
    }

    public void setTablePartClass(VMPoint tableFreeze) {
        if (this.m_row < tableFreeze.y && this.m_column < tableFreeze.x) {
            this.addCssClass("topleft");
        } else if (this.m_row < tableFreeze.y) {
            this.addCssClass("top");
        } else if (this.m_column < tableFreeze.x) {
            this.addCssClass("left");
        }
    }

    public void processStyles() {
        int k;
        if (this.getColspan() == null) {
            this.addCssClass("c" + this.getColumn());
        } else {
            for (k = this.getColumn(); k < this.getColumn() + this.getColspan(); ++k) {
                this.addCssClass("c" + k);
            }
        }
        if (this.getRowspan() == null) {
            this.addCssClass("r" + this.getRow());
        } else {
            for (k = this.getRow(); k < this.getRow() + this.getRowspan(); ++k) {
                this.addCssClass("r" + k);
            }
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        if (this.m_isTitle) {
            out.println("cell: " + this.m_children.size() + " title part(s) ");
        } else {
            out.println("cell: " + this.m_children.size() + " part(s) ");
        }
    }
}

