/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlElement;
import com.cognos.mobile.generator.output.html.HtmlMapElement;
import com.cognos.mobile.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class HtmlChartElement
extends HtmlElement {
    private static Class CLASS = HtmlChartElement.class;
    private static final boolean USE_SVG = false;
    private static final String SVG_CSS_STYLESHEET = "/m/css/svg.css";
    private String m_imageUrl;
    private String m_imageMap;
    private int m_imageWidth;
    private int m_imageHeight;
    private String m_ldx;

    public HtmlChartElement(Document page, IElement parent) {
        super(page, 3, parent);
        this.addCssClass("chart");
    }

    public HtmlChartElement(HtmlChartElement other) {
        super(other);
        this.m_imageUrl = other.m_imageUrl;
        this.m_imageMap = other.m_imageMap;
        this.m_imageWidth = other.m_imageWidth;
        this.m_imageHeight = other.m_imageHeight;
        this.m_ldx = other.m_ldx;
    }

    @Override
    public void setUrl(String url) {
        this.m_imageUrl = url;
    }

    @Override
    public void setMap(String map) {
        this.m_imageMap = map;
    }

    @Override
    public void setWidth(int width) {
        this.m_imageWidth = width;
    }

    @Override
    public void setHeight(int height) {
        this.m_imageHeight = height;
    }

    @Override
    public void setValue(String rawLDX) {
        this.m_ldx = rawLDX;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        Object svgHref = null;
        IElement[] children = this.getChildren();
        HtmlMapElement mapElement = null;
        for (int i = 0; i < children.length; ++i) {
            IElement child = children[i];
            if (child instanceof HtmlMapElement) {
                try {
                    mapElement = (HtmlMapElement)child;
                }
                catch (ClassCastException ex) {
                    mapElement = null;
                }
                if (mapElement == null) {
                    VM.log(CLASS, 2, "image map not found");
                    continue;
                }
                if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
                    VM.log(CLASS, 2, "image map missing image width/height: " + this.m_imageMap);
                    continue;
                }
                try {
                    if (!generator.isTesting()) {
                        File temp = File.createTempFile("mob_", "map");
                        this.m_imageMap = temp.getName();
                        temp.delete();
                    } else {
                        this.m_imageMap = "temp";
                    }
                }
                catch (IOException e) {
                    VM.log(CLASS, 2, "failed to create temp file, used ramdom number.");
                    this.m_imageMap = "mob_" + System.currentTimeMillis() + Math.round(Math.random() * 100.0);
                }
                mapElement.setMap(this.m_imageMap);
                continue;
            }
            child.generateProgram(generator, out);
        }
        if (this.m_imageUrl != null) {
            out.print(this.generateTagOpen("<div style=\"position:relative\"", ">"));
            this.generateStyles(generator, out);
            String imageSrc = this.generateImageUrl(generator, this.m_imageUrl);
            String useMap = "";
            String size = "";
            if (this.m_imageMap != null) {
                useMap = " usemap=\"#" + this.m_imageMap + "\"";
            }
            if (this.m_imageWidth > 0 && this.m_imageHeight > 0) {
                size = " height=\"" + this.m_imageHeight + "\" width=\"" + this.m_imageWidth + "\"";
            }
            if (mapElement != null) {
                mapElement.generateProgram(generator, out, this.m_imageWidth, this.m_imageHeight);
            }
            out.print(this.generateTagOpen("<img" + size + useMap + " src=\"" + imageSrc + "\" alt=\"chart\"", " />"));
            out.print("</div>");
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("chart: imageUrl=" + this.m_imageUrl + ", imageMap=" + this.m_imageMap);
    }

    @Override
    protected boolean isFocusable() {
        return true;
    }
}

