/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper2;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ImageInfo;
import com.cognos.mobile.drill.DrillContext;
import com.cognos.mobile.drill.DrillHelper;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.Element;
import com.cognos.mobile.generator.IDrillUpDownContext;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlStyle;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import java.io.PrintStream;
import java.util.Vector;

public class HtmlElement
extends Element
implements IElement {
    private static Class<HtmlElement> CLASS = HtmlElement.class;
    protected Vector<String> m_cssClasses = null;

    public HtmlElement(Document page, int elementType) {
        super(page, elementType);
    }

    public HtmlElement(Document page, int elementType, IElement parent) {
        super(page, elementType);
        this.m_parent = parent;
    }

    public HtmlElement(HtmlElement other) {
        super(other);
        this.m_cssClasses = other.m_cssClasses;
    }

    @Override
    public IElement[] getChildren() {
        return this.m_children.toArray(new HtmlElement[0]);
    }

    @Override
    public void debugDumpTree(int level, PrintStream out) {
        int i;
        for (i = 0; i < level; ++i) {
            out.print(".");
        }
        this.debugDumpObject(out);
        for (i = 0; i < this.m_children.size(); ++i) {
            HtmlElement child = (HtmlElement)this.m_children.elementAt(i);
            child.debugDumpTree(level + 1, out);
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        switch (this.m_elementType) {
            case 7: {
                out.print("page");
                break;
            }
            case 3: {
                out.print("chart");
                break;
            }
            case 8: {
                out.print("prompt");
                break;
            }
            case 10: {
                out.print("table");
                break;
            }
            case 11: {
                out.print("textFrame");
                break;
            }
            case 5: {
                out.print("header");
                break;
            }
            case 1: {
                out.print("body");
                break;
            }
            case 4: {
                out.print("footer");
                break;
            }
            case 6: {
                out.print("image");
                break;
            }
            case 9: {
                out.print("row");
                break;
            }
            case 2: {
                out.print("cell");
                break;
            }
            case 12: {
                out.print("map");
                break;
            }
            default: {
                out.print("unknown-" + this.m_elementType);
            }
        }
        if (this.getID() != null) {
            out.print(" id=" + this.getID());
        }
        if (this.m_name != null) {
            out.print(" name=" + this.m_name);
        }
        if (this.m_type != null) {
            out.print(" type=" + this.m_type);
        }
        out.println();
    }

    @Override
    protected IElement[] getChildrenOfElementType(int elementType) {
        Vector<HtmlElement> results = new Vector<HtmlElement>();
        for (int i = 0; i < this.m_children.size(); ++i) {
            HtmlElement child = (HtmlElement)this.m_children.elementAt(i);
            if (child.getElementType() != elementType) continue;
            results.addElement(child);
        }
        if (results.size() == 0) {
            return new HtmlElement[0];
        }
        return results.toArray(new HtmlElement[0]);
    }

    @Override
    protected void generateProgram(IElement[] elements, IGenerator generator, PrintStream out) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i].generateProgram(generator, out);
        }
    }

    @Override
    protected void generateDrillThrough(IGenerator generator, PrintStream out) {
        this.generateDrillThrough(out, this.drillContexts);
    }

    protected void generateDrillThrough(PrintStream out, Vector drillContexts, String id) {
        String html;
        try {
            html = this.toDrillThroughSpanOpen(drillContexts, id);
        }
        catch (CMException e) {
            html = null;
        }
        if (html != null) {
            out.print(html);
            out.print("</span>");
        }
    }

    private String toDrillThroughSpanOpen(Vector contexts, String id) throws CMException {
        if (!this.validateDrillthrough(contexts)) {
            return null;
        }
        DrillHelper drillHelper = new DrillHelper(contexts, this.getDocument().getDrillTargets());
        String[] labels = drillHelper.getDrillTargetLabels();
        int iLabels = 0;
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] == null) continue;
            ++iLabels;
        }
        if (iLabels == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        str.append("<span class=\"drillThrough\" ");
        if (id != null) {
            str.append("areaid=\"" + id + "\" ");
        }
        str.append("dtCount=\"" + contexts.size() + "\" ");
        str.append("delta=\"" + drillHelper.getTargetsOffset(drillHelper.getContextWID()) + "\" ");
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] == null) continue;
            DrillContext context = (DrillContext)contexts.elementAt(i);
            str.append("dtIdx" + i + "=\"" + context.getDrillIndex() + "\" ");
            str.append("dtCtx" + i + "=\"");
            str.append(CMUrlHelper.encodeUrl(context.toXML()));
            str.append("\" ");
        }
        str.append(" >");
        return str.toString();
    }

    protected String generateDrillThroughSpanOpen() throws CMException {
        return this.toDrillThroughSpanOpen(this.drillContexts, null);
    }

    @Override
    public void generateStyles(IGenerator generator, PrintStream out) {
        block4: for (int i = 0; i < this.styles.size(); ++i) {
            String styleName = this.document.getMappedStyleName((String)this.styles.elementAt(i));
            switch (generator.getPass()) {
                case 0: {
                    generator.markStyleAsUsed(styleName);
                    continue block4;
                }
                case 1: {
                    HtmlStyle style = (HtmlStyle)this.document.findNamedStyle(styleName, false);
                    if (style == null) {
                        VM.log(CLASS, 0, "ignoring unknown style: " + styleName);
                        continue block4;
                    }
                    if (style.isDeleted()) {
                        VM.log(CLASS, 0, "removing unnecessary style: " + styleName);
                        continue block4;
                    }
                    this.addCssClass(styleName);
                }
            }
        }
        if (this.unnamedStyle != null) {
            ((HtmlStyle)this.unnamedStyle).generateProgram(-1, out, generator.isTesting());
        }
    }

    protected String generateTagOpen(String tagBegin, String tagEnd) {
        String nodePath;
        String attributes = this.isFocusable() && this.m_elementType != 5 && this.m_elementType != 4 ? ((nodePath = this.getNodePath()) != null && nodePath.length() > 0 ? " id=\"" + CMStringHelper.replaceAll(nodePath, ".", "_", true) + "\"" : "") : "";
        if (this.m_cssClasses != null && this.m_cssClasses.size() > 0) {
            attributes = attributes + " class=\"";
            for (int i = 0; i < this.m_cssClasses.size(); ++i) {
                if (i != 0) {
                    attributes = attributes + " ";
                }
                attributes = attributes + this.m_cssClasses.get(i);
            }
            attributes = attributes + "\"";
        }
        return tagBegin + attributes + tagEnd;
    }

    protected String generateDrillUpDownAttribute(IDrillUpDownContext drillUpDownCtx) {
        String attributes = "";
        if (drillUpDownCtx != null && (drillUpDownCtx.getCanDrillUp() || drillUpDownCtx.getCanDrillDown())) {
            attributes = attributes + " canDrillUp=\"" + drillUpDownCtx.getCanDrillUp() + "\"";
            attributes = attributes + " canDrillDown=\"" + drillUpDownCtx.getCanDrillDown() + "\"";
            attributes = attributes + " drillUpDnCtx=\"" + drillUpDownCtx.getDrillUpDownContext() + "\" ";
            if (drillUpDownCtx.getDrillUpDownWidget() != -1) {
                attributes = attributes + " drillUpDnWidget=\"" + drillUpDownCtx.getDrillUpDownWidget() + "\" ";
            }
        }
        return attributes;
    }

    public void removeChild(HtmlElement child) {
        this.m_children.removeElement(child);
    }

    public boolean showsBorder(int border) {
        boolean showsBorder = true;
        for (int i = 0; i < this.styles.size(); ++i) {
            String styleName = (String)this.styles.elementAt(i);
            HtmlStyle style = (HtmlStyle)this.document.findNamedStyle(styleName, false);
            if (style == null || style.isDeleted()) continue;
            if (style.getBorderDisplay(border) == 2) {
                showsBorder = false;
            }
            if (style.getBorderDisplay(border) != 1) continue;
            showsBorder = true;
        }
        if (this.unnamedStyle != null) {
            if (this.unnamedStyle.getBorderDisplay(border) == 2) {
                showsBorder = false;
            }
            if (this.unnamedStyle.getBorderDisplay(border) == 1) {
                showsBorder = true;
            }
        }
        return showsBorder;
    }

    protected String generateImageUrl(IGenerator generator, String m_imageUrl) {
        return this.generateImageInfo(generator, m_imageUrl)[0];
    }

    protected String[] generateImageInfo(IGenerator generator, String m_imageUrl) {
        String[] finalInfo = new String[]{m_imageUrl, null, null};
        if (!generator.isTesting()) {
            try {
                ImageInfo imageInfo = generator.storeImageResource(this.handleUrl(m_imageUrl));
                if (imageInfo.getBlobID() != -1) {
                    finalInfo[0] = CMPathHelper2.generateImageSrc(generator.getGatewayUrl(), generator.getRenderID(), imageInfo.getBlobID(), "png");
                    generator.cache(finalInfo[0], imageInfo.getBlobID());
                }
                if (imageInfo.getWidth() != -1) {
                    finalInfo[1] = Integer.toString(imageInfo.getWidth());
                }
                if (imageInfo.getHeight() != -1) {
                    finalInfo[2] = Integer.toString(imageInfo.getHeight());
                }
            }
            catch (CMException e) {
                VM.log(CLASS, 0, "problem storing image " + m_imageUrl);
            }
        } else {
            finalInfo[0] = m_imageUrl.startsWith("file://") ? m_imageUrl.substring("file://".length(), m_imageUrl.length()) : XMLHelper.encodeXml(m_imageUrl);
        }
        return finalInfo;
    }

    protected boolean isFocusable() {
        return false;
    }

    protected void addCssClass(String css) {
        if (this.m_cssClasses == null) {
            this.m_cssClasses = new Vector(1);
        }
        if (this.m_cssClasses.indexOf(css) < 0) {
            this.m_cssClasses.add(css);
        } else {
            boolean bl = true;
        }
    }

    @Override
    public void setValue(String textNode) {
    }

    @Override
    public void setUrl(String textNode) {
    }

    @Override
    public Vector getAreas() {
        return null;
    }

    @Override
    public void setHeight(int height) {
    }

    @Override
    public void setWidth(int width) {
    }

    @Override
    public void addDrillInfo(DrillTargetInfo drillInfo) {
    }

    @Override
    public void setIsTitle(boolean isTitle) {
    }
}

