/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IElementFactory;
import com.cognos.mobile.generator.IStyle;
import com.cognos.mobile.generator.IStyleParser;
import com.cognos.mobile.generator.output.html.HtmlBlockElement;
import com.cognos.mobile.generator.output.html.HtmlBodyElement;
import com.cognos.mobile.generator.output.html.HtmlCellElement;
import com.cognos.mobile.generator.output.html.HtmlChartElement;
import com.cognos.mobile.generator.output.html.HtmlDrillElement;
import com.cognos.mobile.generator.output.html.HtmlElement;
import com.cognos.mobile.generator.output.html.HtmlFooterElement;
import com.cognos.mobile.generator.output.html.HtmlHLinkElement;
import com.cognos.mobile.generator.output.html.HtmlHeaderElement;
import com.cognos.mobile.generator.output.html.HtmlHtmlElement;
import com.cognos.mobile.generator.output.html.HtmlImageElement;
import com.cognos.mobile.generator.output.html.HtmlMapElement;
import com.cognos.mobile.generator.output.html.HtmlPageElement;
import com.cognos.mobile.generator.output.html.HtmlPromptElement;
import com.cognos.mobile.generator.output.html.HtmlRowElement;
import com.cognos.mobile.generator.output.html.HtmlStyle;
import com.cognos.mobile.generator.output.html.HtmlStyleParser;
import com.cognos.mobile.generator.output.html.HtmlTableElement;
import com.cognos.mobile.generator.output.html.HtmlTextFrameElement;
import com.cognos.mobile.prompts.PButton;
import com.cognos.mobile.prompts.PDataSource;
import com.cognos.mobile.prompts.PDateTimeBox;
import com.cognos.mobile.prompts.PListBox;
import com.cognos.mobile.prompts.PSearchAndSelect;
import com.cognos.mobile.prompts.PTextBox;
import com.cognos.mobile.prompts.PTree;
import com.cognos.mobile.prompts.Prompt;
import java.util.Vector;

public class HtmlElementFactory
implements IElementFactory {
    private final Document document;
    Prompt p;

    public HtmlElementFactory(Document document) {
        this.document = document;
    }

    @Override
    public IElement create(int elementType, IElement parent) {
        switch (elementType) {
            case 1: {
                return new HtmlBodyElement(this.document, parent);
            }
            case 2: {
                return new HtmlCellElement(this.document, parent);
            }
            case 3: {
                return new HtmlChartElement(this.document, parent);
            }
            case 4: {
                return new HtmlFooterElement(this.document, parent);
            }
            case 5: {
                return new HtmlHeaderElement(this.document, parent);
            }
            case 6: {
                return new HtmlImageElement(this.document, parent);
            }
            case 8: {
                break;
            }
            case 9: {
                return new HtmlRowElement(this.document, parent);
            }
            case 10: {
                return new HtmlTableElement(this.document, parent);
            }
            case 11: {
                return new HtmlTextFrameElement(this.document, parent);
            }
            case 12: {
                return new HtmlMapElement(this.document, parent);
            }
            case 13: {
                return new HtmlDrillElement(this.document, parent);
            }
            case 14: {
                return new HtmlPageElement(this.document, parent);
            }
            case 15: {
                return new HtmlBlockElement(this.document, parent);
            }
            case 16: {
                return new HtmlHtmlElement(this.document, parent);
            }
            case 27: {
                return new HtmlHLinkElement(this.document, parent);
            }
            case 17: {
                this.p = new PButton();
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 18: {
                this.p = new PTextBox();
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 19: {
                this.p = new PDateTimeBox("DATE");
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 20: {
                this.p = new PDateTimeBox("TIME");
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 21: {
                this.p = new PDateTimeBox("DATETIME");
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 22: {
                this.p = new PDateTimeBox("INTERVAL");
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 23: {
                this.p = new PListBox();
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 24: {
                this.p = new PTree();
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 25: {
                this.p = new PSearchAndSelect();
                this.p.setRequired(true);
                return new HtmlPromptElement(this.document, parent, this.p);
            }
            case 26: {
                return new HtmlPromptElement(this.document, parent, new PDataSource());
            }
            default: {
                return new HtmlElement(this.document, elementType, parent);
            }
        }
        return null;
    }

    @Override
    public IStyle createStyle() {
        return new HtmlStyle();
    }

    @Override
    public IStyle getStyle(Object style) {
        return (HtmlStyle)style;
    }

    @Override
    public IStyle[] getStyles(Vector styles) {
        return styles.toArray(new HtmlStyle[0]);
    }

    @Override
    public IStyleParser getStyleParser() {
        return HtmlStyleParser.instance();
    }

    @Override
    public IElement getTextFrameElement(IElement element) {
        return (HtmlTextFrameElement)element;
    }

    @Override
    public IElement getHtmlElement(IElement element) {
        return (HtmlHtmlElement)element;
    }

    public IElement getChartElement(IElement element) {
        return (HtmlChartElement)element;
    }
}

