/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper2;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.Generator;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.generator.IStyle;
import com.cognos.mobile.generator.output.html.HtmlStyle;
import com.cognos.mobile.vm.IVMWriter;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import groovy.text.SimpleTemplateEngine;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Vector;

public class HtmlGenerator
extends Generator {
    private static final Class<HtmlGenerator> CLASS = HtmlGenerator.class;
    public static String m_gatewayUrl;
    private final SimpleTemplateEngine gte;
    private boolean limitedInlinePrompts = false;

    public HtmlGenerator(boolean testing, ReportCompiler reportCompiler, IVMWriter writer) {
        super(reportCompiler, writer);
        this.gte = null;
        this.setPass(0);
        this.setCurrentDocument(null);
        this.setTesting(testing);
    }

    public HtmlGenerator(SimpleTemplateEngine gte, boolean testing, ReportCompiler reportCompiler, IVMWriter writer) {
        super(reportCompiler, writer);
        this.gte = gte;
        this.setPass(0);
        this.setCurrentDocument(null);
        this.setTesting(testing);
    }

    public HtmlGenerator(SimpleTemplateEngine gte, boolean testing, ReportCompiler reportCompiler, IVMWriter writer, boolean limitPrompt) {
        super(reportCompiler, writer);
        this.gte = gte;
        this.setPass(0);
        this.setCurrentDocument(null);
        this.setTesting(testing);
        this.limitedInlinePrompts = limitPrompt;
    }

    public SimpleTemplateEngine getTemplateEngine() {
        return this.gte;
    }

    public boolean getLimitedInlinePrompts() {
        return this.limitedInlinePrompts;
    }

    @Override
    public void generate(Document doc, PrintStream out) throws CMException {
        IReport report = doc.getReport();
        for (int i = 0; i < report.getPageCount(); ++i) {
            if (report.getPage(doc, i) == null) {
                VM.log(CLASS, 2, "skipping page " + i + " because it did not contain any data");
                continue;
            }
            this.generate(doc, out, i, report.getPage(doc, i));
        }
    }

    @Override
    public void generate(Document doc, PrintStream out, int pageIndex) throws CMException {
        IReport report = doc.getReport();
        IElement page = null;
        try {
            page = report.getPage(doc, pageIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            page = report.getPage(doc, 0);
        }
        if (page == null) {
            VM.log(CLASS, 2, "skipping page " + pageIndex + " because it did not contain any data");
        } else {
            this.generate(doc, out, pageIndex, page);
        }
    }

    public void generate(Document doc, PrintStream out, int pageIndex, IElement page) throws CMException {
        IReport report = doc.getReport();
        this.setCurrentDocument(doc);
        this.setRenderID(report.getRenderID());
        m_gatewayUrl = report.getGatewayUrl();
        PrintStream nullStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        this.setPass(0);
        this.setCurrentPage(page);
        this.getCurrentPage().generateProgram(this, nullStream);
        this.setPass(1);
        if (!this.isTesting() || this.isTesting() && pageIndex == 0) {
            this.generateHeader(report, pageIndex + 1, out);
        }
        this.getCurrentPage().generateProgram(this, out);
        if (!this.isTesting() || this.isTesting() && pageIndex == report.getPageCount() - 1) {
            this.generateFooter(out);
        }
    }

    @Override
    public void markStyleAsUsed(String styleName) {
        if (this.getPass() != 0) {
            return;
        }
        if (this.getCurrentDocument() == null) {
            return;
        }
        HtmlStyle style = (HtmlStyle)this.getCurrentDocument().findNamedStyle(styleName, false);
        if (style != null) {
            style.markAsUsed();
        }
    }

    @Override
    public String getGatewayUrl() {
        return m_gatewayUrl;
    }

    @Override
    public void generateHeader(IReport report, int page, PrintStream out) {
        String timestampString = CMStringHelper2.formatDateTime(Calendar.getInstance());
        if (!this.isTesting()) {
            out.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        }
        out.print("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\" xmlns:svg=\"http://www.w3.org/2000/svg\" >");
        out.print("<head>");
        out.print("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        out.print("<title>" + XMLHelper.encodeXml(report.getLabel()) + "</title>");
        out.print("<meta name=\"Version\" content=\"" + Integer.toString(0) + "\" />");
        out.print("<meta name=\"Title\" content=\"" + XMLHelper.encodeXml(report.getLabel()) + "\" />");
        out.print("<meta name=\"Timestamp\" content=\"" + XMLHelper.encodeXml(timestampString) + "\" />");
        out.print("<meta name=\"StoreID\" content=\"" + report.getStoreID() + "\" />");
        out.print("<meta name=\"GatewayUrl\" content=\"" + XMLHelper.encodeXml(m_gatewayUrl) + "\" />");
        out.print("<meta name=\"CMPath\" content=\"" + XMLHelper.encodeXml(report.getCmPath()) + "\" />");
        out.print("<meta name=\"SourcePath\" content=\"" + XMLHelper.encodeXml(report.getSourcePath()) + "\" />");
        out.print("<meta name=\"DRILLSTR\" content=\"" + XMLHelper.encodeXml(report.getDrillParams()) + "\" />");
        out.print("<meta name=\"Page\" content=\"" + page + "\" />");
        out.print("<meta name=\"RenderID\" content=\"" + report.getRenderID() + "\" />");
        String hasMorePages = "false";
        if (this.reportCompiler != null && this.reportCompiler.getHasNextPage()) {
            hasMorePages = "true";
        }
        out.print("<meta name=\"hasmorepages\" content=\"" + hasMorePages + "\" />");
        out.print("<meta name=\"sourceCode\" content=\"" + report.getSourceCode() + "\" />");
        Vector drillTargets = this.getCurrentDocument().getDrillTargets();
        out.print("<meta name=\"drillTargetCount\" content=\"" + drillTargets.size() + "\" />");
        if (report.getBurstValue() != null) {
            out.print("<meta name=\"BURSTVALUE\" content=\"" + XMLHelper.encodeXml(report.getBurstValue()) + "\" />");
        }
        for (int i = 0; i < drillTargets.size(); ++i) {
            DrillTargetInfo target = (DrillTargetInfo)drillTargets.elementAt(i);
            out.print("<meta name=\"drillTarget" + i + "\" content=\"" + target.getLabel() + "\" />");
            out.print("<meta name=\"drillTargetXML" + i + "\" content=\"" + CMUrlHelper.encodeUrl(target.toXML()) + "\" />");
        }
        out.print("<style id=\"page-style\" type=\"text/css\">");
        this.generateStylesSubroutines(out);
        out.print("</style>");
        out.print("</head>");
        out.print("<body>");
    }

    @Override
    public void generateFooter(PrintStream out) {
        out.print("</body>");
        out.print("</html>");
    }

    @Override
    protected void generateStylesSubroutines(PrintStream out) {
        IStyle[] styles = this.getCurrentDocument().getNamedStyles();
        for (int i = 0; i < styles.length; ++i) {
            boolean styleHasEffect;
            if (!styles[i].isUsed() && !this.isTesting() || (styleHasEffect = ((HtmlStyle)styles[i]).generateProgram(this.getCurrentDocument().getPageIndex(), out, this.isTesting()))) continue;
            styles[i].markAsDeleted();
        }
    }
}

