/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.VM;
import java.net.URI;
import java.net.URISyntaxException;

public class HtmlGrammar {
    private static Class CLASS = HtmlGrammar.class;
    public static final String MNEMONIC_BACK_COLOR = "background-color:";
    public static final String MNEMONIC_BLOCK_BEGIN = "<div";
    public static final String MNEMONIC_BLOCK_END = "</div>";
    public static final String MNEMONIC_BODY_BEGIN = "<div";
    public static final String MNEMONIC_BODY_END = "</div>";
    public static final String MNEMONIC_BORDER_COLOR = "";
    public static final String MNEMONIC_CALL = "";
    public static final String MNEMONIC_CHART_BEGIN = "<div";
    public static final String MNEMONIC_CHART_END = "</div>";
    public static final String MNEMONIC_CLEAR_STYLE = "<span class=\"clearStyle\" />";
    public static final String MNEMONIC_DOCUMENT_END = "</body></html>";
    public static final String MNEMONIC_EMBED_BEGIN = "<embed";
    public static final String MNEMONIC_EMBED_END = "</embed>";
    public static final String MNEMONIC_END = "";
    public static final String MNEMONIC_FLOW = "";
    public static final String MNEMONIC_FONT = "";
    public static final String MNEMONIC_FOOTER_BEGIN = "<div";
    public static final String MNEMONIC_FOOTER_END = "</div>";
    public static final String MNEMONIC_GROUP_BEGIN = "<span class=\"group\">";
    public static final String MNEMONIC_GROUP_END = "</span>";
    public static final String MNEMONIC_HEADER_BEGIN = "<div";
    public static final String MNEMONIC_HEADER_END = "</div>";
    public static final String MNEMONIC_IMAGE_BEGIN = "<img";
    public static final String MNEMONIC_IMAGE_END = " />";
    public static final String MNEMONIC_LABEL = "";
    public static final String MNEMONIC_NEXT_LINE = "";
    public static final String MNEMONIC_NOP = "";
    public static final String MNEMONIC_PAGE_BEGIN = "<div";
    public static final String MNEMONIC_PAGE_END = "</div>";
    public static final String MNEMONIC_RETURN = "";
    public static final String MNEMONIC_SPOT_BEGIN = "<!-- spot: ";
    public static final String MNEMONIC_SPOT_END = " -->";
    public static final String MNEMONIC_TABLE_BEGIN = "<table";
    public static final String MNEMONIC_TABLE_CELL_BEGIN = "<td";
    public static final String MNEMONIC_TABLE_CELL_END = "</td>";
    public static final String MNEMONIC_TABLE_END = "</table>";
    public static final String MNEMONIC_TABLE_FREEZE_BEGIN = "<!-- tableFreeze: ";
    public static final String MNEMONIC_TABLE_FREEZE_END = " -->";
    public static final String MNEMONIC_TABLE_ROW_BEGIN = "<tr";
    public static final String MNEMONIC_TABLE_ROW_END = "</tr>";
    public static final String MNEMONIC_TEXT_BEGIN = "<span";
    public static final String MNEMONIC_TEXT_END = "</span>";
    public static final String MNEMONIC_TEXT_ALIGN = "text-align:";
    public static final String MNEMONIC_TEXT_COLOR = "color:";
    public static final String MNEMONIC_SET_STYLE = "";
    public static final String MNEMONIC_DRILL_CONTEXT_BEGIN = "<span class=\"drillContext\" ";
    public static final String MNEMONIC_DRILL_CONTEXT_END = "</span>";
    public static final String MNEMONIC_DRILL_INDEX = "";
    public static final String MNEMONIC_PARAMETER = "";
    public static final String MNEMONIC_PARAMETER_MUN = "";
    public static final String MNEMONIC_DRILL_BEGIN = "";
    public static final String MNEMONIC_DRILL_END = "";
    public static final String MNEMONIC_DRILL_CMPATH = "";
    public static final String MNEMONIC_DRILL_LABEL = "";
    public static final String MNEMONIC_DRILL_PARAMNAMETYPE = "";
    public static final String MNEMONIC_DRILL_SEARCHOBJECT = "";
    public static final String MNEMONIC_BORDERDISPLAY = "";
    public static final String MNEMONIC_MAP_BEGIN = "<map";
    public static final String MNEMONIC_MAP_END = "</map>";
    public static final String MNEMONIC_AREA_BEGIN = "<area";
    public static final String MNEMONIC_AREA_END = "</area>";
    public static final String META_TIMESTAMP = "Timestamp";
    public static final String META_TITLE = "Title";
    public static final String META_VERSION = "Version";
    public static final String META_PAGECOUNT = "PageCount";
    public static final String META_MAXPAGES = "MaxPages";
    public static final String META_PAGE = "Page";
    public static final String META_STOREID = "StoreID";
    public static final String META_SOURCEPATH = "SourcePath";
    public static final String META_GATEWAYURL = "GatewayUrl";
    public static final String META_CMPATH = "CMPath";
    public static final String META_STATUS = "STATUS";
    public static final String META_DRILLPARAMS = "DRILLSTR";
    public static final String META_RENDERID = "RenderID";
    public static final String META_BURSTVALUE = "BURSTVALUE";
    public static final String META_HASMOREPAGES = "hasmorepages";
    public static final String META_SOURCECODE = "sourceCode";
    public static final String META_ISFAVOURITE = "favourite";
    public static final String META_ISDASHBOARD = "dashboard";
    public static final String META_PERMISSIONS = "permissions";
    public static final String FONT_WEIGHT = "font-weight:";
    public static final String FONT_BOLD = "bold";
    public static final String FONT_STYLE = "font-style:";
    public static final String FONT_ITALIC = "italic";
    public static final String FONT_NORMAL = "normal";
    public static final String TEXT_DECORATION = "text-decoration:";
    public static final String FONT_UNDERLINE = "underline";
    public static final String FONT_FAMILY = "font-family:";
    public static final String FONT_SIZE = "font-size:";
    public static final String TEXTALIGN_CENTER = "center";
    public static final String TEXTALIGN_LEFT = "left";
    public static final String TEXTALIGN_RIGHT = "right";
    public static final String NODESTYLE_SELECT_OBJECT = "SELECTOBJECT";
    public static final String NODESTYLE_SELECT_PAGE = "SELECTPAGE";
    public static final String NODESTYLE_TABLE_LAYOUT = "TABLELAYOUT";
    public static final String NODESTYLE_IMAGE_AREA = "IMAGEAREA";
    public static final String NODESTYLE_DRILL_THROUGH = "DRILLTHROUGH";
    public static final String FLOW_LEFT_TO_RIGHT = "LEFTTORIGHT";
    public static final String FLOW_RIGHT_TO_LEFT = "RIGHTTOLEFT";
    public static final String BORDER_TOP_STYLE = "border-top-style:";
    public static final String BORDER_RIGHT_STYLE = "border-right-style:";
    public static final String BORDER_BOTTOM_STYLE = "border-bottom-style:";
    public static final String BORDER_LEFT_STYLE = "border-left-style:";
    public static final String BORDER_TOP_COLOR = "border-top-color:";
    public static final String BORDER_RIGHT_COLOR = "border-right-color:";
    public static final String BORDER_BOTTOM_COLOR = "border-bottom-color:";
    public static final String BORDER_LEFT_COLOR = "border-left-color:";
    public static final String BORDER_TOP_WIDTH = "border-top-width:";
    public static final String BORDER_RIGHT_WIDTH = "border-right-width:";
    public static final String BORDER_BOTTOM_WIDTH = "border-bottom-width:";
    public static final String BORDER_LEFT_WIDTH = "border-left-width:";
    public static final String HTML_OPEN_TAG_BEGIN = "<";
    public static final String HTML_CLOSE_TAG_BEGIN = "</";
    public static final String HTML_TAG_END = ">";
    public static final String HTML_SINGLE_TAG_BEGIN = "<";
    public static final String HTML_SINGLE_TAG_END = " />";
    public static final String HTML_LINK_OPEN_BEGIN = "<a href=\"";
    public static final String HTML_LINK_OPEN_END = "\">";
    public static final String HTML_LINK_CLOSE = "</a>";
    public static final String HTML_DRILLTHROUGH_OPEN_BEGIN = "<span class=\"drillThrough\" ";
    public static final String HTML_DRILLTHROUGH_OPEN_TAG_END = " >";
    public static final String HTML_DRILLTHROUGH_CLOSE_TAG_END = "</span>";
    public static final String STYLE_SOLID = "solid";
    public static final String STYLE_NONE = "none";
    public static final String STYLE_HEIGHT = "height:";
    public static final String STYLE_WIDTH = "width:";
    public static final String STYLE_LAYOUT_CLASS = "layout";
    public static final String STYLE_DATATABLE_CLASS = "data";
    public static final String STYLE_CHART_CLASS = "chart";
    public static final String STYLE_TOPLEFT_CLASS = "topleft";
    public static final String STYLE_TOP_CLASS = "top";
    public static final String STYLE_LEFT_CLASS = "left";
    public static final String URITAG_MOB_HYPERLINK = "MOB_HYPERLINK";
    public static final String URL_FORMAT_IMAGESRC = "{1}/{2}/mobileService/renders/{3}/images/{4}.{5}";
    public static final String URL_FORMAT_DRILLHREF = "{1}://{2}{3}{4}{5}";
    public static final String URL_FORMAT_TABLEHREF = "{1}/{2}/mobileService/renders/{3}/tables/{4}.html";
    public static final String URL_FORMAT_SVGHREF = "{1}/{2}/mobileService/renders/{3}/charts/{4}.{5}";

    public static final String generateHyperlinkTaggedUri(String uriString) throws URISyntaxException {
        URI targetURI = new URI(uriString);
        URI taggedURI = new URI(targetURI.getScheme(), URITAG_MOB_HYPERLINK, targetURI.getHost(), targetURI.getPort(), targetURI.getPath(), targetURI.getQuery(), targetURI.getFragment());
        return taggedURI.toString();
    }

    public static final String generateImageSrc(String gatewayUrl, int renderId, int blobId, String imgFormat) throws CMException {
        com.cognos.mobile.request.URI uri = com.cognos.mobile.request.URI.parseURI(gatewayUrl, !gatewayUrl.startsWith("?"));
        String[] params = new String[]{uri.getPath(), uri.getQuery(), String.valueOf(renderId), String.valueOf(blobId), imgFormat};
        return CMStringHelper.formatString(URL_FORMAT_IMAGESRC, params);
    }

    public static final String generateDrillThroughHref(String gatewayUrl, String queryString) throws CMException {
        com.cognos.mobile.request.URI uri = com.cognos.mobile.request.URI.parseURI(gatewayUrl, !gatewayUrl.startsWith("?"));
        String host = uri.getHost() + (uri.getPort() == 80 ? "" : ":" + uri.getPort());
        String path = uri.getPath() != null ? uri.getPath() + "/" : "";
        String[] params = new String[]{uri.getScheme(), host, path, uri.getQuery(), queryString};
        return CMStringHelper.formatString(URL_FORMAT_DRILLHREF, params);
    }

    public static final String generateTableHref(String gatewayUrl, int renderId, int blobId) throws CMException {
        com.cognos.mobile.request.URI uri = com.cognos.mobile.request.URI.parseURI(gatewayUrl, !gatewayUrl.startsWith("?"));
        gatewayUrl = uri.getPath();
        String[] params = new String[]{uri.getPath(), uri.getQuery(), String.valueOf(renderId), String.valueOf(blobId)};
        return CMStringHelper.formatString(URL_FORMAT_TABLEHREF, params);
    }

    public static final String generateSvgHref(String gatewayUrl, int renderId, int blobId, String format) {
        try {
            com.cognos.mobile.request.URI uri = com.cognos.mobile.request.URI.parseURI(gatewayUrl, !gatewayUrl.startsWith("?"));
            gatewayUrl = uri.getPath();
            String[] params = new String[]{uri.getPath(), uri.getQuery(), String.valueOf(renderId), String.valueOf(blobId), format};
            return CMStringHelper.formatString(URL_FORMAT_SVGHREF, params);
        }
        catch (CMException e) {
            VM.log(CLASS, 3, "couldn't parse URI '" + gatewayUrl + "'", e);
            return "";
        }
    }
}

