/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlElement;
import com.cognos.mobile.generator.output.html.HtmlGrammar;
import com.cognos.mobile.xml.XMLHelper;
import java.io.PrintStream;
import java.net.URISyntaxException;

public class HtmlHLinkElement
extends HtmlElement {
    private String target;

    public HtmlHLinkElement(Document page, IElement parent) {
        super(page, 27, parent);
    }

    public HtmlHLinkElement(HtmlHLinkElement other) {
        super(other);
        this.target = other.target;
    }

    @Override
    public void setUrl(String target) {
        try {
            this.target = HtmlGrammar.generateHyperlinkTaggedUri(target);
        }
        catch (URISyntaxException e) {
            this.target = target;
            e.printStackTrace();
        }
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        if (this.target != null) {
            out.print("<a href=\"");
            out.print(this.prepTextValue(this.target));
            out.print("\">");
        }
        super.generateProgram(generator, out);
        if (this.target != null) {
            out.print("</a>");
        }
    }

    private String prepTextValue(String value) {
        return value == null ? "" : XMLHelper.xmlDecode(value);
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("target '" + this.target + "'");
    }
}

