/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlElement;
import java.io.PrintStream;

public class HtmlImageElement
extends HtmlElement {
    private String m_url;

    public HtmlImageElement(Document page, IElement parent) {
        super(page, 6, parent);
    }

    public HtmlImageElement(HtmlImageElement other) {
        super(other);
        this.m_url = other.m_url;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        if (this.m_url != null) {
            String[] imageInfo;
            String drillUrl;
            this.generateStyles(generator, out);
            try {
                drillUrl = this.generateDrillThroughSpanOpen();
            }
            catch (CMException e) {
                drillUrl = null;
            }
            if (drillUrl != null) {
                out.print(drillUrl);
            }
            if ((imageInfo = this.generateImageInfo(generator, this.m_url)).length > 2 && imageInfo[1] != null && !imageInfo[1].equals("-1") && imageInfo[2] != null && !imageInfo[2].equals("-1")) {
                out.print(this.generateTagOpen("<img", " src=\"" + imageInfo[0] + "\" width=\"" + imageInfo[1] + "\" height=\"" + imageInfo[2] + "\" alt=\"image\" " + " />"));
            } else {
                out.print(this.generateTagOpen("<img", " src=\"" + imageInfo[0] + "\" alt=\"image\" " + " />"));
            }
            if (drillUrl != null) {
                out.print("</span>");
            }
        }
    }

    @Override
    public void setUrl(String url) {
        this.m_url = url;
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("image: url=" + this.m_url);
    }

    @Override
    protected boolean isFocusable() {
        return true;
    }
}

