/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMAreaAndCentroid;
import com.cognos.mobile.common.CMMathHelper2;
import com.cognos.mobile.generator.Area;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlElement;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class HtmlMapElement
extends HtmlElement {
    private static Class CLASS = HtmlMapElement.class;
    private Vector m_areas;
    private String mapName;

    public HtmlMapElement(Document page, IElement parent) {
        super(page, 12, parent);
        this.m_areas = new Vector();
        this.mapName = "";
    }

    public HtmlMapElement(HtmlMapElement other) {
        super(other);
        this.m_areas = other.m_areas;
        this.mapName = other.mapName;
    }

    @Override
    public void setMap(String map) {
        this.mapName = map;
    }

    public void generateProgram(IGenerator generator, PrintStream out, int imageWidth, int imageHeight) {
        this.calCentralPoint();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        out.print("<map class=\"chart_map\" name=\"" + this.mapName + "\">");
        for (int i = 0; i < this.m_areas.size(); ++i) {
            Area area = (Area)this.m_areas.elementAt(i);
            String id = "area" + i;
            String drillUpDown = this.generateDrillUpDownAttribute(area.drillCtx);
            out.print("<area" + drillUpDown + " id=\"" + id + "\"" + " class=\"chart_area\" coords=\"" + this.polyToString(area.poly) + "\" centroid=\"" + (int)area.centroidX + "," + (int)area.centroidY + "\" shape=\"POLY\" type=\"" + area.typeToString(area.type) + "\" label=\"" + XMLHelper.encodeXml(area.label) + "\"/>");
            this.generateDrillThrough(ps, area.drillTargets, id);
        }
        ps.flush();
        try {
            out.print(baos.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            VM.log(CLASS, 3, "", uee);
        }
        out.print("</map>");
    }

    private String polyToString(int[] poly) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < poly.length; ++i) {
            str.append(poly[i]);
            if (i == poly.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("map " + this.m_areas.size() + " area(s)");
    }

    private void calCentralPoint() {
        for (int i = 0; i < this.m_areas.size(); ++i) {
            Area area = (Area)this.m_areas.elementAt(i);
            CMAreaAndCentroid res = CMMathHelper2.computeAreaAndCentroid(area.poly);
            area.area = Math.abs(res.area);
            area.centroidX = res.centroidX;
            area.centroidY = res.centroidY;
        }
    }

    @Override
    public Vector getAreas() {
        return this.m_areas;
    }
}

