/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlElement;
import com.cognos.mobile.generator.output.html.HtmlGenerator;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class HtmlPromptElement
extends HtmlElement {
    private static final Class CLASS = HtmlPromptElement.class;
    private Prompt prompt;
    private String[] invalidPrompts = new String[]{"PDataSource", "PSearchAndSelect", "PSearchAndSelect_MultiSelect", "PTree", "PTree_MultiSelect"};
    private final List<String> INVALID_INLINE_PROMPT_FILES;

    public HtmlPromptElement(Document page, IElement parent, Prompt prompt) {
        super(page, 17, parent);
        this.prompt = prompt;
        this.INVALID_INLINE_PROMPT_FILES = Arrays.asList(this.invalidPrompts);
    }

    @Override
    public Prompt getPrompt() {
        return this.prompt;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        if (generator.getPass() == 0) {
            return;
        }
        VM.log(CLASS, 0, "Generating html prompt: " + this.prompt);
        IElement pageEl = this.document.getPageElement();
        HtmlGenerator g = (HtmlGenerator)generator;
        SimpleTemplateEngine gte = g.getTemplateEngine();
        if (gte != null) {
            try {
                String filename = this.prompt.getTag();
                if (this.prompt.isMultiSelect()) {
                    filename = filename + "_MultiSelect";
                }
                if (this.prompt.isRange()) {
                    filename = filename + "_Range";
                }
                if (this.isSupportedPromptType(g, filename)) {
                    filename = filename + ".html";
                    File f = new File(filename);
                    VM.log(CLASS, 0, "Loading template: " + filename);
                    Template t = gte.createTemplate(f);
                    VM.log(CLASS, 0, "Loaded template: " + t);
                    HashMap<String, Object> binding = new HashMap<String, Object>();
                    XMLHelper xmlhelper = new XMLHelper();
                    binding.put("prompt", this.prompt);
                    binding.put("xmlhelper", xmlhelper);
                    if (pageEl.getID() != null && pageEl.getID().equals("defaultPromptPage")) {
                        binding.put("label", Boolean.FALSE);
                    } else {
                        binding.put("label", Boolean.TRUE);
                    }
                    out.print(t.make(binding).toString());
                }
            }
            catch (Exception ioe) {
                VM.log(CLASS, 3, "", ioe);
            }
        }
    }

    private boolean isSupportedPromptType(HtmlGenerator g, String promptName) {
        if (g.getLimitedInlinePrompts()) {
            return !this.INVALID_INLINE_PROMPT_FILES.contains(promptName);
        }
        return true;
    }
}

