/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMBitHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Style;
import com.cognos.mobile.vm.VM;
import java.io.PrintStream;

public class HtmlStyle
extends Style {
    private static Class CLASS = HtmlStyle.class;

    public HtmlStyle() {
    }

    public HtmlStyle(HtmlStyle other) {
        this.m_name = other.getName();
        this.m_isUsed = other.isUsed();
        this.m_isDeleted = other.isDeleted();
        this.m_backgroundColor = other.getBackgroundColor();
        this.m_fontColor = other.getFontColor();
        this.m_textAlign = other.getTextAlign();
        this.m_isBold = other.isBold();
        this.m_isItalics = other.isItalics();
        this.m_isUnderline = other.isUnderline();
        this.m_height = other.getHeight();
        this.m_width = other.getWidth();
        this.m_borderDisplay[0] = other.getBorderDisplay(0);
        this.m_borderDisplay[1] = other.getBorderDisplay(1);
        this.m_borderDisplay[2] = other.getBorderDisplay(2);
        this.m_borderDisplay[3] = other.getBorderDisplay(3);
        this.m_borderColor[0] = other.getBorderColor(0);
        this.m_borderColor[1] = other.getBorderColor(1);
        this.m_borderColor[2] = other.getBorderColor(2);
        this.m_borderColor[3] = other.getBorderColor(3);
        this.m_borderStyle[0] = other.getBorderStyle(0);
        this.m_borderStyle[1] = other.getBorderStyle(1);
        this.m_borderStyle[2] = other.getBorderStyle(2);
        this.m_borderStyle[3] = other.getBorderStyle(3);
        this.m_borderWidth[0] = other.getBorderWidth(0);
        this.m_borderWidth[1] = other.getBorderWidth(1);
        this.m_borderWidth[2] = other.getBorderWidth(2);
        this.m_borderWidth[3] = other.getBorderWidth(3);
    }

    @Override
    public boolean generateProgram(int pageIndex, PrintStream out) {
        return this.generateProgram(pageIndex, out, false);
    }

    public boolean generateProgram(int pageIndex, PrintStream out, boolean isTesting) {
        int borderDisplay;
        String hex;
        StringBuffer css = new StringBuffer();
        Integer intValue = this.m_backgroundColor;
        if (intValue != null) {
            hex = CMStringHelper.formatColorHtml(intValue);
            css.append("background-color:" + hex + ";");
        }
        if ((intValue = this.m_fontColor) != null) {
            hex = CMStringHelper.formatColorHtml(intValue);
            css.append("color:" + hex + ";");
        }
        int fontStyle = 0;
        Boolean boolValue = this.m_isBold;
        if (boolValue != null) {
            fontStyle |= 1;
        }
        if ((boolValue = this.m_isItalics) != null) {
            fontStyle |= 4;
        }
        if ((boolValue = this.m_isUnderline) != null) {
            fontStyle |= 2;
        }
        if (fontStyle != 0) {
            String fontWeightExpr = null;
            String fontStyleExpr = null;
            String textDecorExpr = null;
            switch (fontStyle) {
                case 1: {
                    fontWeightExpr = "bold";
                    break;
                }
                case 4: {
                    fontStyleExpr = "italic";
                    break;
                }
                case 2: {
                    textDecorExpr = "underline";
                    break;
                }
                case 5: {
                    fontWeightExpr = "bold";
                    fontStyleExpr = "italic";
                    break;
                }
                case 3: {
                    fontWeightExpr = "bold";
                    textDecorExpr = "underline";
                    break;
                }
                case 6: {
                    fontStyleExpr = "italic";
                    textDecorExpr = "underline";
                    break;
                }
                case 7: {
                    fontWeightExpr = "bold";
                    fontStyleExpr = "italic";
                    textDecorExpr = "underline";
                }
            }
            if (fontWeightExpr != null) {
                css.append("font-weight:" + fontWeightExpr + ";");
            }
            if (fontStyleExpr != null) {
                css.append("font-style:" + fontStyleExpr + ";");
            }
            if (textDecorExpr != null) {
                css.append("text-decoration:" + textDecorExpr + ";");
            }
        }
        if (this.m_textAlign != null) {
            switch (this.m_textAlign) {
                case 0: {
                    css.append("text-align:left;");
                    break;
                }
                case 1: {
                    css.append("text-align:right;");
                    break;
                }
                case 2: {
                    css.append("text-align:center;");
                }
            }
        }
        if ((borderDisplay = CMBitHelper.readInt(this.m_borderDisplay, 0)) > 0) {
            byte[] displayBorders = new byte[4];
            CMBitHelper.writeInt(borderDisplay, displayBorders, 0);
            this.generateBorderDisplay(displayBorders, css);
        }
        if (this.m_borderColor[0] != null) {
            hex = CMStringHelper.formatColorHtml(this.m_borderColor[0]);
            css.append("border-top-color:" + hex + ";");
        }
        if (this.m_borderColor[1] != null) {
            hex = CMStringHelper.formatColorHtml(this.m_borderColor[1]);
            css.append("border-right-color:" + hex + ";");
        }
        if (this.m_borderColor[2] != null) {
            hex = CMStringHelper.formatColorHtml(this.m_borderColor[2]);
            css.append("border-bottom-color:" + hex + ";");
        }
        if (this.m_borderColor[3] != null) {
            hex = CMStringHelper.formatColorHtml(this.m_borderColor[3]);
            css.append("border-left-color:" + hex + ";");
        }
        if (this.m_borderStyle[0] != null) {
            css.append("border-top-style:" + this.m_borderStyle[0] + ";");
        }
        if (this.m_borderStyle[1] != null) {
            css.append("border-right-style:" + this.m_borderStyle[1] + ";");
        }
        if (this.m_borderStyle[2] != null) {
            css.append("border-bottom-style:" + this.m_borderStyle[2] + ";");
        }
        if (this.m_borderColor[3] != null) {
            css.append("border-left-style:" + this.m_borderStyle[3] + ";");
        }
        if (this.m_borderWidth[0] != null) {
            css.append("border-top-width:" + this.m_borderWidth[0].getValue() + this.m_borderWidth[0].getUnits() + ";");
        }
        if (this.m_borderWidth[1] != null) {
            css.append("border-right-width:" + this.m_borderWidth[1].getValue() + this.m_borderWidth[1].getUnits() + ";");
        }
        if (this.m_borderWidth[2] != null) {
            css.append("border-bottom-width:" + this.m_borderWidth[2].getValue() + this.m_borderWidth[2].getUnits() + ";");
        }
        if (this.m_borderWidth[3] != null) {
            css.append("border-left-width:" + this.m_borderWidth[3].getValue() + this.m_borderWidth[3].getUnits() + ";");
        }
        if (this.m_height != null) {
            css.append("height:" + this.m_height.getValue() + this.m_height.getUnits() + ";");
        }
        if (this.m_width != null) {
            css.append("width:" + this.m_width.getValue() + this.m_width.getUnits() + ";");
        }
        if (this.m_fontFamily != null) {
            css.append("font-family:" + this.m_fontFamily + ";");
        }
        if (this.m_fontSize != null) {
            css.append("font-size:" + this.m_fontSize.getValue() + this.m_fontSize.getUnits() + ";");
        }
        if (css.length() == 0) {
            VM.log(CLASS, 0, "style omitted: " + this.m_name);
            return false;
        }
        out.print("." + this.m_name + ", table>tbody>tr>td." + this.m_name + "{" + css.toString() + "}");
        if (isTesting) {
            out.print("\n");
        }
        return true;
    }

    public void generateBorderDisplay(byte[] borderDisplay, StringBuffer css) {
    }
}

