/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IStyle;
import com.cognos.mobile.generator.IStyleParser;
import com.cognos.mobile.generator.output.html.HtmlStyle;
import com.cognos.mobile.vm.VM;

public class HtmlStyleParser
implements IStyleParser {
    private static HtmlStyleParser singleton = null;
    private static Class CLASS = HtmlStyleParser.class;
    private static String SEP = ";";
    private static String EQ = ":";
    private static String OPENB = "{";
    private static String CLOSEB = "}";
    private static String COLOR_AQUA = "aqua";
    private static String COLOR_BLACK = "black";
    private static String COLOR_BLUE = "blue";
    private static String COLOR_FUCHSIA = "fuchsia";
    private static String COLOR_GRAY = "gray";
    private static String COLOR_GREEN = "green";
    private static String COLOR_LIME = "lime";
    private static String COLOR_MAROON = "maroon";
    private static String COLOR_NAVY = "navy";
    private static String COLOR_OLIVE = "olive";
    private static String COLOR_PURPLE = "purple";
    private static String COLOR_RED = "red";
    private static String COLOR_SILVER = "silver";
    private static String COLOR_TEAL = "teal";
    private static String COLOR_WHITE = "white";
    private static String COLOR_YELLOW = "yellow";
    private static String TRANSPARENT = "transparent";
    private static final String DEFAULT_CSS_NAME_GRS_1 = "../schemas/GlobalReportStyles_1.css";
    private static final String DEFAULT_CSS_GRS_1 = ".ta { font-size: 14pt; font-weight: bold; text-align: center; color: #000000; text-decoration: underline;}.tt { text-decoration: underline;}.ts { font-size: 10pt; text-align: center; color: #9999CC;}.ft { font-size: 10pt; color: #9999CC;}.lt { text-align: center; background-color: #E3E3FC; font-weight: bold;}.ih { color: #999999;}.if { color: #999999;}.oh { color: #999999;}.of { color: #999999;}.is { font-weight: bold;}.os { font-weight: bold;}.sh { font-size: 10pt; font-weight: bold;}.sf { color: #999999;}.sg { font-weight: bold;}.sk { font-weight: bold;}.so { color: #999999;}.sp { font-weight: bold;}.ss { font-weight: bold;}.xm { font-weight: bold;color: #CCCCCC;}.ml { background-color: #E3E3FC; font-weight: bold;}.cl { background-color: #E3E3FC; font-weight: bold;}.sl { background-color: #E3E3FC; font-weight: bold;}.hl { background-color: #E3E3FC; font-weight: bold;}.nl { background-color: #E3E3FC; font-weight: bold;}.xl { background-color: #E3E3FC; font-weight: bold;}.mv { text-align: right; white-space: nowrap;}.cv { text-align: right; white-space: nowrap;}.sv { text-align: right; white-space: nowrap;}.hv { text-align: right; white-space: nowrap;}.nv { text-align: right; white-space: nowrap;}.xv { text-align: right; white-space: nowrap;}.il { background-color: #E3E3FC; font-weight: bold; font-style: italic;}.ol { background-color: #E3E3FC; font-weight: bold; font-style: italic;}.iv { text-align: right; font-weight: bold;}.ov { text-align: right; font-weight: bold;}.dm { color: blue; text-decoration: underline;}.hy { color: blue; text-decoration: underline;}";
    private static final String DEFAULT_CSS_GRS = ".ta { font-size: 14pt; font-weight: bold; text-align: center; text-decoration: underline;}.ts { font-size: 10pt; text-align: center;}.ft { font-size: 8pt; color: #9999CC; }.ls { font-size: 8pt; }.lt { text-align: center; background-color: #BFD2E2;}.lm {\ttext-align: right;}.ih { font-weight: bold; background-color: #F2F1F1;}.if { font-weight: bold; background-color: #F2F1F1;}.is { font-weight: bold; background-color: #F2F1F1; text-align: right;}.oh { font-weight: bold; background-color: #DFDFDF;}.of { font-weight: bold; background-color: #DFDFDF;}.os { font-weight: bold; background-color: #DFDFDF; text-align: right;}.sh { font-size: 10pt; font-weight: bold;}.sk { font-size: 10pt; font-weight: bold;}.sf { color: #999999;}.sg { color: #999999;}.so { color: #999999;}.sp { color: #999999;}.ss { font-weight: bold;}.xt { font-size: 8pt;}.xm { font-weight: bold; text-align: center; background-color: #FFFFFF;}.ml { background-color: #BFD2E2;}.mv { white-space: nowrap; text-align: right;}.cl { font-style: italic; background-color: #BFD2E2;}.cv { font-style: italic; white-space: nowrap; text-align: right;}.sl { font-style: italic; background-color: #BFD2E2;}.sv { white-space: nowrap; background-color: #F2F1F1; text-align: right;}.hl { font-style: italic; background-color: #BFD2E2;}.hv { white-space: nowrap; background-color: #F2F1F1; text-align: right;}.nl { font-weight: bold; background-color: #F2F1F1;}.nv { font-weight: bold; white-space: nowrap; background-color: #F2F1F1; text-align: right;}.xl { font-style: italic; background-color: #BFD2E2;}.xv { white-space: nowrap; background-color: #F2F1F1; text-align: right;}.il { font-weight: bold; background-color: #F2F1F1;}.iv { font-weight: bold; white-space: nowrap; background-color: #F2F1F1; text-align: right;}.ol { font-weight: bold; background-color: #DFDFDF;}.ov { font-weight: bold; white-space: nowrap; background-color: #DFDFDF; text-align: right;}.dm { color: blue; text-decoration: underline;}.ct { font-size: 12pt; text-align: center; font-weight: bold;}.cs { font-size: 10pt; text-align: center; font-weight: normal;}.cf { font-size: 10pt; text-align: center; font-weight: normal;}.lx { font-size: 10pt; font-weight: bold; text-align: left;}.lg { font-size: 8pt; text-align: left;}.at { font-size: 8pt; font-weight:bold; text-align:center;}.al { font-size: 8pt;}.fp { background-color: #E7E7E7;}.hy { color: blue; text-decoration: underline;}";

    public static HtmlStyleParser instance() {
        if (singleton == null) {
            singleton = new HtmlStyleParser();
        }
        return singleton;
    }

    @Override
    public void parseGlobalStylesheet(Document page, String stylesheet) {
        String styleSheet = stylesheet.equals(DEFAULT_CSS_NAME_GRS_1) ? DEFAULT_CSS_GRS_1 : DEFAULT_CSS_GRS;
        this.updateStylesCommon(page, null, styleSheet);
    }

    @Override
    public void parseUnnamedStyle(IElement element, String CSS) {
        this.updateStylesCommon(null, element, CSS);
    }

    @Override
    public boolean containsCCSstyles(String CSS) {
        return CSS.indexOf("font") >= 0 || CSS.indexOf("text-decoration") >= 0 || CSS.indexOf("color") >= 0 || CSS.indexOf("mso") >= 0 || CSS.indexOf("background") >= 0 || CSS.indexOf("text-align") >= 0;
    }

    @Override
    public int parseColor(String color) {
        if (color.indexOf("#") >= 0) {
            if ((color = color.substring(color.indexOf("#") + 1)).length() > 3) {
                return Integer.parseInt(color, 16);
            }
            char[] nColor = new char[]{color.charAt(0), color.charAt(0), color.charAt(1), color.charAt(1), color.charAt(2), color.charAt(2)};
            return Integer.parseInt(new String(nColor), 16);
        }
        if (color.equals(COLOR_WHITE)) {
            return 0xFFFFFF;
        }
        if (color.equals(COLOR_BLACK)) {
            return 0;
        }
        if (color.equals(COLOR_AQUA)) {
            return 65535;
        }
        if (color.equals(COLOR_BLUE)) {
            return 255;
        }
        if (color.equals(COLOR_FUCHSIA)) {
            return 0xFF00FF;
        }
        if (color.equals(COLOR_GRAY)) {
            return 0x808080;
        }
        if (color.equals(COLOR_GREEN)) {
            return 32768;
        }
        if (color.equals(COLOR_LIME)) {
            return 65280;
        }
        if (color.equals(COLOR_MAROON)) {
            return 0x800000;
        }
        if (color.equals(COLOR_NAVY)) {
            return 128;
        }
        if (color.equals(COLOR_OLIVE)) {
            return 0x808000;
        }
        if (color.equals(COLOR_PURPLE)) {
            return 0x800080;
        }
        if (color.equals(COLOR_RED)) {
            return 0xFF0000;
        }
        if (color.equals(COLOR_SILVER)) {
            return 0xC0C0C0;
        }
        if (color.equals(COLOR_TEAL)) {
            return 32896;
        }
        if (color.equals(COLOR_YELLOW)) {
            return 0xFFFF00;
        }
        if (color.equals(TRANSPARENT)) {
            return -1;
        }
        return 0;
    }

    @Override
    public int parseColor(String[] rgbComponents) {
        try {
            StringBuffer hexStr = new StringBuffer(6);
            String tempStr = CMStringHelper.formatHexComponent(Integer.parseInt(rgbComponents[0]));
            hexStr.append(tempStr);
            tempStr = CMStringHelper.formatHexComponent(Integer.parseInt(rgbComponents[1]));
            hexStr.append(tempStr);
            tempStr = CMStringHelper.formatHexComponent(Integer.parseInt(rgbComponents[2]));
            hexStr.append(tempStr);
            return Integer.parseInt(hexStr.toString(), 16);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int parseColor(String redComponent, String greenComponent, String blueComponent) {
        try {
            StringBuffer hexStr = new StringBuffer(redComponent.length() + greenComponent.length() + blueComponent.length());
            hexStr.append(Integer.valueOf(redComponent, 16).toString());
            hexStr.append(Integer.valueOf(greenComponent, 16).toString());
            hexStr.append(Integer.valueOf(blueComponent, 16).toString());
            return Integer.parseInt(hexStr.toString(), 16);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public boolean parseWeight(String weight) {
        return weight.equals("bold") || weight.equals("bolder") || weight.equals("700") || weight.equals("800") || weight.equals("900");
    }

    @Override
    public int parseSize(String size) {
        if (size.indexOf("p") > 0) {
            size = size.substring(0, size.indexOf("p"));
            return Integer.parseInt(size);
        }
        if (size.indexOf(".") > 0) {
            size = size.substring(0, size.indexOf("."));
            return Integer.parseInt(size);
        }
        if (size.equals("xx-small")) {
            return 6;
        }
        if (size.equals("x-small")) {
            return 8;
        }
        if (size.equals("small")) {
            return 10;
        }
        if (size.equals("medium")) {
            return 12;
        }
        if (size.equals("large")) {
            return 14;
        }
        if (size.equals("x-large")) {
            return 16;
        }
        if (size.equals("xx-large")) {
            return 18;
        }
        return 12;
    }

    @Override
    public int parsePatternColor(String pattern) {
        int iSpace = pattern.indexOf(" ");
        pattern = pattern.substring(0, iSpace);
        return this.parseColor(pattern);
    }

    @Override
    public String parsePatternStyle(String pattern) {
        int iSpace = pattern.indexOf(" ");
        pattern = pattern.substring(iSpace + 1, pattern.length());
        return pattern.trim();
    }

    @Override
    public int parseTextAlign(String textAlign) {
        if (textAlign.equals("left")) {
            return 0;
        }
        if (textAlign.equals("right")) {
            return 1;
        }
        if (textAlign.equals("center")) {
            return 2;
        }
        if (textAlign.equals("justify")) {
            VM.log(CLASS, 2, "replacing text-align:justify with center");
            return 2;
        }
        VM.log(CLASS, 2, "unknown text-align: " + textAlign);
        return 0;
    }

    private void updateStylesCommon(Document page, IElement element, String CSS) {
        int iCurPos = 0;
        if (!this.containsCCSstyles(CSS)) {
            return;
        }
        while (iCurPos < CSS.length()) {
            int internalPos;
            int iEndStruct;
            IStyle eStyle;
            if (element != null) {
                eStyle = element.getUnnamedStyle(true);
                if (eStyle == null) {
                    eStyle = new HtmlStyle();
                }
                iEndStruct = CSS.length() - 1;
                internalPos = 0;
            } else {
                String name = null;
                int iBeginStruct = CSS.indexOf(OPENB, iCurPos);
                if (-1 == iBeginStruct) break;
                name = CSS.substring(iCurPos, iBeginStruct);
                int lastTabPos = (name = name.trim()).lastIndexOf("&#9;");
                if (lastTabPos > -1) {
                    name = name.substring(lastTabPos + 4);
                }
                if (name.charAt(0) == '.') {
                    name = name.substring(1, name.length());
                }
                eStyle = page.findNamedStyle(name, true);
                iEndStruct = CSS.indexOf(CLOSEB, iBeginStruct);
                internalPos = iBeginStruct;
            }
            while (internalPos < iEndStruct) {
                int nextSep = CSS.indexOf(SEP, internalPos + 1);
                int nextEq = CSS.indexOf(EQ, internalPos);
                int endPos = nextEq;
                if (endPos < 0 || endPos > iEndStruct) break;
                if (nextSep >= 0 && nextSep < nextEq) {
                    internalPos = nextSep;
                    continue;
                }
                if (internalPos != 0) {
                    ++internalPos;
                }
                String propName = CSS.substring(internalPos, endPos);
                propName = propName.trim();
                internalPos = endPos;
                endPos = nextSep;
                if (endPos < 0) {
                    endPos = CSS.length();
                }
                String value = CSS.substring(internalPos + 1, endPos);
                value = value.trim();
                if (propName.equals("font-weight")) {
                    eStyle.setBold(this.parseWeight(value));
                } else if (propName.equals("font-size")) {
                    eStyle.setFontSize(this.parseSize(value));
                } else if (propName.equals("font-family")) {
                    eStyle.setFontFamily(value);
                } else if (propName.equals("mso-font-charset")) {
                    eStyle.setCharSet(value);
                } else if (propName.equals("font-style")) {
                    if (value.equals("italic")) {
                        eStyle.setItalics(true);
                    } else {
                        eStyle.setItalics(false);
                    }
                } else if (propName.equals("text-decoration")) {
                    if (value.indexOf("underline") >= 0) {
                        eStyle.setUnderline(true);
                    } else {
                        eStyle.setUnderline(false);
                    }
                    if (value.indexOf("line-through") >= 0) {
                        eStyle.setStrikeThru(true);
                    } else {
                        eStyle.setStrikeThru(false);
                    }
                } else if (propName.equals("color")) {
                    eStyle.setFontColor(this.parseColor(value));
                } else if (propName.equals("white-space")) {
                    if (value.equals("nowrap")) {
                        eStyle.setTextWrap(false);
                    } else {
                        eStyle.setTextWrap(true);
                    }
                } else if (propName.equals("background-color") || propName.equals("background")) {
                    eStyle.setBackgroundColor(this.parseColor(value));
                } else if (propName.equals("mso-pattern")) {
                    eStyle.setForegroundColor(this.parsePatternColor(value));
                    eStyle.setPattern(this.parsePatternStyle(value));
                } else if (propName.equals("text-align")) {
                    eStyle.setTextAlign(this.parseTextAlign(value));
                }
                internalPos = endPos;
            }
            iCurPos = iEndStruct + 1;
        }
    }
}

