/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.html;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.html.HtmlElement;
import com.cognos.mobile.xml.XMLHelper;
import java.io.PrintStream;

public class HtmlTextFrameElement
extends HtmlElement {
    private String m_value;

    public HtmlTextFrameElement(Document page, IElement parent) {
        super(page, 11, parent);
    }

    public HtmlTextFrameElement(HtmlTextFrameElement other) {
        super(other);
        this.m_value = other.m_value;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        this.generateStyles(generator, out);
        if (this.m_value != null) {
            String drillUrl;
            try {
                drillUrl = this.generateDrillThroughSpanOpen();
            }
            catch (CMException e) {
                drillUrl = null;
            }
            if (drillUrl != null) {
                out.print(drillUrl);
            }
            out.print(this.generateTagOpen("<span", ">"));
            out.print(this.prepTextValue(this.m_value));
            out.print("</span>");
            if (drillUrl != null) {
                out.print("</span>");
            }
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("textFrame '" + this.m_value + "'");
    }

    @Override
    public void setValue(String value) {
        this.m_value = value;
    }

    public String getValue() {
        return this.m_value;
    }

    private String prepTextValue(String value) {
        return value == null ? "" : CMStringHelper.replaceAll(XMLHelper.encodeXml(value), "\n", "<br />", true);
    }
}

