/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.vm.VmElement;
import com.cognos.mobile.generator.output.vm.VmMapElement;
import com.cognos.mobile.vm.VM;
import java.io.PrintStream;

public class VmChartElement
extends VmElement {
    private static Class CLASS = VmChartElement.class;
    private String m_imageUrl;
    private String m_imageMap;
    private int m_imageWidth;
    private int m_imageHeight;

    public VmChartElement(Document page, IElement parent) {
        super(page, 3, parent);
    }

    public VmChartElement(VmChartElement other) {
        super(other);
        this.m_imageUrl = other.m_imageUrl;
        this.m_imageMap = other.m_imageMap;
        this.m_imageWidth = other.m_imageWidth;
        this.m_imageHeight = other.m_imageHeight;
    }

    @Override
    public void setUrl(String url) {
        this.m_imageUrl = url;
    }

    @Override
    public void setWidth(int width) {
        this.m_imageWidth = width;
    }

    @Override
    public void setHeight(int height) {
        this.m_imageHeight = height;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        if (this.m_imageUrl != null) {
            out.println("\tChartBegin");
            this.m_imageUrl = this.handleUrl(this.m_imageUrl);
            out.println("\tImage " + this.m_imageUrl);
            IElement[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                IElement child = children[i];
                if (child instanceof VmMapElement) {
                    VmMapElement mapElement;
                    try {
                        mapElement = (VmMapElement)children[0];
                    }
                    catch (ClassCastException ex) {
                        mapElement = null;
                    }
                    if (mapElement == null) {
                        VM.log(CLASS, 2, "image map not found: " + this.m_imageMap);
                        continue;
                    }
                    if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
                        VM.log(CLASS, 2, "image map missing image width/height: " + this.m_imageMap);
                        continue;
                    }
                    mapElement.generateProgram(generator, out, this.m_imageWidth, this.m_imageHeight);
                    continue;
                }
                child.generateProgram(generator, out);
            }
            out.println("\tChartEnd");
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("chart: imageUrl=" + this.m_imageUrl + ", imageMap=" + this.m_imageMap);
    }
}

