/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.drill.DrillTargetParam;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.vm.VmElement;
import java.io.PrintStream;

public class VmDrillElement
extends VmElement {
    private DrillTargetInfo m_drillInfo;

    public VmDrillElement(Document page, IElement parent) {
        super(page, 13, parent);
    }

    public VmDrillElement(Document page) {
        super(page, 13);
        this.m_drillInfo = null;
    }

    @Override
    public void addDrillInfo(DrillTargetInfo drillInfo) {
        this.m_drillInfo = drillInfo;
    }

    public VmDrillElement(VmDrillElement other) {
        super(other);
        this.m_drillInfo = other.m_drillInfo;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        int i;
        if (this.m_drillInfo == null) {
            return;
        }
        out.println("\nDrillTargetInfoBegin");
        out.println("\tDrillWidget " + this.m_drillInfo.getWidgetID());
        out.println("\tDrillCMPath " + CMStringHelper.quoteStringLiteral(this.m_drillInfo.getCMPath()));
        out.println("\tDrillLabel " + CMStringHelper.quoteStringLiteral(this.m_drillInfo.getLabel()));
        for (i = 0; i < this.m_drillInfo.getParams().size(); ++i) {
            DrillTargetParam nameType = (DrillTargetParam)this.m_drillInfo.getParams().elementAt(i);
            String name = CMStringHelper.quoteStringLiteral(nameType.getName());
            String type = CMStringHelper.quoteStringLiteral(nameType.getType());
            out.println("\tDrillParamNameType " + name + " " + type);
        }
        for (i = 0; i < this.m_drillInfo.getSearchPathObjects().size(); ++i) {
            String searchPath = (String)this.m_drillInfo.getSearchPathObjects().elementAt(i);
            searchPath = CMStringHelper.quoteStringLiteral(searchPath);
            out.println("\tDrillSearchObject " + searchPath);
        }
        out.println("DrillTargetInfoEnd");
    }
}

