/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.drill.DrillContext;
import com.cognos.mobile.drill.DrillContextParam;
import com.cognos.mobile.drill.DrillTargetInfo;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.Element;
import com.cognos.mobile.generator.IDrillUpDownContext;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.vm.VmStyle;
import com.cognos.mobile.vm.VM;
import java.io.PrintStream;
import java.util.Vector;

public class VmElement
extends Element
implements IElement {
    private static Class CLASS = VmElement.class;

    public VmElement(Document page, int elementType) {
        super(page, elementType);
    }

    public VmElement(Document page, int elementType, IElement parent) {
        super(page, elementType);
        this.m_parent = parent;
    }

    public VmElement(VmElement other) {
        super(other);
    }

    @Override
    public IElement[] getChildren() {
        return this.m_children.toArray(new VmElement[0]);
    }

    @Override
    public void debugDumpTree(int level, PrintStream out) {
        int i;
        for (i = 0; i < level; ++i) {
            out.print(".");
        }
        this.debugDumpObject(out);
        for (i = 0; i < this.m_children.size(); ++i) {
            VmElement child = (VmElement)this.m_children.elementAt(i);
            child.debugDumpTree(level + 1, out);
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        switch (this.m_elementType) {
            case 7: {
                out.print("page");
                break;
            }
            case 3: {
                out.print("chart");
                break;
            }
            case 8: {
                out.print("prompt");
                break;
            }
            case 10: {
                out.print("table");
                break;
            }
            case 11: {
                out.print("textFrame");
                break;
            }
            case 5: {
                out.print("header");
                break;
            }
            case 1: {
                out.print("body");
                break;
            }
            case 4: {
                out.print("footer");
                break;
            }
            case 6: {
                out.print("image");
                break;
            }
            case 9: {
                out.print("row");
                break;
            }
            case 2: {
                out.print("cell");
                break;
            }
            case 12: {
                out.print("map");
                break;
            }
            default: {
                out.print("unknown-" + this.m_elementType);
            }
        }
        if (this.getID() != null) {
            out.print(" id=" + this.getID());
        }
        if (this.m_name != null) {
            out.print(" name=" + this.m_name);
        }
        if (this.m_type != null) {
            out.print(" type=" + this.m_type);
        }
        out.println();
    }

    @Override
    protected IElement[] getChildrenOfElementType(int elementType) {
        Vector<VmElement> results = new Vector<VmElement>();
        for (int i = 0; i < this.m_children.size(); ++i) {
            VmElement child = (VmElement)this.m_children.elementAt(i);
            if (child.getElementType() != elementType) continue;
            results.addElement(child);
        }
        if (results.size() == 0) {
            return new VmElement[0];
        }
        return results.toArray(new VmElement[0]);
    }

    @Override
    protected void generateProgram(IElement[] elements, IGenerator generator, PrintStream out) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i].generateProgram(generator, out);
        }
    }

    @Override
    protected void generateDrillThrough(IGenerator generator, PrintStream out) {
        this.generateDrillThrough(out, this.drillContexts);
    }

    protected void generateDrillUpDown(IGenerator generator, PrintStream out) {
        this.generateDrillUpDown(out, this.drillUpDownCtx);
    }

    protected void generateDrillUpDown(PrintStream out, IDrillUpDownContext updnCtx) {
        if (updnCtx == null) {
            return;
        }
        if (!updnCtx.getCanDrillDown() && !updnCtx.getCanDrillUp()) {
            return;
        }
        if (updnCtx.getCanDrillUp()) {
            out.println("\tSetStyle DRILLUP");
        }
        if (updnCtx.getCanDrillDown()) {
            out.println("\tSetStyle DRILLDOWN");
        }
        out.println("\tDrillUpDownContext " + CMStringHelper.quoteStringLiteral(updnCtx.getDrillUpDownContext()));
        if (updnCtx.getDrillUpDownWidget() != -1) {
            out.println("\tDrillWidget " + updnCtx.getDrillUpDownWidget());
        }
    }

    @Override
    protected void generateDrillThrough(PrintStream out, Vector drillContexts) {
        if (!this.validateDrillthrough(drillContexts)) {
            return;
        }
        if (this.validDrillTargets() == 0) {
            return;
        }
        out.println("\tSetStyle DRILLTHROUGH");
        for (int count = 0; count < drillContexts.size(); ++count) {
            DrillContext drillContext = (DrillContext)drillContexts.elementAt(count);
            out.println("\tDrillContextBegin");
            out.println("\tDrillIndex " + drillContext.getDrillIndex());
            out.println("\tDrillWidget " + drillContext.getWidgetID());
            for (int i = 0; i < drillContext.getParameters().size(); ++i) {
                DrillContextParam currentParam = (DrillContextParam)drillContext.getParameters().elementAt(i);
                String name = CMStringHelper.quoteStringLiteral(currentParam.getName());
                String value = CMStringHelper.quoteStringLiteral(currentParam.getValue());
                out.println("\tDrillParameter " + name + " " + value);
                if (currentParam.getMun() == null || currentParam.getMun().length() == 0) continue;
                String mun = CMStringHelper.quoteStringLiteral(currentParam.getMun());
                out.println("\tDrillParameterMun " + mun);
            }
            out.println("\tDrillContextEnd");
        }
    }

    @Override
    public void generateStyles(IGenerator generator, PrintStream out) {
        block4: for (int i = 0; i < this.styles.size(); ++i) {
            String styleName = this.document.getMappedStyleName((String)this.styles.elementAt(i));
            switch (generator.getPass()) {
                case 0: {
                    generator.markStyleAsUsed(styleName);
                    continue block4;
                }
                case 1: {
                    VmStyle style = (VmStyle)this.document.findNamedStyle(styleName, false);
                    if (style == null) {
                        VM.log(CLASS, 0, "ignoring unknown style: " + styleName);
                        continue block4;
                    }
                    if (style.isDeleted()) {
                        VM.log(CLASS, 0, "removing unnecessary style: " + styleName);
                        continue block4;
                    }
                    int pageIndex = this.document.getPageIndex();
                    out.println("\tCall " + style.getSubroutineName(pageIndex));
                }
            }
        }
        if (this.unnamedStyle != null) {
            this.unnamedStyle.generateProgram(-1, out);
        }
    }

    public void removeChild(VmElement child) {
        this.m_children.removeElement(child);
    }

    public boolean showsBorder(int border) {
        boolean showsBorder = false;
        for (int i = 0; i < this.styles.size(); ++i) {
            String styleName = (String)this.styles.elementAt(i);
            VmStyle style = (VmStyle)this.document.findNamedStyle(styleName, false);
            if (style == null || style.isDeleted()) continue;
            if (style.getBorderDisplay(border) == 2) {
                showsBorder = false;
            }
            if (style.getBorderDisplay(border) != 1) continue;
            showsBorder = true;
        }
        if (this.unnamedStyle != null) {
            if (this.unnamedStyle.getBorderDisplay(border) == 2) {
                showsBorder = false;
            }
            if (this.unnamedStyle.getBorderDisplay(border) == 1) {
                showsBorder = true;
            }
        }
        return showsBorder;
    }

    @Override
    public void setValue(String textNode) {
    }

    @Override
    public void setUrl(String textNode) {
    }

    @Override
    public Vector getAreas() {
        return null;
    }

    @Override
    public void setHeight(int height) {
    }

    @Override
    public void setWidth(int width) {
    }

    @Override
    public void addDrillInfo(DrillTargetInfo drillInfo) {
    }

    @Override
    public void setIsTitle(boolean isTitle) {
    }
}

