/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IElementFactory;
import com.cognos.mobile.generator.IStyle;
import com.cognos.mobile.generator.IStyleParser;
import com.cognos.mobile.generator.output.vm.VmBlockElement;
import com.cognos.mobile.generator.output.vm.VmBodyElement;
import com.cognos.mobile.generator.output.vm.VmCellElement;
import com.cognos.mobile.generator.output.vm.VmChartElement;
import com.cognos.mobile.generator.output.vm.VmDrillElement;
import com.cognos.mobile.generator.output.vm.VmElement;
import com.cognos.mobile.generator.output.vm.VmFooterElement;
import com.cognos.mobile.generator.output.vm.VmHLinkElement;
import com.cognos.mobile.generator.output.vm.VmHeaderElement;
import com.cognos.mobile.generator.output.vm.VmHtmlElement;
import com.cognos.mobile.generator.output.vm.VmImageElement;
import com.cognos.mobile.generator.output.vm.VmMapElement;
import com.cognos.mobile.generator.output.vm.VmPageElement;
import com.cognos.mobile.generator.output.vm.VmPromptElement;
import com.cognos.mobile.generator.output.vm.VmRowElement;
import com.cognos.mobile.generator.output.vm.VmStyle;
import com.cognos.mobile.generator.output.vm.VmStyleParser;
import com.cognos.mobile.generator.output.vm.VmTableElement;
import com.cognos.mobile.generator.output.vm.VmTextFrameElement;
import com.cognos.mobile.prompts.PButton;
import java.util.Vector;

public class VmElementFactory
implements IElementFactory {
    private final Document document;

    public VmElementFactory(Document document) {
        this.document = document;
    }

    @Override
    public IElement create(int elementType, IElement parent) {
        switch (elementType) {
            case 1: {
                return new VmBodyElement(this.document, parent);
            }
            case 2: {
                return new VmCellElement(this.document, parent);
            }
            case 3: {
                return new VmChartElement(this.document, parent);
            }
            case 4: {
                return new VmFooterElement(this.document, parent);
            }
            case 5: {
                return new VmHeaderElement(this.document, parent);
            }
            case 6: {
                return new VmImageElement(this.document, parent);
            }
            case 8: {
                break;
            }
            case 9: {
                return new VmRowElement(this.document, parent);
            }
            case 10: {
                return new VmTableElement(this.document, parent);
            }
            case 11: {
                return new VmTextFrameElement(this.document, parent);
            }
            case 12: {
                return new VmMapElement(this.document, parent);
            }
            case 13: {
                return new VmDrillElement(this.document, parent);
            }
            case 14: {
                return new VmPageElement(this.document, parent);
            }
            case 15: {
                return new VmBlockElement(this.document, parent);
            }
            case 16: {
                return new VmHtmlElement(this.document, parent);
            }
            case 17: {
                return new VmPromptElement(this.document, parent, new PButton());
            }
            case 27: {
                return new VmHLinkElement(this.document, parent);
            }
            default: {
                return new VmElement(this.document, elementType, parent);
            }
        }
        return null;
    }

    @Override
    public IStyle createStyle() {
        return new VmStyle();
    }

    @Override
    public IStyle getStyle(Object style) {
        return (VmStyle)style;
    }

    @Override
    public IStyle[] getStyles(Vector styles) {
        return styles.toArray(new VmStyle[0]);
    }

    @Override
    public IStyleParser getStyleParser() {
        return VmStyleParser.instance();
    }

    @Override
    public IElement getTextFrameElement(IElement element) {
        return (VmTextFrameElement)element;
    }

    @Override
    public IElement getHtmlElement(IElement element) {
        return (VmHtmlElement)element;
    }

    public IElement getChartElement(IElement element) {
        return (VmChartElement)element;
    }
}

