/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMStringHelper2;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.Generator;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.generator.output.vm.VmStyle;
import com.cognos.mobile.vm.IVMWriter;
import com.cognos.mobile.vm.VM;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;

public class VmGenerator
extends Generator {
    private static final Class CLASS = VmGenerator.class;

    public VmGenerator(IVMWriter writer) {
        super(null, writer);
        this.setPass(0);
        this.setCurrentDocument(null);
    }

    @Override
    public void generate(Document doc, PrintStream out) throws CMException {
        this.generate(doc, out, -1);
    }

    @Override
    public void generate(Document doc, PrintStream out, int pageIndex) throws CMException {
        IReport report = doc.getReport();
        PrintStream nullStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        this.generateHeader(report, pageIndex, out);
        this.setCurrentDocument(doc);
        this.setPass(0);
        if (pageIndex >= 0) {
            if (report.getPage(doc, pageIndex) == null) {
                VM.log(CLASS, 2, "skipping page " + pageIndex + " because it did not contain any data");
            } else {
                this.setCurrentPage(report.getPage(doc, pageIndex));
                this.getCurrentPage().generateProgram(this, nullStream);
            }
        } else if (report.getPage(doc, 0) != null) {
            this.setCurrentPage(report.getPage(doc, 0));
            this.getCurrentPage().generateProgram(this, nullStream);
        }
        this.generateStylesSubroutines(out);
        this.setPass(1);
        if (pageIndex >= 0) {
            if (report.getPage(doc, pageIndex) == null) {
                VM.log(CLASS, 2, "skipping page " + pageIndex + " because it did not contain any data");
            } else {
                out.println();
                out.println("PageBegin " + Integer.toString(pageIndex));
                this.setCurrentPage(report.getPage(doc, pageIndex));
                this.getCurrentDocument().generateDrills(this, out);
                this.getCurrentPage().generateProgram(this, out);
            }
        } else if (report.getPage(doc, 0) != null) {
            out.println();
            out.println("PageBegin " + Integer.toString(0));
            this.setCurrentPage(report.getPage(doc, 0));
            this.getCurrentDocument().generateDrills(this, out);
            this.getCurrentPage().generateProgram(this, out);
        }
        out.println("End");
    }

    @Override
    public void markStyleAsUsed(String styleName) {
        if (this.getPass() != 0) {
            return;
        }
        if (this.getCurrentDocument() == null) {
            return;
        }
        VmStyle style = (VmStyle)this.getCurrentDocument().findNamedStyle(styleName, false);
        if (style != null) {
            style.markAsUsed();
        }
    }

    @Override
    public void generateHeader(IReport report, int page, PrintStream out) {
        String timestampString = CMStringHelper2.formatDateTime(Calendar.getInstance());
        String versionString = Integer.toString(11) + "." + Integer.toString(2) + "2." + "2." + " build " + Integer.toString(7);
        out.println(";");
        out.println("; " + report.getLabel());
        out.println(";");
        out.println("; " + report.getSourcePath());
        out.println("; " + report.getGatewayUrl());
        out.println("; " + report.getCmPath());
        out.println(";");
        out.println("; generated by mobgen " + versionString);
        out.println("; " + timestampString);
        out.println(";");
        out.println();
        out.println("\t.Version " + Integer.toString(0));
        out.println("\t.Title " + CMStringHelper.quoteStringLiteral(report.getLabel()));
        out.println("\t.Timestamp " + CMStringHelper.quoteStringLiteral(timestampString));
        out.println("\t.GatewayUrl " + CMStringHelper.quoteStringLiteral(report.getGatewayUrl()));
        out.println("\t.CMPath " + CMStringHelper.quoteStringLiteral(report.getCmPath()));
        out.println("\t.SourcePath " + CMStringHelper.quoteStringLiteral(report.getSourcePath()));
        out.println("\t.DRILLSTR " + CMStringHelper.quoteStringLiteral(report.getDrillParams()));
        if (report.getBurstValue() != null) {
            out.println("\t.BURSTVALUE " + CMStringHelper.quoteStringLiteral(report.getBurstValue()));
        }
        out.println("\t.StoreID " + CMStringHelper.quoteStringLiteral(report.getStoreID()));
        out.println("\t.SourceCode " + report.getSourceCode());
        out.println("\t.PageCount " + report.getPageCount());
        out.println("\t.ThumbnailSmall -1");
        out.println("\t.Dashboard -1");
        out.println("\t.Description " + CMStringHelper.quoteStringLiteral(report.getDescription()));
    }

    @Override
    public void generateFooter(PrintStream out) {
    }
}

