/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.vm.VmElement;
import com.cognos.mobile.html.HTMailInfo;
import com.cognos.mobile.html.HTMailtoHandler;
import java.io.PrintStream;
import java.util.Vector;

public class VmHLinkElement
extends VmElement {
    private String target;

    public VmHLinkElement(Document page, IElement parent) {
        super(page, 27, parent);
    }

    public VmHLinkElement(VmHLinkElement other) {
        super(other);
        this.target = other.target;
    }

    @Override
    public void setUrl(String target) {
        this.target = target;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        if (this.target != null) {
            HTMailtoHandler handler = new HTMailtoHandler();
            try {
                handler.doParse(this.target.trim());
            }
            catch (Exception e) {
                return;
            }
            Vector mailtos = handler.getMailtoElements();
            if (mailtos != null && mailtos.size() != 0) {
                out.println("\tSetStyle MAILTO");
                for (int i = 0; i < mailtos.size(); ++i) {
                    HTMailInfo mailinfo = (HTMailInfo)mailtos.get(i);
                    out.println("\tMailToBegin");
                    if (mailinfo.getMailTo() != null) {
                        out.println("\tMailTo " + CMStringHelper.quoteStringLiteral(mailinfo.getMailTo()));
                    }
                    if (mailinfo.getCcTo() != null) {
                        out.println("\tMailToCC " + CMStringHelper.quoteStringLiteral(mailinfo.getCcTo()));
                    }
                    if (mailinfo.getBccTo() != null) {
                        out.println("\tMailToBCC " + CMStringHelper.quoteStringLiteral(mailinfo.getBccTo()));
                    }
                    if (mailinfo.getBody() != null || mailinfo.getSubject() != null) {
                        String body = mailinfo.getBody() != null ? mailinfo.getBody() : "";
                        String subject = mailinfo.getSubject() != null ? mailinfo.getSubject() : "";
                        out.println("\tMailToSubBody " + CMStringHelper.quoteStringLiteral(subject) + " " + CMStringHelper.quoteStringLiteral(body));
                    }
                    out.println("\tMailToEnd");
                    if (mailinfo.getLabel() == null) continue;
                    out.println("\tText " + CMStringHelper.quoteStringLiteral(mailinfo.getLabel()));
                }
            }
        }
        super.generateProgram(generator, out);
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("target '" + this.target + "'");
    }
}

