/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.vm.VmTextFrameElement;
import com.cognos.mobile.html.HTMailInfo;
import com.cognos.mobile.html.HTMailtoHandler;
import com.cognos.mobile.tagsoup.Parser;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.util.Vector;

public class VmHtmlElement
extends VmTextFrameElement {
    private String m_value;

    public VmHtmlElement(Document page, IElement parent) {
        super(page, parent);
    }

    public VmHtmlElement(VmHtmlElement other) {
        super(other);
        this.m_value = other.m_value;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        this.generateDrillThrough(generator, out);
        this.generateStyles(generator, out);
        if (this.m_value != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.m_value.trim().getBytes());
            HTMailtoHandler handler = new HTMailtoHandler();
            try {
                Parser parser = new Parser();
                handler.doParse(parser, inputStream);
            }
            catch (Exception e) {
                return;
            }
            Vector mailtos = handler.getMailtoElements();
            if (mailtos != null && mailtos.size() != 0) {
                out.println("\tSetStyle MAILTO");
                for (int i = 0; i < mailtos.size(); ++i) {
                    HTMailInfo mailinfo = (HTMailInfo)mailtos.get(i);
                    out.println("\tMailToBegin");
                    if (mailinfo.getMailTo() != null) {
                        out.println("\tMailTo " + CMStringHelper.quoteStringLiteral(mailinfo.getMailTo()));
                    }
                    if (mailinfo.getCcTo() != null) {
                        out.println("\tMailToCC " + CMStringHelper.quoteStringLiteral(mailinfo.getCcTo()));
                    }
                    if (mailinfo.getBccTo() != null) {
                        out.println("\tMailToBCC " + CMStringHelper.quoteStringLiteral(mailinfo.getBccTo()));
                    }
                    if (mailinfo.getBody() != null || mailinfo.getSubject() != null) {
                        String body = mailinfo.getBody() != null ? mailinfo.getBody() : "";
                        String subject = mailinfo.getSubject() != null ? mailinfo.getSubject() : "";
                        out.println("\tMailToSubBody " + CMStringHelper.quoteStringLiteral(subject) + " " + CMStringHelper.quoteStringLiteral(body));
                    }
                    out.println("\tMailToEnd");
                    if (mailinfo.getLabel() == null) continue;
                    out.println("\tText " + CMStringHelper.quoteStringLiteral(mailinfo.getLabel()));
                }
            }
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("html '" + this.m_value + "'");
    }

    @Override
    public void setValue(String value) {
        this.m_value = value;
    }

    @Override
    public String getValue() {
        return this.m_value;
    }
}

