/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMAreaAndCentroid;
import com.cognos.mobile.common.CMFixedHelper;
import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.common.CMMathHelper2;
import com.cognos.mobile.common.CMPoint;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Area;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IDrillUpDownContext;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.vm.VmElement;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Vector;

public class VmMapElement
extends VmElement {
    public static final int DIR_LEFT = 0;
    public static final int DIR_UP = 1;
    public static final int DIR_RIGHT = 2;
    public static final int DIR_DOWN = 3;
    private static final double SEARCH_WIDTH_MULTIPLIER = 0.85;
    private Vector m_areas;
    private Spot[] m_spots;

    public VmMapElement(Document page, IElement parent) {
        super(page, 12, parent);
        this.m_areas = new Vector();
    }

    public VmMapElement(VmMapElement other) {
        super(other);
        this.m_areas = other.m_areas;
        this.m_spots = other.m_spots;
    }

    public void generateProgram(IGenerator generator, PrintStream out, int imageWidth, int imageHeight) {
        int i;
        if (this.m_spots == null) {
            this.m_spots = this.computeSpotsFromAreas(imageWidth, imageHeight);
        }
        int leftEdge = Integer.MAX_VALUE;
        int topEdge = Integer.MAX_VALUE;
        int rightEdge = 0;
        int bottomEdge = 0;
        for (i = 0; i < this.m_spots.length; ++i) {
            if (this.m_spots[i] == null) continue;
            leftEdge = Math.min(leftEdge, this.m_spots[i].fixedCentroidX);
            topEdge = Math.min(topEdge, this.m_spots[i].fixedCentroidY);
            rightEdge = Math.max(leftEdge, this.m_spots[i].fixedCentroidX);
            bottomEdge = Math.max(bottomEdge, this.m_spots[i].fixedCentroidY);
        }
        out.println("\t; image map '" + this.getID() + "'");
        for (i = 0; i < this.m_spots.length; ++i) {
            if (this.m_spots[i] == null) continue;
            this.m_spots[i].leftSpot = VmMapElement.findDirectionalSpot(0, leftEdge, topEdge, rightEdge, bottomEdge, this.m_spots, this.m_spots[i]);
            this.m_spots[i].upSpot = VmMapElement.findDirectionalSpot(1, leftEdge, topEdge, rightEdge, bottomEdge, this.m_spots, this.m_spots[i]);
            this.m_spots[i].rightSpot = VmMapElement.findDirectionalSpot(2, leftEdge, topEdge, rightEdge, bottomEdge, this.m_spots, this.m_spots[i]);
            this.m_spots[i].downSpot = VmMapElement.findDirectionalSpot(3, leftEdge, topEdge, rightEdge, bottomEdge, this.m_spots, this.m_spots[i]);
            out.println("\tSpotBegin " + CMStringHelper.formatHexLiteral(this.m_spots[i].fixedCentroidX) + " " + CMStringHelper.formatHexLiteral(this.m_spots[i].fixedCentroidY));
            out.println("\tSpotIndex " + this.m_spots[i].index);
            if (this.m_spots[i].leftSpot != -1) {
                out.println("\tSpotLeft " + this.m_spots[i].leftSpot);
            }
            if (this.m_spots[i].upSpot != -1) {
                out.println("\tSpotUp " + this.m_spots[i].upSpot);
            }
            if (this.m_spots[i].rightSpot != -1) {
                out.println("\tSpotRight " + this.m_spots[i].rightSpot);
            }
            if (this.m_spots[i].downSpot != -1) {
                out.println("\tSpotDown " + this.m_spots[i].downSpot);
            }
            this.generateDrillThrough(out, this.m_spots[i].drillTargets);
            this.generateDrillUpDown(out, this.m_spots[i].drillUpDownCtx);
            out.println("\tLabel " + CMStringHelper.quoteStringLiteral(this.m_spots[i].label));
            out.println("\tSpotEnd");
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("map " + this.m_areas.size() + " area(s)");
    }

    private Spot[] computeSpotsFromAreas(int imageWidth, int imageHeight) {
        int i;
        Object[] areas = this.m_areas.toArray(new Area[0]);
        Arrays.sort(areas);
        for (i = 0; i < areas.length; ++i) {
            CMAreaAndCentroid res = CMMathHelper2.computeAreaAndCentroid(((Area)areas[i]).poly);
            ((Area)areas[i]).area = Math.abs(res.area);
            ((Area)areas[i]).centroidX = res.centroidX;
            ((Area)areas[i]).centroidY = res.centroidY;
        }
        for (i = 0; i < areas.length; ++i) {
            Area area = (Area)this.m_areas.elementAt(i);
            area.left = area.poly[0];
            area.top = area.poly[1];
            for (int j = 2; j < area.poly.length; j += 2) {
                area.left = Math.min(area.left, area.poly[j]);
                area.top = Math.min(area.top, area.poly[j + 1]);
            }
        }
        int spotCount = areas.length;
        for (i = 0; i < areas.length - 1; ++i) {
            Object a1 = areas[i];
            Object a2 = areas[i + 1];
            if (((Area)a1).label.trim().length() == 0 && ((Area)a2).label.trim().length() == 0 || !((Area)a1).label.equals(((Area)a2).label) || (((Area)a1).drillTargetFingerprint == 0 && ((Area)a2).drillTargetFingerprint == 0 ? ((Area)a1).type != ((Area)a2).type : ((Area)a1).drillTargetFingerprint != ((Area)a2).drillTargetFingerprint)) continue;
            double fraction = ((Area)a2).area / (((Area)a1).area + ((Area)a2).area);
            double newX = CMMathHelper.linearInterpolate(((Area)a1).centroidX, ((Area)a2).centroidX, fraction);
            double newY = CMMathHelper.linearInterpolate(((Area)a1).centroidY, ((Area)a2).centroidY, fraction);
            ((Area)a1).label = null;
            ((Area)a2).centroidX = newX;
            ((Area)a2).centroidY = newY;
            ((Area)a2).area += ((Area)a1).area;
            ((Area)a2).left = Math.min(((Area)a2).left, ((Area)a1).left);
            ((Area)a2).top = Math.min(((Area)a2).top, ((Area)a1).top);
            --spotCount;
        }
        Object[] spots = new Spot[spotCount];
        spotCount = 0;
        for (i = 0; i < areas.length; ++i) {
            if (((Area)areas[i]).label == null) continue;
            double normCentroidX = ((Area)areas[i]).centroidX / (double)imageWidth;
            double normCentroidY = ((Area)areas[i]).centroidY / (double)imageHeight;
            spots[spotCount] = new Spot();
            ((Spot)spots[spotCount]).index = i;
            ((Spot)spots[spotCount]).label = ((Area)areas[i]).label;
            ((Spot)spots[spotCount]).fixedCentroidX = CMFixedHelper.doubleToFixed(normCentroidX);
            ((Spot)spots[spotCount]).fixedCentroidY = CMFixedHelper.doubleToFixed(normCentroidY);
            ((Spot)spots[spotCount]).left = ((Area)areas[i]).left;
            ((Spot)spots[spotCount]).top = ((Area)areas[i]).top;
            ((Spot)spots[spotCount]).drillTargets = ((Area)areas[i]).drillTargets;
            ((Spot)spots[spotCount]).drillUpDownCtx = ((Area)areas[i]).drillCtx;
            ++spotCount;
        }
        if (spotCount != spots.length) {
            Spot[] temp = new Spot[spotCount];
            System.arraycopy(spots, 0, temp, 0, spotCount);
            spots = temp;
        }
        Arrays.sort(spots);
        Object prevSpot = null;
        for (int i2 = 0; i2 < spots.length; ++i2) {
            if (spots[i2] == null) continue;
            if (prevSpot != null && ((Spot)prevSpot).left == ((Spot)spots[i2]).left && ((Spot)prevSpot).top == ((Spot)spots[i2]).top) {
                if (((Spot)prevSpot).label != null && ((Spot)prevSpot).label.length() > 0 && ((Spot)spots[i2]).label != null && ((Spot)spots[i2]).label.length() > 0) {
                    ((Spot)prevSpot).label = ((Spot)prevSpot).label + " | ";
                }
                ((Spot)prevSpot).label = ((Spot)prevSpot).label + ((Spot)spots[i2]).label;
                if (((Spot)spots[i2]).drillTargets != null) {
                    if (((Spot)prevSpot).drillTargets != null) {
                        ((Spot)prevSpot).drillTargets.addAll(((Spot)spots[i2]).drillTargets);
                    } else {
                        ((Spot)prevSpot).drillTargets = ((Spot)spots[i2]).drillTargets;
                    }
                }
                ((Spot)prevSpot).drillUpDownCtx = ((Spot)spots[i2]).drillUpDownCtx;
                spots[i2] = null;
                continue;
            }
            prevSpot = spots[i2];
        }
        return spots;
    }

    private static int findDirectionalSpot(int dir, int leftEdge, int topEdge, int rightEdge, int bottomEdge, Spot[] spots, Spot currentSpot) {
        double distance;
        CMPoint regionA = new CMPoint(currentSpot.fixedCentroidX, currentSpot.fixedCentroidY);
        CMPoint regionB = new CMPoint();
        CMPoint regionC = new CMPoint();
        CMPoint testPoint = new CMPoint();
        double shortestDistance = -1.0;
        Spot closestSpot = null;
        switch (dir) {
            case 0: {
                regionB.x = leftEdge;
                regionB.y = (double)currentSpot.fixedCentroidY - (double)(currentSpot.fixedCentroidX - leftEdge) * 0.85;
                regionC.x = leftEdge;
                regionC.y = (double)currentSpot.fixedCentroidY + (double)(currentSpot.fixedCentroidX - leftEdge) * 0.85;
                break;
            }
            case 1: {
                regionB.x = (double)currentSpot.fixedCentroidX - (double)(currentSpot.fixedCentroidY - topEdge) * 0.85;
                regionB.y = topEdge;
                regionC.x = (double)currentSpot.fixedCentroidX + (double)(currentSpot.fixedCentroidY - topEdge) * 0.85;
                regionC.y = topEdge;
                break;
            }
            case 2: {
                regionB.x = rightEdge;
                regionB.y = (double)currentSpot.fixedCentroidY - (double)(rightEdge - currentSpot.fixedCentroidX) * 0.85;
                regionC.x = rightEdge;
                regionC.y = (double)currentSpot.fixedCentroidY + (double)(rightEdge - currentSpot.fixedCentroidX) * 0.85;
                break;
            }
            case 3: {
                regionB.x = (double)currentSpot.fixedCentroidX - (double)(bottomEdge - currentSpot.fixedCentroidY) * 0.85;
                regionB.y = bottomEdge;
                regionC.x = (double)currentSpot.fixedCentroidX + (double)(bottomEdge - currentSpot.fixedCentroidY) * 0.85;
                regionC.y = bottomEdge;
            }
        }
        for (int i = 0; i < spots.length; ++i) {
            Spot spot = spots[i];
            if (spot == null || spot.index == currentSpot.index) continue;
            testPoint.x = spot.fixedCentroidX;
            testPoint.y = spot.fixedCentroidY;
            if (!CMMathHelper.isPointInTriangle(regionA, regionB, regionC, testPoint)) continue;
            distance = CMMathHelper.distance(regionA, testPoint);
            if (!(shortestDistance < 0.0) && (!(shortestDistance >= 0.0) || !(distance < shortestDistance))) continue;
            shortestDistance = distance;
            closestSpot = spot;
        }
        if (closestSpot == null) {
            for (int i = 0; i < spots.length; ++i) {
                Spot spot = spots[i];
                if (spot == null || spot.index == currentSpot.index) continue;
                boolean isValid = false;
                testPoint.x = spot.fixedCentroidX;
                testPoint.y = spot.fixedCentroidY;
                switch (dir) {
                    case 0: {
                        if (!(testPoint.x < regionA.x)) break;
                        isValid = true;
                        break;
                    }
                    case 1: {
                        if (!(testPoint.y < regionA.y)) break;
                        isValid = true;
                        break;
                    }
                    case 2: {
                        if (!(testPoint.x > regionA.x)) break;
                        isValid = true;
                        break;
                    }
                    case 3: {
                        if (!(testPoint.y > regionA.y)) break;
                        isValid = true;
                    }
                }
                if (!isValid) continue;
                distance = CMMathHelper.distance(regionA, testPoint);
                if (!(shortestDistance < 0.0) && (!(shortestDistance >= 0.0) || !(distance < shortestDistance))) continue;
                shortestDistance = distance;
                closestSpot = spot;
            }
        }
        return closestSpot == null ? -1 : closestSpot.index;
    }

    @Override
    public Vector getAreas() {
        return this.m_areas;
    }

    private class Spot
    implements Comparable {
        public String label;
        public int fixedCentroidX;
        public int fixedCentroidY;
        public int left;
        public int top;
        public Vector drillTargets;
        public IDrillUpDownContext drillUpDownCtx;
        public int index;
        public int leftSpot = -1;
        public int upSpot = -1;
        public int rightSpot = -1;
        public int downSpot = -1;

        private Spot() {
        }

        public int compareTo(Object other) {
            if (other == null) {
                return -1;
            }
            Spot o = (Spot)other;
            if (this.left < o.left) {
                return -1;
            }
            if (this.left > o.left) {
                return 1;
            }
            if (this.top < o.top) {
                return -1;
            }
            if (this.top > o.top) {
                return 1;
            }
            return 0;
        }
    }
}

