/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMBitHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Style;
import com.cognos.mobile.vm.VM;
import java.io.PrintStream;

public class VmStyle
extends Style {
    private static Class CLASS = VmStyle.class;

    public VmStyle() {
    }

    public VmStyle(VmStyle other) {
        this.m_name = other.getName();
        this.m_isUsed = other.isUsed();
        this.m_isDeleted = other.isDeleted();
        this.m_backgroundColor = other.getBackgroundColor();
        this.m_fontColor = other.getFontColor();
        this.m_textAlign = other.getTextAlign();
        this.m_isBold = other.isBold();
        this.m_isItalics = other.isItalics();
        this.m_isUnderline = other.isUnderline();
        this.m_height = other.getHeight();
        this.m_width = other.getWidth();
        this.m_borderDisplay[0] = other.getBorderDisplay(0);
        this.m_borderDisplay[1] = other.getBorderDisplay(1);
        this.m_borderDisplay[2] = other.getBorderDisplay(2);
        this.m_borderDisplay[3] = other.getBorderDisplay(3);
        this.m_borderColor[0] = other.getBorderColor(0);
        this.m_borderColor[1] = other.getBorderColor(1);
        this.m_borderColor[2] = other.getBorderColor(2);
        this.m_borderColor[3] = other.getBorderColor(3);
    }

    @Override
    public boolean generateProgram(int pageIndex, PrintStream out) {
        String hex2;
        int borderDisplay;
        String hex;
        StringBuffer code = new StringBuffer();
        Integer intValue = this.m_backgroundColor;
        if (intValue != null) {
            hex = CMStringHelper.formatColor(intValue);
            code.append("\tBackColor " + hex + "\n");
        }
        if ((intValue = this.m_fontColor) != null) {
            hex = CMStringHelper.formatColor(intValue);
            code.append("\tTextColor " + hex + "\n");
        }
        int fontStyle = 0;
        Boolean boolValue = this.m_isBold;
        if (boolValue != null) {
            fontStyle |= 1;
        }
        if ((boolValue = this.m_isItalics) != null) {
            fontStyle |= 4;
        }
        if ((boolValue = this.m_isUnderline) != null) {
            fontStyle |= 2;
        }
        if (fontStyle != 0) {
            String fontExpr;
            switch (fontStyle) {
                case 1: {
                    fontExpr = "BOLD";
                    break;
                }
                case 4: {
                    fontExpr = "ITALIC";
                    break;
                }
                case 2: {
                    fontExpr = "UNDERLINE";
                    break;
                }
                case 5: {
                    fontExpr = "BOLD|ITALIC";
                    break;
                }
                case 3: {
                    fontExpr = "BOLD|UNDERLINE";
                    break;
                }
                case 6: {
                    fontExpr = "UNDERLINE|ITALIC";
                    break;
                }
                case 7: {
                    fontExpr = "BOLD|ITALIC|UNDERLINE";
                    break;
                }
                default: {
                    fontExpr = null;
                }
            }
            if (fontExpr != null) {
                code.append("\tFont " + fontExpr + "\n");
            }
        }
        if (this.m_textAlign != null) {
            switch (this.m_textAlign) {
                case 0: {
                    code.append("\tTextAlign LEFT\n");
                    break;
                }
                case 1: {
                    code.append("\tTextAlign RIGHT\n");
                    break;
                }
                case 2: {
                    code.append("\tTextAlign CENTER\n");
                }
            }
        }
        if ((borderDisplay = CMBitHelper.readInt(this.m_borderDisplay, 0)) > 0) {
            code.append("\tBorderDisplay " + Integer.toString(borderDisplay) + "\n");
        }
        if (this.m_borderColor[3] != null || this.m_borderColor[1] != null) {
            hex = this.m_borderColor[3] == null ? VM.UNSET_COLOR_RGB : CMStringHelper.formatColor(this.m_borderColor[3]);
            hex2 = this.m_borderColor[1] == null ? VM.UNSET_COLOR_RGB : CMStringHelper.formatColor(this.m_borderColor[1]);
            code.append("\tBorderHorizontalColour " + hex + " " + hex2 + "\n");
        }
        if (this.m_borderColor[0] != null || this.m_borderColor[2] != null) {
            hex = this.m_borderColor[0] == null ? VM.UNSET_COLOR_RGB : CMStringHelper.formatColor(this.m_borderColor[0]);
            hex2 = this.m_borderColor[2] == null ? VM.UNSET_COLOR_RGB : CMStringHelper.formatColor(this.m_borderColor[2]);
            code.append("\tBorderVerticalColor " + hex + " " + hex2 + "\n");
        }
        if (this.m_width != null && this.m_width.getValue() > 0.0 && this.m_width.getUnits() != null && !this.m_width.getUnits().equals("%")) {
            code.append("\tSize " + this.m_width.getValue() + "\n");
        }
        if (code.length() == 0) {
            VM.log(CLASS, 0, "style omitted: " + this.m_name);
            return false;
        }
        if (pageIndex != -1) {
            out.println();
            out.println(this.getSubroutineName(pageIndex) + ":");
            out.print(code.toString());
            out.println("\tReturn");
        } else {
            out.print(code.toString());
        }
        return true;
    }
}

