/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.IGenericElement;
import com.cognos.mobile.generator.output.vm.VmCellElement;
import com.cognos.mobile.generator.output.vm.VmElement;
import com.cognos.mobile.generator.output.vm.VmRowElement;
import com.cognos.mobile.generator.output.vm.VmStyle;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import java.io.PrintStream;
import java.util.Vector;

public class VmTableElement
extends VmElement {
    private static Class CLASS = VmTableElement.class;
    private boolean m_isLayout;
    private boolean m_isProcessed;

    public VmTableElement(Document document, IElement parent) {
        super(document, 10, parent);
        this.m_isLayout = false;
        this.m_isProcessed = false;
    }

    public VmTableElement(VmTableElement other) {
        super(other);
        this.m_isLayout = other.m_isLayout;
        this.m_isProcessed = other.m_isProcessed;
    }

    boolean isLayout() {
        return this.m_isLayout;
    }

    VmRowElement[] getRows() {
        VmRowElement[] rows;
        try {
            rows = this.m_children.toArray(new VmRowElement[0]);
        }
        catch (ArrayStoreException e) {
            for (int childIndex = 0; childIndex < this.m_children.size(); ++childIndex) {
                VmElement child = (VmElement)this.m_children.get(childIndex);
                if (child.getElementType() == 9) continue;
                this.m_children.removeElementAt(childIndex);
                childIndex = childIndex == 0 ? 0 : childIndex - 1;
            }
            try {
                rows = this.m_children.toArray(new VmRowElement[0]);
            }
            catch (Exception e2) {
                VM.log(CLASS, 2, "Encountered table without row contents", e);
                rows = null;
            }
        }
        return rows;
    }

    void emptyRows() {
        for (int i = 0; i < this.m_children.size(); ++i) {
            this.m_children.set(i, null);
        }
        this.m_children.clear();
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        String tableName = this.getName();
        if (tableName == null || tableName.length() == 0) {
            tableName = this.getID();
        }
        if (tableName == null || tableName.length() == 0) {
            tableName = "";
        }
        tableName = CMStringHelper.quoteStringLiteral(tableName);
        out.println();
        out.println("\tTableBegin " + tableName);
        VmRowElement[] rowList = this.getRows();
        if (rowList != null) {
            if (!this.m_isProcessed) {
                rowList = this.processTable(rowList);
                this.m_isProcessed = true;
            }
            if (this.m_isLayout) {
                out.println("\tSetStyle TABLELAYOUT");
            } else {
                VMPoint tableFreeze = this.findTableFreeze(rowList);
                if (tableFreeze.x > 0 || tableFreeze.y > 0) {
                    out.println("\tTableFreeze " + Integer.toString(tableFreeze.x) + " " + Integer.toString(tableFreeze.y));
                }
            }
            this.generateStyles(generator, out);
            for (int rowIndex = 0; rowIndex < rowList.length; ++rowIndex) {
                VmRowElement row = rowList[rowIndex];
                if (row == null) continue;
                if (rowIndex != 0) {
                    out.println();
                }
                row.generateStyles(generator, out);
                out.println("\t; row " + Integer.toString(rowIndex));
                out.println("\tTableRow");
                VmCellElement[] cellList = row.getCells();
                VmCellElement prevCell = null;
                for (int j = 0; j < cellList.length; ++j) {
                    VmCellElement cell = cellList[j];
                    if (cell == null) continue;
                    this.forceCommonBorder(prevCell, 1, cell, 3);
                    int colspan = 1;
                    int rowspan = 1;
                    if (cell.getColspan() != null) {
                        colspan = cell.getColspan();
                    }
                    if (cell.getRowspan() != null) {
                        rowspan = cell.getRowspan();
                    }
                    if (colspan == 1 && rowspan == 1) {
                        out.println("\tTableCell");
                    } else {
                        out.println("\tTableCell " + Integer.toString(colspan) + " " + Integer.toString(rowspan));
                    }
                    cell.generateProgram(generator, out);
                    prevCell = cell;
                }
            }
        }
        out.println("\tTableEnd");
    }

    @Override
    public void setIsLayout(boolean isLayout) {
        this.m_isLayout = isLayout;
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("table " + this.m_children.size() + " row(s)");
    }

    private VmRowElement[] processTable(VmRowElement[] rowList) {
        int rowIndex;
        int numColumns = 0;
        int maxColumns = 0;
        for (rowIndex = 0; rowIndex < rowList.length; ++rowIndex) {
            VmRowElement row = rowList[rowIndex];
            if (row == null) continue;
            VmCellElement[] cellList = row.getCells();
            for (int cellIndex = 0; cellIndex < cellList.length; ++cellIndex) {
                VmCellElement cell = cellList[cellIndex];
                if (cell == null) continue;
                numColumns += cell.getColspan() == null ? 1 : cell.getColspan();
            }
            break;
        }
        Vector<ColumnElement> columnCells = new Vector<ColumnElement>(numColumns);
        for (rowIndex = 0; rowIndex < numColumns; ++rowIndex) {
            columnCells.add(rowIndex, new ColumnElement(this.getDocument(), (IElement)this));
        }
        Vector choppedTable = new Vector(rowList.length);
        maxColumns = this.generateChoppedTable(choppedTable, rowList, columnCells);
        this.emptyRows();
        for (rowIndex = 0; rowIndex < rowList.length; ++rowIndex) {
            rowList[rowIndex] = null;
        }
        maxColumns = this.removeEmptyCols(columnCells, choppedTable, maxColumns);
        VmRowElement[] newRowList = this.regenerateRowList(choppedTable, maxColumns);
        for (int i = 0; i < newRowList.length; ++i) {
            this.m_children.add(i, newRowList[i]);
        }
        return newRowList;
    }

    private int generateChoppedTable(Vector choppedTable, VmRowElement[] rowList, Vector columnCells) {
        Vector<VmCellElement> spanningColumns = new Vector<VmCellElement>(columnCells.size());
        int maxColumns = 0;
        for (int rowIndex = 0; rowIndex < rowList.length; ++rowIndex) {
            VmRowElement row = rowList[rowIndex];
            if (row == null) continue;
            boolean hasContent = false;
            VmCellElement[] cellList = row.getCells();
            int columnIndex = 0;
            Vector<VmCellElement> columnList = new Vector<VmCellElement>(cellList.length);
            maxColumns = Math.max(maxColumns, cellList.length);
            for (int cellIndex = 0; cellIndex < maxColumns; ++cellIndex) {
                VmCellElement cell;
                boolean newColumn = true;
                if (columnIndex < spanningColumns.size() && (cell = (VmCellElement)spanningColumns.get(columnIndex)) != null) {
                    newColumn = false;
                } else {
                    if (cellIndex > cellList.length - 1) break;
                    newColumn = true;
                    cell = cellList[cellIndex];
                }
                if (cell == null) continue;
                if (cell.getChildren().length > 0) {
                    hasContent = true;
                }
                int colspan = 1;
                if (cell.getColspan() != null) {
                    colspan = cell.getColspan();
                }
                for (int i = 1; i <= colspan; ++i) {
                    int rspan;
                    if (columnIndex >= columnCells.size()) {
                        columnCells.add(columnIndex, new ColumnElement(this.getDocument(), (IElement)this));
                    }
                    if (columnIndex >= spanningColumns.size()) {
                        spanningColumns.add(columnIndex, null);
                    }
                    columnList.add(columnIndex, cell);
                    if (columnCells.get(columnIndex) != null) {
                        ColumnElement columnElement = (ColumnElement)columnCells.get(columnIndex);
                        columnElement.addChild(cell);
                        columnElement.setHasContent(cell.getChildren().length > 0);
                    }
                    int n = rspan = cell.getRowspan() == null ? 1 : cell.getRowspan();
                    if (newColumn) {
                        if (i == 1) {
                            cell.setRow(rowIndex);
                            cell.setColumn(columnIndex);
                        }
                        if (rspan > 1) {
                            spanningColumns.setElementAt(cell, columnIndex);
                        } else {
                            spanningColumns.setElementAt(null, columnIndex);
                        }
                    } else {
                        int cspan;
                        if (rowIndex - cell.getRow() == rspan - 1) {
                            spanningColumns.setElementAt(null, columnIndex);
                        }
                        int n2 = cspan = cell.getColspan() == null ? 1 : cell.getColspan();
                        if (columnIndex - cell.getColumn() == cspan - 1) {
                            --cellIndex;
                        }
                    }
                    maxColumns = Math.max(maxColumns, columnIndex + 1);
                    ++columnIndex;
                }
            }
            if (!hasContent) continue;
            choppedTable.add(columnList);
        }
        return maxColumns;
    }

    private int removeEmptyCols(Vector columnCells, Vector choppedTable, int maxColumns) {
        int numEmptyColumns = 0;
        boolean[] emptyColumns = new boolean[columnCells.size()];
        for (int i = 0; i < columnCells.size(); ++i) {
            ColumnElement column = (ColumnElement)columnCells.get(i);
            if (column == null || !column.getHasContent()) {
                emptyColumns[i] = true;
                ++numEmptyColumns;
                continue;
            }
            emptyColumns[i] = false;
        }
        if (numEmptyColumns > 0) {
            maxColumns -= numEmptyColumns;
            for (int rowIndex = 0; rowIndex < choppedTable.size(); ++rowIndex) {
                Vector columnList = (Vector)choppedTable.get(rowIndex);
                for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
                    if (columnIndex <= emptyColumns.length - 1 && !emptyColumns[columnIndex]) continue;
                    columnList.setElementAt(null, columnIndex);
                }
            }
        }
        return maxColumns;
    }

    private VmRowElement[] regenerateRowList(Vector choppedTable, int maxColumns) {
        VmRowElement[] newRowList = new VmRowElement[choppedTable.size()];
        for (int i = 0; i < newRowList.length; ++i) {
            newRowList[i] = new VmRowElement(this.getDocument(), this);
        }
        Vector<VmCellElement> spanningColumns = new Vector<VmCellElement>(maxColumns);
        for (int i = 0; i < maxColumns; ++i) {
            spanningColumns.add(i, null);
        }
        for (int rowIndex = 0; rowIndex < choppedTable.size(); ++rowIndex) {
            Vector columnList = (Vector)choppedTable.get(rowIndex);
            VmCellElement previousCell = null;
            int columnIndex = -1;
            int numColumns = 0;
            boolean nonNullCell = false;
            for (int cellIndex = 0; cellIndex < columnList.size(); ++cellIndex) {
                boolean nullThisCell = false;
                VmCellElement cell = (VmCellElement)columnList.get(cellIndex);
                if (cell == null) continue;
                nonNullCell = true;
                numColumns = ++columnIndex + 1;
                if (cell == previousCell) {
                    int colSpan = columnIndex - cell.getColumn() + 1;
                    cell.setColspan(new Integer(colSpan));
                    nullThisCell = true;
                }
                if (cell == (VmCellElement)spanningColumns.get(columnIndex)) {
                    int rowSpan = rowIndex - cell.getRow() + 1;
                    cell.setRowspan(new Integer(rowSpan));
                    nullThisCell = true;
                }
                previousCell = cell;
                if (nullThisCell) continue;
                this.forceCommonBorder((VmCellElement)spanningColumns.get(columnIndex), 2, cell, 0);
                spanningColumns.setElementAt(cell, columnIndex);
                cell.setColumn(columnIndex);
                cell.setRow(rowIndex);
                cell.setColspan(new Integer(1));
                cell.setRowspan(new Integer(1));
                newRowList[rowIndex].addChild(cell);
            }
            if (!nonNullCell || numColumns >= maxColumns) continue;
            for (int i = 0; i < maxColumns - numColumns; ++i) {
                newRowList[rowIndex].addChild(new VmCellElement(this.getDocument(), newRowList[rowIndex], previousCell.isTitle()));
            }
        }
        return newRowList;
    }

    private void forceCommonBorder(VmCellElement previousCell, int previousBorder, VmCellElement thisCell, int thisBorder) {
        if (thisCell != null && previousCell != null) {
            VmStyle unnamedStyle;
            boolean thisHasBorder = thisCell.showsBorder(thisBorder);
            boolean previousHasBorder = previousCell.showsBorder(previousBorder);
            if (thisHasBorder && !previousHasBorder) {
                unnamedStyle = (VmStyle)previousCell.getUnnamedStyle(true);
                if (unnamedStyle == null) {
                    unnamedStyle = new VmStyle();
                    previousCell.setUnnamedStyle(unnamedStyle);
                }
                unnamedStyle.setBorderDisplay(previousBorder, (byte)1);
            }
            if (previousHasBorder && !thisHasBorder) {
                unnamedStyle = (VmStyle)thisCell.getUnnamedStyle(true);
                if (unnamedStyle == null) {
                    unnamedStyle = new VmStyle();
                    thisCell.setUnnamedStyle(unnamedStyle);
                }
                unnamedStyle.setBorderDisplay(thisBorder, (byte)1);
            }
        }
    }

    private VMPoint findTableFreeze(VmRowElement[] rowList) {
        VmCellElement[] cellList = null;
        VMPoint tableFreeze = new VMPoint();
        if (rowList == null || rowList.length == 0) {
            return tableFreeze;
        }
        for (int row = 0; row < rowList.length && (cellList = rowList[row].getCells()) != null && cellList.length != 0 && cellList[cellList.length - 1].isTitle(); ++row) {
            ++tableFreeze.y;
        }
        if (tableFreeze.y == 0) {
            return tableFreeze;
        }
        for (int cell = 0; cell < cellList.length - 1 && cellList[cell] != null && cellList[cell].isTitle(); ++cell) {
            tableFreeze.x = tableFreeze.x + (cellList[cell].getColspan() == null ? 1 : cellList[cell].getColspan());
        }
        return tableFreeze;
    }

    private class ColumnElement
    extends VmElement {
        boolean hasContent;

        public ColumnElement(Document document, IElement parent) {
            super(document, 9, parent);
            this.hasContent = false;
        }

        public ColumnElement(ColumnElement other) {
            super(other);
            this.hasContent = other.getHasContent();
        }

        public VmCellElement[] getCells() {
            return this.m_children.toArray(new VmCellElement[0]);
        }

        @Override
        public void addChild(IGenericElement child) {
            this.m_children.addElement(child);
        }

        public void setHasContent(boolean hasContent) {
            if (!this.hasContent) {
                this.hasContent = hasContent;
            }
        }

        public boolean getHasContent() {
            return this.hasContent;
        }
    }
}

