/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.generator.output.vm;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElement;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.output.vm.VmElement;
import java.io.PrintStream;
import java.util.regex.Pattern;

public class VmTextFrameElement
extends VmElement {
    private String m_value;

    public VmTextFrameElement(Document page, IElement parent) {
        super(page, 11, parent);
    }

    public VmTextFrameElement(VmTextFrameElement other) {
        super(other);
        this.m_value = other.m_value;
    }

    @Override
    public void generateProgram(IGenerator generator, PrintStream out) {
        this.generateDrillThrough(generator, out);
        this.generateDrillUpDown(generator, out);
        this.generateStyles(generator, out);
        if (this.m_value != null) {
            String value = CMStringHelper.quoteStringLiteral(this.prepTextValue(this.m_value));
            out.println("\tText " + value);
        }
    }

    @Override
    public void debugDumpObject(PrintStream out) {
        out.println("textFrame '" + this.m_value + "'");
    }

    @Override
    public void setValue(String value) {
        this.m_value = value;
    }

    public String getValue() {
        return this.m_value;
    }

    private String prepTextValue(String value) {
        if (value == null) {
            return null;
        }
        Pattern p = Pattern.compile("([\n\r])+");
        String[] tokens = p.split(value, 0);
        String valueTemp = CMStringHelper.join(tokens, " ");
        valueTemp = valueTemp.replaceAll("\\s+", " ");
        return valueTemp;
    }
}

