/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.html;

import com.cognos.mobile.c8.C8UrlInformation;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.CMUrlHelper2;
import com.cognos.mobile.html.IC8UrlHelper;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.vm.VM;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class C8UrlHelper
implements IC8UrlHelper {
    private static Class CLASS = C8UrlHelper.class;
    private String gatewayURL;
    private String dispatcherURL;
    private String dispatcherPath;
    private String dispatcherContext;
    private C8UrlInformation gatewayInfo;
    private boolean isC11 = false;

    public C8UrlHelper(String gatewayURL, String dispatcherURL) {
        this.gatewayURL = gatewayURL;
        this.dispatcherURL = dispatcherURL;
        this.dispatcherPath = this.determineDispatcherPath(dispatcherURL);
        this.dispatcherContext = "/" + CMUrlHelper.getUrlTerm(this.dispatcherPath, true);
        this.gatewayInfo = new C8UrlInformation(gatewayURL);
    }

    public C8UrlHelper(String gatewayURL, String dispatcherURL, boolean isC11) {
        this(gatewayURL, dispatcherURL);
        this.isC11 = isC11;
    }

    @Override
    public final String getDispatcherPath() {
        return this.dispatcherPath;
    }

    @Override
    public final String getDispatcherContext() {
        return this.dispatcherContext;
    }

    @Override
    public final boolean isGatewayless() {
        if (this.dispatcherURL == null || this.gatewayURL == null) {
            return false;
        }
        return this.dispatcherURL.equalsIgnoreCase(this.gatewayURL);
    }

    @Override
    public final String getGatewayWebContentURL() {
        return this.gatewayInfo.getWebContentURL();
    }

    @Override
    public String getNewUrl(String baseUrl, String storeID) {
        return baseUrl + "/" + storeID;
    }

    public static String removeUpLevels(String originalPath, boolean[] upLevelAtStart) {
        if (originalPath.indexOf("../") > -1) {
            String[] splitUrl = CMStringHelper.split(originalPath, '/', true);
            int numComponants = splitUrl.length;
            for (int i = 0; i < numComponants; ++i) {
                if (!"..".equals(splitUrl[i])) continue;
                splitUrl[i] = null;
                if (i > 0) {
                    splitUrl[i - 1] = null;
                    upLevelAtStart[0] = false;
                    continue;
                }
                upLevelAtStart[0] = true;
            }
            originalPath = CMStringHelper.join(splitUrl, "/", true);
        }
        return originalPath;
    }

    @Override
    public String handleUrl(String url, boolean upLevelAtStart) {
        if (url.startsWith("cid:")) {
            return url;
        }
        if (url != null && !url.startsWith("http") && !url.startsWith("file")) {
            String dispatcherPath = this.determineDispatcherPath(this.dispatcherURL);
            url = url.startsWith("?") || url.indexOf("?SM=query") != -1 || url.startsWith(dispatcherPath) ? this.fixDispatcherUrl(url) : this.fixGatewayUrl(url, upLevelAtStart);
        }
        return url;
    }

    protected String fixGatewayUrl(String url, boolean upLevelAtStart) {
        String gatewayURL = this.gatewayURL;
        if (!url.startsWith("http:") && !url.startsWith("https:")) {
            url = url.replace('\\', '/');
            String gatewayAlias = CMUrlHelper2.getWebRoot(gatewayURL);
            if (gatewayAlias != null) {
                C8UrlInformation c8UrlInfo = new C8UrlInformation(gatewayURL);
                String webContent = c8UrlInfo.getWebContentURL();
                gatewayURL = webContent.substring(0, webContent.lastIndexOf(gatewayAlias));
                if (upLevelAtStart) {
                    url = CMPathHelper.slashSafeAppend(gatewayAlias, url);
                }
                url = url.replaceAll("//" + gatewayAlias + "/", "/../");
            }
        }
        return this.fixUrl(gatewayURL, url);
    }

    @Override
    public String getGatewayAlias() {
        String gwUrl = this.gatewayURL;
        try {
            URI uri = URI.parseURI(gwUrl, true);
            return uri.getPath();
        }
        catch (CMException e) {
            VM.log(CLASS, 3, "couldn't parse URI '" + gwUrl + "'", e);
            return "";
        }
    }

    protected String fixDispatcherUrl(String in) {
        return this.fixUrl(this.dispatcherURL, in);
    }

    private String fixUrl(String baseURL, String url) {
        String out;
        if (url.startsWith("http:")) {
            return url;
        }
        if (url.startsWith("https:")) {
            return url;
        }
        if (baseURL.equals(this.dispatcherURL) && !url.startsWith("?")) {
            try {
                java.net.URI baseURI = new java.net.URI(baseURL);
                java.net.URI outURI = baseURI.resolve(url);
                out = outURI.toString();
            }
            catch (URISyntaxException use) {
                throw new RuntimeException(use.getMessage(), use);
            }
        } else if (this.isC11 && baseURL.equals(this.dispatcherURL)) {
            baseURL = this.convertDispatcherUrlToC11(this.dispatcherURL);
            out = baseURL + url;
        } else {
            out = CMPathHelper.slashSafeAppend(baseURL, url);
        }
        return out;
    }

    private String determineDispatcherPath(String dispatcherURL) {
        if (dispatcherURL == null) {
            return null;
        }
        URL dispatcherURI = null;
        try {
            dispatcherURI = new URL(dispatcherURL);
        }
        catch (MalformedURLException e) {
            if (dispatcherURL == null) {
                dispatcherURL = "<null>";
            }
            String cause = String.format("Invalid dispatcher URL %s passed to getDispatherPath", dispatcherURL);
            VM.log(CLASS, 3, cause, e);
            throw new RuntimeException(cause, e);
        }
        return dispatcherURI.getPath();
    }

    @Override
    public String handleDispatcherContext(String downloadPath) {
        String webcontentDir = CMUrlHelper2.getWebRoot(this.gatewayURL);
        boolean isGatewayless = this.dispatcherURL.equalsIgnoreCase(this.gatewayURL);
        if (downloadPath.startsWith(this.dispatcherContext) && !isGatewayless && !downloadPath.startsWith(this.dispatcherPath)) {
            downloadPath = CMPathHelper.slashSafeAppend(webcontentDir, downloadPath.substring(this.dispatcherContext.length()));
        }
        return downloadPath;
    }

    private String convertDispatcherUrlToC11(String origDispatcherURLString) {
        String c11File = "/bi/v1/disp";
        try {
            URL origDispatcherURI = new URL(origDispatcherURLString);
            URL newDispatcherURI = new URL(origDispatcherURI.getProtocol(), origDispatcherURI.getHost(), origDispatcherURI.getPort(), c11File);
            return newDispatcherURI.toString();
        }
        catch (MalformedURLException e) {
            VM.log(CLASS, 2, "Invalid dispatcher URL: " + origDispatcherURLString, e);
            return origDispatcherURLString;
        }
    }
}

