/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.html;

import com.cognos.mobile.common.AttributesHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.html.HTFormElement;
import com.cognos.mobile.html.IHTForm;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HTFormHandler
extends DefaultHandler
implements IHTForm {
    private static final Class CLASS = HTFormHandler.class;
    private String formAction;
    private Vector formElements = new Vector();
    private StringBuffer pageText = new StringBuffer();
    private String pageTitle = null;
    private String selectName;
    private Vector selectDisplayValues;
    private String selectOptionValue;
    private String refreshUrl;
    private boolean offlineLogin = false;
    private static final String HTML_BODY = "body";
    private static final String HTML_FORM = "form";
    private static final String HTML_TABLE_DATA = "td";
    private static final String HTML_INPUT = "input";
    private static final String HTML_SELECT = "select";
    private static final String HTML_OPTION = "option";
    private static final String HTML_ANCHOR = "a";
    private static final String HTML_TITLE = "title";
    private static final String HTML_SCRIPT = "script";
    private static final String HTML_ACTION = "action";
    private static final String HTML_TYPE = "type";
    private static final String HTML_TEXT = "text";
    private static final String HTML_PASSWORD = "password";
    private static final String HTML_HIDDEN = "hidden";
    private static final String HTML_VALUE = "value";
    private static final String HTML_NAME = "name";
    private static final String HTML_META = "meta";
    private static final String HTML_REFRESH = "refresh";
    private static final String HTML_HTTP_EQUIV = "http-equiv";
    private static final String HTML_CONTENT = "content";
    private static final String JS_REDIRECT = "window.location.replace(";
    private static final String HTML_CLASS = "class";
    private final Stack characters = new Stack();

    public void doParse(IXMLParser xmlParser, InputStream inputStream) throws SAXException, IOException {
        try {
            xmlParser.parse(inputStream, this);
        }
        catch (SAXException sax) {
            throw sax;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable ex) {
            VM.log(CLASS, 3, "parser failure", ex);
            throw new SAXException(ex.toString());
        }
    }

    @Override
    public boolean hasUpdatableElements() {
        Enumeration e = this.formElements.elements();
        block4: while (e.hasMoreElements()) {
            HTFormElement element = (HTFormElement)e.nextElement();
            switch (element.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    return true;
                }
                case 0: 
                case 3: {
                    continue block4;
                }
            }
            throw new RuntimeException("internal error: unknown HTFormElement type");
        }
        return false;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    @Override
    public HTFormElement[] getFormElements() {
        Object[] a = new HTFormElement[this.formElements.size()];
        this.formElements.copyInto(a);
        return a;
    }

    @Override
    public String getFormAction() {
        return this.formAction;
    }

    @Override
    public String getPageText() {
        return this.pageText.toString();
    }

    @Override
    public String getErrorCode() {
        return CMStringHelper.extractErrorCode(this.getPageText());
    }

    @Override
    public String getPageTitle() {
        return this.pageTitle;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXParseException {
        block10: {
            String httpEquivValue;
            block11: {
                String value;
                String name;
                String type;
                block13: {
                    block12: {
                        block9: {
                            String clazz;
                            VM.log(CLASS, 0, "start: " + qName);
                            qName = qName.toLowerCase();
                            if (qName.compareTo(HTML_FORM) != 0) break block9;
                            if (this.formAction == null) {
                                this.formAction = AttributesHelper.getValueInsensitive(attrs, HTML_ACTION);
                            }
                            if ((clazz = attrs.getValue(HTML_CLASS)) != null && clazz.equalsIgnoreCase("offlineLogin")) {
                                this.offlineLogin = true;
                            }
                            break block10;
                        }
                        if (qName.compareTo(HTML_INPUT) != 0) break block11;
                        type = AttributesHelper.getValueInsensitive(attrs, HTML_TYPE).toLowerCase();
                        name = attrs.getValue(HTML_NAME);
                        if (type == null || name == null) break block10;
                        value = AttributesHelper.getValueInsensitive(attrs, HTML_VALUE);
                        if (value != null && value.length() == 0) {
                            value = null;
                        }
                        if (!type.equals(HTML_TEXT)) break block12;
                        this.formElements.addElement(new HTFormElement(1, name, value));
                        break block10;
                    }
                    if (!type.equals(HTML_PASSWORD)) break block13;
                    this.formElements.addElement(new HTFormElement(2, name, value));
                    break block10;
                }
                if (!type.equals(HTML_HIDDEN)) break block10;
                this.formElements.addElement(new HTFormElement(3, name, value));
                break block10;
            }
            if (qName.compareTo(HTML_SELECT) == 0) {
                this.selectName = attrs.getValue(HTML_NAME);
                this.selectDisplayValues = new Vector();
            } else if (qName.compareTo(HTML_OPTION) == 0) {
                this.selectOptionValue = attrs.getValue(HTML_VALUE);
            } else if (qName.compareTo(HTML_META) == 0 && (httpEquivValue = AttributesHelper.getValueInsensitive(attrs, HTML_HTTP_EQUIV)) != null && httpEquivValue.toLowerCase().equals(HTML_REFRESH)) {
                String content = AttributesHelper.getValueInsensitive(attrs, HTML_CONTENT);
                String[] parts = CMStringHelper.split(content, ';', true);
                for (int i = 0; i < parts.length; ++i) {
                    int j = parts[i].indexOf(61);
                    if (j <= 0 || "url".compareTo(parts[i].substring(0, j).toLowerCase()) != 0) continue;
                    this.refreshUrl = parts[i].substring(j + 1, parts[i].length());
                }
            }
        }
        this.characters.push(null);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        char lastChar;
        int length;
        if (len == 0) {
            return;
        }
        StringBuffer s = (StringBuffer)this.characters.peek();
        if (s == null) {
            s = new StringBuffer();
            this.characters.setElementAt(s, this.characters.size() - 1);
        }
        if (buf[0] != '\n' && (length = s.length()) > 0 && ((lastChar = s.charAt(length - 1)) == '.' || lastChar == ':')) {
            s.append(' ');
        }
        s.append(buf, offset, len);
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String cleanedCharacters = null;
        StringBuffer sb = (StringBuffer)this.characters.pop();
        if (sb == null) {
            VM.log(CLASS, 0, "end: " + qName);
        } else {
            cleanedCharacters = HTFormHandler.cleanCharacters(sb.toString());
            VM.log(CLASS, 0, "end: " + qName + " (" + cleanedCharacters + ")");
        }
        qName = qName.toLowerCase();
        if (qName.compareTo(HTML_TITLE) == 0) {
            if (cleanedCharacters != null) {
                this.pageTitle = cleanedCharacters;
                this.pageText.append("(");
                this.pageText.append(cleanedCharacters);
                this.pageText.append(") ");
            }
        } else if (qName.compareTo(HTML_ANCHOR) == 0) {
            if (cleanedCharacters != null) {
                this.pageText.append("[");
                this.pageText.append(cleanedCharacters);
                this.pageText.append("] ");
            }
        } else if (qName.compareTo(HTML_SELECT) == 0) {
            if (this.selectName != null && this.selectName.length() > 0) {
                HTFormElement.DisplayValuePair[] displayValues = new HTFormElement.DisplayValuePair[this.selectDisplayValues.size()];
                this.pageText.append("(");
                String prefix = "";
                for (int i = 0; i < this.selectDisplayValues.size(); ++i) {
                    displayValues[i] = (HTFormElement.DisplayValuePair)this.selectDisplayValues.elementAt(i);
                    this.pageText.append(prefix);
                    this.pageText.append(displayValues[i].display);
                    prefix = ", ";
                }
                this.pageText.append(") ");
                HTFormElement element = new HTFormElement(4, this.selectName, null);
                element.setDisplayValues(displayValues);
                this.formElements.addElement(element);
            }
        } else if (qName.compareTo(HTML_OPTION) == 0) {
            if (this.selectOptionValue != null && this.selectOptionValue.length() > 0 && cleanedCharacters != null && cleanedCharacters.length() > 0) {
                this.selectDisplayValues.addElement(new HTFormElement.DisplayValuePair(cleanedCharacters, this.selectOptionValue));
            }
        } else if (qName.compareTo(HTML_SCRIPT) == 0) {
            if (cleanedCharacters != null) {
                this.checkScriptForRedirect(cleanedCharacters);
            }
        } else if (cleanedCharacters != null && cleanedCharacters.length() > 0) {
            this.formElements.addElement(new HTFormElement(0, cleanedCharacters, null));
            this.pageText.append(cleanedCharacters);
            this.pageText.append(" ");
        }
    }

    public void checkScriptForRedirect(String jsContent) {
        int i = jsContent.indexOf(JS_REDIRECT);
        if (i >= 0) {
            int end = jsContent.indexOf(jsContent.charAt(i += JS_REDIRECT.length()), ++i);
            this.refreshUrl = jsContent.substring(i, end);
            VM.log(CLASS, 0, "refreshURL: " + this.refreshUrl);
        }
    }

    private static String cleanCharacters(String characters) {
        String cleanedCharacters = null;
        if (characters != null && characters.length() > 0) {
            cleanedCharacters = characters.trim();
            if ((cleanedCharacters = cleanedCharacters.replace('\n', ' ')).length() == 1 && cleanedCharacters.charAt(0) == '\u00a0') {
                cleanedCharacters = null;
            }
        }
        return cleanedCharacters;
    }

    public boolean isOfflineLogin() {
        return this.offlineLogin;
    }
}

