/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.html;

import com.cognos.mobile.html.HTMailInfo;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMailtoHandler
extends DefaultHandler {
    private static final Class CLASS = HTMailtoHandler.class;
    private static final String HTML_ANCHOR = "a";
    private static final String HTML_HREF = "href";
    private static final int TOK_NONE = 0;
    private static final int TOK_ANCHOR = 1;
    private Vector mailtoElements = new Vector();
    private HTMailInfo mailInfo = null;

    private int lookupToken(String s) {
        if ((s = s.toLowerCase()).compareTo(HTML_ANCHOR) == 0) {
            return 1;
        }
        return 0;
    }

    public void doParse(IXMLParser xmlParser, InputStream inputStream) throws SAXException, IOException {
        try {
            xmlParser.parse(inputStream, this);
        }
        catch (SAXException sax) {
            throw sax;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable ex) {
            VM.log(CLASS, 3, "parser failure", ex);
            throw new SAXException(ex.toString());
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXParseException {
        VM.log(CLASS, 0, "start: " + qName);
        int token = this.lookupToken(qName);
        switch (token) {
            case 1: {
                String href = attrs.getValue(HTML_HREF);
                if (href == null || href.indexOf("mailto:") == -1) break;
                this.mailInfo = this.parseMailTo(href);
                break;
            }
        }
    }

    public void doParse(String href) throws SAXException, IOException {
        try {
            if (href != null && href.indexOf("mailto:") != -1) {
                this.mailInfo = this.parseMailTo(href);
                if (this.mailInfo != null) {
                    this.mailtoElements.add(this.mailInfo);
                    this.mailInfo = null;
                }
            }
        }
        catch (Throwable ex) {
            VM.log(CLASS, 3, "parser failure", ex);
            throw new SAXException(ex.toString());
        }
    }

    private HTMailInfo parseMailTo(String mailtoUrl) {
        String to;
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern p = Pattern.compile("mailto:(.*)\\?(.*)");
        Matcher m = p.matcher(mailtoUrl);
        if (m.matches()) {
            to = m.group(1);
            map.put("to", to);
            String headers = m.group(2);
            if (headers != null) {
                p = Pattern.compile("(to|cc|bcc|subject|body)=(.*?)(&|$)");
                m = p.matcher(headers);
                while (m.find()) {
                    String key = m.group(1);
                    String value = m.group(2);
                    map.put(key, value);
                }
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        to = (String)map.get("to");
        String cc = (String)map.get("cc");
        String bcc = (String)map.get("bcc");
        String subject = (String)map.get("subject");
        String body = (String)map.get("body");
        return new HTMailInfo(to, cc, bcc, subject, body, null);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.mailInfo != null && len != 0) {
            StringBuffer s = new StringBuffer();
            s.append(buf, offset, len);
            this.mailInfo.setLabel(s.toString());
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        int token = this.lookupToken(qName);
        switch (token) {
            case 1: {
                if (this.mailInfo == null) break;
                this.mailtoElements.add(this.mailInfo);
                this.mailInfo = null;
                break;
            }
        }
    }

    public Vector getMailtoElements() {
        return this.mailtoElements;
    }
}

