/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.inbox;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.inbox.IInboxSource;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMRender;
import java.util.Enumeration;
import java.util.Vector;

public class DemoInbox
implements IInboxSource {
    private static final Class CLASS = DemoInbox.class;
    private final Vector entries = new Vector();

    @Override
    public VMRender getRender(int renderID, ITaskMonitor taskMonitor) {
        Entry entry;
        VM.log(CLASS, 0, "get render ID " + renderID);
        if (taskMonitor != null) {
            taskMonitor.setDescriptions(CMIDs.OPEN_1, CMIDs.OPEN_2, CMIDs.OPEN_BUTTON);
        }
        return (entry = this.find(renderID)) == null ? null : entry.object;
    }

    @Override
    public VMRender getRender(int renderID, int pageIndex, ITaskMonitor taskMonitor) {
        return this.getRender(renderID, taskMonitor);
    }

    @Override
    public boolean checkIfRenderExists(int renderID, int pageIndex) {
        return this.getRender(renderID, pageIndex, ITaskMonitor.NULL) != null;
    }

    @Override
    public Render getMetadata(int renderID) {
        VM.log(CLASS, 0, "get metadata " + renderID);
        Entry entry = this.find(renderID);
        return entry == null ? null : entry.meta;
    }

    @Override
    public int[] listRenders() {
        VM.log(CLASS, 0, "list renders");
        int[] ids = new int[this.entries.size()];
        int i = 0;
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            ids[i++] = entry.meta.renderID;
        }
        return ids;
    }

    @Override
    public void refresh(ITaskMonitor waitDialogUI) throws CMException {
        VM.log(CLASS, 0, "refresh");
    }

    @Override
    public String getSyncMethod() {
        return "N";
    }

    @Override
    public void setListener(IInboxSource.Listener listener) {
    }

    public void addRender(Render meta, VMRender object) {
        this.entries.addElement(new Entry(meta, object));
    }

    private Entry find(int renderID) {
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            if (entry.meta.renderID != renderID) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean enforceLeases() {
        return false;
    }

    @Override
    public int getRequestedRenderStatus(int renderID) {
        return 0;
    }

    @Override
    public void clearRequestedRenderStatus() {
    }

    private static final class Entry {
        public final Render meta;
        public final VMRender object;

        public Entry(Render meta, VMRender object) {
            this.meta = meta;
            this.object = object;
        }
    }
}

