/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.inbox;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.CMIntSet;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.common.IntMap;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.event.Event;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.inbox.IInboxSource;
import com.cognos.mobile.jzlib.ZInputStream;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.task.IThreadPool;
import com.cognos.mobile.vm.ClientMemDatabase;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import com.cognos.mobile.vm.VMRender;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;

public class S2Inbox
implements IInboxSource {
    private static final Class CLASS = S2Inbox.class;
    private final MobileServiceProxy mobileServiceProxy;
    private final IThreadPool threadPool;
    private final Object lock = new Object();
    private final IVMCache cache;
    private final IEventManager eventManager;
    private final IResourceManager resourceManager;
    private final VMOptions options;
    private final EntryMap inbox = new EntryMap();
    private final CMIntSet inProgress = new CMIntSet(10);
    private IInboxSource.Listener inboxListener = null;
    private int requestedRenderID = -1;
    private int requestedRenderStatus = 0;
    private SyncInboxRunnable syncer;

    public S2Inbox(MobileServiceProxy mobileServiceProxy, IThreadPool threadPool, IVMCache cache, final IEventManager eventManager, final IResourceManager resourceManager, VMOptions options) throws CMException {
        this.mobileServiceProxy = mobileServiceProxy;
        this.threadPool = threadPool;
        this.cache = cache;
        this.eventManager = eventManager;
        this.resourceManager = resourceManager;
        this.options = options;
        threadPool.executeBackground(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean successful = true;
                try {
                    IVMCache.Entry[] entries = S2Inbox.this.cache.list();
                    for (int i = 0; i < entries.length; ++i) {
                        try {
                            int dot2;
                            boolean isDB = false;
                            boolean isCompressed = false;
                            if (entries[i].filename.endsWith(".db")) {
                                isDB = true;
                                isCompressed = false;
                            } else if (entries[i].filename.endsWith(".dbz")) {
                                isDB = true;
                                isCompressed = true;
                            }
                            if (!isDB) continue;
                            VM.log(CLASS, 0, "reading cache entry '" + entries[i].filename + "'");
                            int userID = -1;
                            int pageIndex = 0;
                            int dot1 = entries[i].filename.indexOf(46);
                            if (dot1 >= 0 && (dot2 = entries[i].filename.indexOf(46, dot1 + 2)) >= dot1 + 2) {
                                userID = Integer.parseInt(entries[i].filename.substring(dot1 + 1, dot2));
                                int dot3 = entries[i].filename.indexOf(46, dot2 + 2);
                                if (dot3 >= dot2 + 2) {
                                    pageIndex = Integer.parseInt(entries[i].filename.substring(dot2 + 1, dot3));
                                }
                            }
                            if (S2Inbox.this.options.getUserID() == null || !S2Inbox.this.options.getUserID().equalsIgnoreCase(String.valueOf(userID))) continue;
                            int renderID = Integer.parseInt(entries[i].filename.substring(0, dot1));
                            IVMReader db = S2Inbox.this.cache.readDB(entries[i].filename, isCompressed);
                            if (db == null) continue;
                            VMRender render = new VMRender();
                            render.openRender(renderID, db);
                            IInboxSource.Listener listener = null;
                            InboxEntry entry = new InboxEntry();
                            entry.meta = render.getMeta();
                            entry.meta.size = entries[i].size;
                            entry.filename = entries[i].filename;
                            entry.compressed = isCompressed;
                            Object object = S2Inbox.this.lock;
                            synchronized (object) {
                                S2Inbox.this.inbox.put(renderID, pageIndex, entry);
                                listener = S2Inbox.this.inboxListener;
                            }
                            if (listener == null) continue;
                            listener.inboxChanged(true);
                            continue;
                        }
                        catch (Throwable t) {
                            String msg = resourceManager.formatString(Integer.toString(2031), new String[]{entries[i].filename, t.toString()});
                            VM.log(CLASS, 3, msg);
                            eventManager.postEvent(new Event(this, 14, msg));
                            successful = false;
                        }
                    }
                }
                catch (Throwable t) {
                    VM.log(CLASS, 2, "unexpected error while reading cache", t);
                    successful = false;
                }
                finally {
                    if (successful) {
                        eventManager.postEvent(new Event(this, 14, resourceManager.loadString(CMIDs.INBOX_SUCCESSFULLY_REFRESHED_REPORTS)));
                    } else {
                        eventManager.postEvent(new Event(this, 14, resourceManager.loadString(CMIDs.INBOX_PROBLEM_REFRESHING_REPORTS)));
                    }
                }
            }
        });
    }

    private void cancelSync() {
        if (this.syncer != null) {
            this.syncer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Render getMetadata(int renderID) {
        Object object = this.lock;
        synchronized (object) {
            InboxEntry entry = this.inbox.get(renderID, 0);
            return entry == null ? null : entry.meta;
        }
    }

    @Override
    public VMRender getRender(int renderID, ITaskMonitor taskMonitor) throws CMException {
        return this.getRender(renderID, 0, taskMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkIfRenderExists(int renderID, int pageIndex) {
        InboxEntry entry = null;
        Object object = this.lock;
        synchronized (object) {
            entry = this.inbox.get(renderID, pageIndex);
        }
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMRender getRender(int renderID, int pageIndex, ITaskMonitor taskMonitor) throws CMException {
        InboxEntry entry = null;
        Object object = this.lock;
        synchronized (object) {
            entry = this.inbox.get(renderID, pageIndex);
        }
        if (entry == null) {
            return null;
        }
        IVMReader db = this.cache.readDB(entry.filename, entry.compressed);
        if (db == null) {
            return null;
        }
        VMRender render = new VMRender();
        render.openRender(renderID, db);
        return render;
    }

    @Override
    public String getSyncMethod() {
        return "2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] listRenders() {
        Object object = this.lock;
        synchronized (object) {
            int[] renders = new int[this.inbox.size()];
            int i = 0;
            IntMap.IntEnumeration e = this.inbox.keys();
            while (e.hasMoreElements()) {
                renders[i++] = e.nextElement();
            }
            return renders;
        }
    }

    @Override
    public void refresh(ITaskMonitor taskMonitor) throws CMException {
        if (taskMonitor == null) {
            this.threadPool.executeBackground(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (S2Inbox.this.requestedRenderID != -1) {
                            S2Inbox.this.requestedRenderStatus = S2Inbox.this.mobileServiceProxy.getRenderStatus(null, false, S2Inbox.this.requestedRenderID);
                        } else {
                            S2Inbox.this.mobileServiceProxy.getRenderStatus(null, false, S2Inbox.this.requestedRenderID);
                        }
                    }
                    catch (CMException cme) {
                        VM.log(CLASS, 3, "couldn't refresh", cme);
                    }
                }
            });
        } else {
            this.mobileServiceProxy.getAbout(taskMonitor, false);
        }
        VM.log(CLASS, 0, "refreshed");
    }

    @Override
    public void setListener(IInboxSource.Listener listener) {
        this.inboxListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int downloadRender(int renderID, int pageIndex, CMIntSet newInboxItems) throws CMException, Throwable {
        int pageCount = 0;
        VM.log(CLASS, 3, "don't have render " + renderID + ", page " + pageIndex + "; getting it");
        int[] totalLength = new int[1];
        byte[] bytes = this.mobileServiceProxy.downloadDB(renderID, pageIndex, totalLength, true, ITaskMonitor.NULL);
        if (bytes.length != totalLength[0]) {
            VM.log(CLASS, 3, "partial response; rcvd " + bytes.length + "/" + totalLength[0] + " bytes");
            int offset = bytes.length;
            byte[] temp = new byte[totalLength[0]];
            System.arraycopy(bytes, 0, temp, 0, bytes.length);
            bytes = temp;
            while (offset < totalLength[0]) {
                String detail = this.resourceManager.formatString(CMIDs.SYNC_DOWNLOADING_X_PERCENT_COMPLETE, new String[]{Integer.toString(Math.min((this.inbox.size() * 100 + offset * 50 / totalLength[0]) / newInboxItems.getCount(), 100))});
                this.eventManager.postEvent(new Event(this, 14, detail));
                VM.log(CLASS, 3, "downloading render " + renderID + ", page " + pageIndex + " at offset " + offset + "; " + detail);
                int read = this.mobileServiceProxy.downloadDB(renderID, pageIndex, bytes, offset, true, ITaskMonitor.NULL);
                VM.log(CLASS, 3, "partial response; have " + (offset += read) + "/" + totalLength[0] + " bytes");
            }
        }
        VM.log(CLASS, 3, "downloaded render " + renderID + ", page " + pageIndex);
        String detail = this.resourceManager.formatString(CMIDs.SYNC_DOWNLOADING_X_PERCENT_COMPLETE, new String[]{Integer.toString(Math.min((this.inbox.size() * 100 + 50) / newInboxItems.getCount(), 100))});
        this.eventManager.postEvent(new Event(this, 14, detail));
        VM.log(CLASS, 0, detail);
        InboxEntry entry = new InboxEntry();
        entry.filename = Integer.toString(renderID) + "." + this.options.getUserID() + "." + pageIndex + ".dbz";
        this.cache.writeDB(entry.filename, bytes);
        IVMReader db = ClientMemDatabase.fromInputStream(new ZInputStream(new ByteArrayInputStream(bytes)));
        VMRender render = new VMRender();
        render.openRender(renderID, db);
        entry.compressed = true;
        entry.meta = render.getMeta();
        entry.meta.size = totalLength[0];
        pageCount = render.getMeta() == null ? -1 : render.getMeta().pageCount;
        Object object = this.lock;
        synchronized (object) {
            this.inbox.put(renderID, pageIndex, entry);
        }
        if (this.inboxListener != null) {
            VM.log(CLASS, 0, "notifying inbox of render " + renderID);
            this.inboxListener.inboxChanged(true);
        }
        VM.log(CLASS, 0, "done background task for render " + renderID);
        detail = this.resourceManager.formatString(CMIDs.SYNC_DOWNLOADING_X_PERCENT_COMPLETE, new String[]{Integer.toString(Math.min(this.inbox.size() * 100 / newInboxItems.getCount(), 100))});
        this.eventManager.postEvent(new Event(this, 14, detail));
        VM.log(CLASS, 0, detail);
        return pageCount;
    }

    public void setInbox(CMIntSet newInboxItems) {
        VM.log(CLASS, 0, "received new inbox items");
        this.cancelSync();
        this.syncer = new SyncInboxRunnable(newInboxItems);
        this.threadPool.executeBackground(this.syncer);
    }

    @Override
    public boolean enforceLeases() {
        return true;
    }

    @Override
    public int getRequestedRenderStatus(int renderID) {
        this.requestedRenderID = renderID;
        return this.requestedRenderStatus;
    }

    @Override
    public void clearRequestedRenderStatus() {
        this.requestedRenderID = -1;
        this.requestedRenderStatus = 0;
    }

    private class SyncInboxRunnable
    implements Runnable {
        private final CMIntSet newInboxItems;
        private boolean cancel;

        public SyncInboxRunnable(CMIntSet newInboxItems) {
            this.newInboxItems = newInboxItems;
        }

        public void cancel() {
            this.cancel = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                EntryMap entriesToDelete;
                if (this.cancel) {
                    return;
                }
                boolean needToSignalInboxListener = false;
                Object object = S2Inbox.this.lock;
                synchronized (object) {
                    entriesToDelete = S2Inbox.this.inbox.copy();
                    for (int i = 0; i < this.newInboxItems.getCount(); ++i) {
                        entriesToDelete.remove(this.newInboxItems.get(i));
                    }
                    IntMap.IntEnumeration e = entriesToDelete.keys();
                    while (e.hasMoreElements()) {
                        needToSignalInboxListener = true;
                        S2Inbox.this.inbox.remove(e.nextElement());
                    }
                }
                if (this.cancel) {
                    return;
                }
                if (needToSignalInboxListener && S2Inbox.this.inboxListener != null) {
                    S2Inbox.this.inboxListener.inboxChanged(false);
                }
                if (this.cancel) {
                    return;
                }
                IntMap.IntEnumeration it = entriesToDelete.keys();
                while (it.hasMoreElements()) {
                    IntMap im = (IntMap)it.nextValue();
                    IntMap.IntEnumeration it2 = im.keys();
                    while (it2.hasMoreElements()) {
                        if (this.cancel) {
                            return;
                        }
                        InboxEntry ie = (InboxEntry)it2.nextValue();
                        try {
                            S2Inbox.this.cache.delete(ie.filename);
                        }
                        catch (Throwable t) {
                            VM.log(CLASS, 2, "error deleting render '" + ie.filename + "'", t);
                        }
                    }
                }
                if (this.cancel) {
                    return;
                }
                boolean needToPostFinalSynchronizedToolip = false;
                if (this.newInboxItems.getCount() != S2Inbox.this.inbox.size()) {
                    String detail = S2Inbox.this.resourceManager.formatString(CMIDs.SYNC_DOWNLOADING_X_PERCENT_COMPLETE, new String[]{Integer.toString(Math.min(S2Inbox.this.inbox.size() * 100 / this.newInboxItems.getCount(), 100))});
                    S2Inbox.this.eventManager.postEvent(new Event(this, 14, detail));
                    VM.log(CLASS, 0, detail);
                    needToPostFinalSynchronizedToolip = true;
                }
                for (int i = 0; i < this.newInboxItems.getCount(); ++i) {
                    Object msg;
                    boolean needToDownload;
                    int renderID = this.newInboxItems.get(i);
                    if (this.cancel) {
                        return;
                    }
                    Object t = S2Inbox.this.lock;
                    synchronized (t) {
                        boolean bl = needToDownload = !S2Inbox.this.inbox.isRenderCompletelyDownloaded(renderID);
                        if (this.cancel) {
                            return;
                        }
                        S2Inbox.this.inProgress.add(renderID);
                    }
                    int pageCount = 0;
                    if (!needToDownload) continue;
                    try {
                        if (this.cancel) {
                            return;
                        }
                        if (S2Inbox.this.inbox.get(renderID, 0) != null) {
                            pageCount = S2Inbox.this.inbox.getPageCountOfRender(renderID);
                        } else {
                            pageCount = S2Inbox.this.downloadRender(renderID, 0, this.newInboxItems);
                            S2Inbox.this.inbox.setPageCountOfRender(renderID, pageCount);
                        }
                        if (pageCount <= 0) continue;
                        for (int j = 1; j < pageCount; ++j) {
                            if (this.cancel) {
                                return;
                            }
                            if (S2Inbox.this.inbox.get(renderID, j) != null) continue;
                            S2Inbox.this.downloadRender(renderID, j, this.newInboxItems);
                        }
                        continue;
                    }
                    catch (CMException cme) {
                        if (this.cancel) {
                            return;
                        }
                        msg = cme.getLocalizedMessage(S2Inbox.this.resourceManager) + " (" + renderID + ")";
                        VM.log(CLASS, 2, (String)msg);
                        S2Inbox.this.eventManager.postEvent(new Event(this, 14, msg));
                        needToPostFinalSynchronizedToolip = false;
                        continue;
                    }
                    catch (Throwable t2) {
                        if (this.cancel) {
                            return;
                        }
                        msg = S2Inbox.this.resourceManager.formatString(Integer.toString(2031), new String[]{Integer.toString(renderID), t2.toString()});
                        VM.log(CLASS, 3, (String)msg);
                        S2Inbox.this.eventManager.postEvent(new Event(this, 14, msg));
                        needToPostFinalSynchronizedToolip = false;
                        continue;
                    }
                    finally {
                        if (this.cancel) {
                            return;
                        }
                        Object object2 = S2Inbox.this.lock;
                        synchronized (object2) {
                            S2Inbox.this.inProgress.remove(renderID);
                        }
                    }
                }
                if (this.cancel) {
                    return;
                }
                S2Inbox.this.inboxListener.inboxIsAccurate();
                if (this.cancel) {
                    return;
                }
                if (needToPostFinalSynchronizedToolip) {
                    String detail = S2Inbox.this.resourceManager.loadString(CMIDs.SYNC_SYNCHRONIZED);
                    S2Inbox.this.eventManager.postEvent(new Event(this, 14, detail));
                    VM.log(CLASS, 0, detail);
                }
            }
            catch (Throwable t) {
                VM.log(CLASS, 3, "unexpected error while processing new inbox", t);
            }
        }
    }

    private static class InboxEntry {
        public Render meta;
        public boolean marked;
        public boolean compressed;
        public String filename;

        private InboxEntry() {
        }
    }

    private static class EntryMap {
        protected IntMap subitems = new IntMap();
        protected Hashtable pageCounts = new Hashtable();

        EntryMap() {
        }

        public void put(int renderID, IntMap entry) {
            this.subitems.put(renderID, entry);
        }

        public void setPageCountOfRender(int renderID, int pageCount) {
            this.pageCounts.put(new Integer(renderID), new Integer(pageCount));
        }

        public int getPageCountOfRender(int renderID) {
            Integer pageCount = (Integer)this.pageCounts.get(new Integer(renderID));
            if (pageCount != null) {
                return pageCount;
            }
            return 1;
        }

        public void put(int renderID, int pageIndex, InboxEntry entry) {
            IntMap entryMap = (IntMap)this.subitems.get(renderID);
            if (entryMap == null) {
                entryMap = new IntMap();
            }
            entryMap.put(pageIndex, entry);
            this.subitems.put(renderID, entryMap);
        }

        public IntMap get(int renderID) {
            return (IntMap)this.subitems.get(renderID);
        }

        public InboxEntry get(int renderID, int pageIndex) {
            IntMap entryMap = (IntMap)this.subitems.get(renderID);
            if (entryMap == null) {
                return null;
            }
            return (InboxEntry)entryMap.get(pageIndex);
        }

        public EntryMap copy() {
            EntryMap copyMap = new EntryMap();
            IntMap.IntEnumeration e = this.subitems.keys();
            while (e.hasMoreElements()) {
                int key = e.nextElement();
                IntMap value = (IntMap)this.subitems.get(key);
                if (value == null) continue;
                copyMap.subitems.put(key, value.copy());
            }
            return copyMap;
        }

        public boolean isRenderCompletelyDownloaded(int renderID) {
            if (!this.subitems.contains(renderID)) {
                return false;
            }
            int count = this.getPageCountOfRender(renderID);
            for (int i = 0; i < count; ++i) {
                if (this.get(renderID, i) != null) continue;
                return false;
            }
            return true;
        }

        public boolean contains(int renderID) {
            return this.subitems.contains(renderID);
        }

        public int size() {
            return this.subitems.size();
        }

        public void remove(int renderID) {
            this.subitems.remove(renderID);
        }

        public IntMap.IntEnumeration keys() {
            return this.subitems.keys();
        }
    }
}

