/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.jzlib;

import com.cognos.mobile.jzlib.InfBlocks;
import com.cognos.mobile.jzlib.ZStream;

final class Inflate {
    private static final int MAX_WBITS = 15;
    private static final int PRESET_DICT = 32;
    static final int Z_NO_FLUSH = 0;
    static final int Z_PARTIAL_FLUSH = 1;
    static final int Z_SYNC_FLUSH = 2;
    static final int Z_FULL_FLUSH = 3;
    static final int Z_FINISH = 4;
    private static final int Z_DEFLATED = 8;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private static final int METHOD = 0;
    private static final int FLAG = 1;
    private static final int DICT4 = 2;
    private static final int DICT3 = 3;
    private static final int DICT2 = 4;
    private static final int DICT1 = 5;
    private static final int DICT0 = 6;
    private static final int BLOCKS = 7;
    private static final int CHECK4 = 8;
    private static final int CHECK3 = 9;
    private static final int CHECK2 = 10;
    private static final int CHECK1 = 11;
    private static final int DONE = 12;
    private static final int BAD = 13;
    int mode;
    int method;
    long[] was = new long[1];
    long need;
    int marker;
    int nowrap;
    int wbits;
    InfBlocks blocks;
    private static byte[] mark = new byte[]{0, 0, -1, -1};

    Inflate() {
    }

    int inflateReset(ZStream z) {
        if (z == null || z.istate == null) {
            return -2;
        }
        z.total_out = 0L;
        z.total_in = 0L;
        z.msg = null;
        z.istate.mode = z.istate.nowrap != 0 ? 7 : 0;
        z.istate.blocks.reset(z, null);
        return 0;
    }

    int inflateEnd(ZStream z) {
        if (this.blocks != null) {
            this.blocks.free(z);
        }
        this.blocks = null;
        return 0;
    }

    int inflateInit(ZStream z, int w) {
        z.msg = null;
        this.blocks = null;
        this.nowrap = 0;
        if (w < 0) {
            w = -w;
            this.nowrap = 1;
        }
        if (w < 8 || w > 15) {
            this.inflateEnd(z);
            return -2;
        }
        this.wbits = w;
        z.istate.blocks = new InfBlocks(z, z.istate.nowrap != 0 ? null : this, 1 << w);
        this.inflateReset(z);
        return 0;
    }

    int inflate(ZStream z, int f) {
        if (z == null || z.istate == null || z.next_in == null) {
            return -2;
        }
        f = f == 4 ? -5 : 0;
        int r = -5;
        block16: while (true) {
            switch (z.istate.mode) {
                case 0: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    if (((z.istate.method = z.next_in[z.next_in_index++]) & 0xF) != 8) {
                        z.istate.mode = 13;
                        z.msg = "unknown compression method";
                        z.istate.marker = 5;
                        continue block16;
                    }
                    if ((z.istate.method >> 4) + 8 > z.istate.wbits) {
                        z.istate.mode = 13;
                        z.msg = "invalid window size";
                        z.istate.marker = 5;
                        continue block16;
                    }
                    z.istate.mode = 1;
                }
                case 1: {
                    int b;
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    if (((z.istate.method << 8) + (b = z.next_in[z.next_in_index++] & 0xFF)) % 31 != 0) {
                        z.istate.mode = 13;
                        z.msg = "incorrect header check";
                        z.istate.marker = 5;
                        continue block16;
                    }
                    if ((b & 0x20) == 0) {
                        z.istate.mode = 7;
                        continue block16;
                    }
                    z.istate.mode = 2;
                }
                case 2: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need = (long)((z.next_in[z.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    z.istate.mode = 3;
                }
                case 3: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need += (long)((z.next_in[z.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    z.istate.mode = 4;
                }
                case 4: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need += (long)((z.next_in[z.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    z.istate.mode = 5;
                }
                case 5: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need += (long)z.next_in[z.next_in_index++] & 0xFFL;
                    z.adler = z.istate.need;
                    z.istate.mode = 6;
                    return 2;
                }
                case 6: {
                    z.istate.mode = 13;
                    z.msg = "need dictionary";
                    z.istate.marker = 0;
                    return -2;
                }
                case 7: {
                    r = z.istate.blocks.proc(z, r);
                    if (r == -3) {
                        z.istate.mode = 13;
                        z.istate.marker = 0;
                        continue block16;
                    }
                    if (r == 0) {
                        r = f;
                    }
                    if (r != 1) {
                        return r;
                    }
                    r = f;
                    z.istate.blocks.reset(z, z.istate.was);
                    if (z.istate.nowrap != 0) {
                        z.istate.mode = 12;
                        continue block16;
                    }
                    z.istate.mode = 8;
                }
                case 8: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need = (long)((z.next_in[z.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    z.istate.mode = 9;
                }
                case 9: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need += (long)((z.next_in[z.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    z.istate.mode = 10;
                }
                case 10: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need += (long)((z.next_in[z.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    z.istate.mode = 11;
                }
                case 11: {
                    if (z.avail_in == 0) {
                        return r;
                    }
                    r = f;
                    --z.avail_in;
                    ++z.total_in;
                    z.istate.need += (long)z.next_in[z.next_in_index++] & 0xFFL;
                    if ((int)z.istate.was[0] != (int)z.istate.need) {
                        z.istate.mode = 13;
                        z.msg = "incorrect data check";
                        z.istate.marker = 5;
                        continue block16;
                    }
                    z.istate.mode = 12;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return -3;
                }
            }
            break;
        }
        return -2;
    }

    int inflateSetDictionary(ZStream z, byte[] dictionary, int dictLength) {
        int index = 0;
        int length = dictLength;
        if (z == null || z.istate == null || z.istate.mode != 6) {
            return -2;
        }
        if (z._adler.adler32(1L, dictionary, 0, dictLength) != z.adler) {
            return -3;
        }
        z.adler = z._adler.adler32(0L, null, 0, 0);
        if (length >= 1 << z.istate.wbits) {
            length = (1 << z.istate.wbits) - 1;
            index = dictLength - length;
        }
        z.istate.blocks.set_dictionary(dictionary, index, length);
        z.istate.mode = 7;
        return 0;
    }

    int inflateSync(ZStream z) {
        int n;
        if (z == null || z.istate == null) {
            return -2;
        }
        if (z.istate.mode != 13) {
            z.istate.mode = 13;
            z.istate.marker = 0;
        }
        if ((n = z.avail_in) == 0) {
            return -5;
        }
        int p = z.next_in_index;
        int m = z.istate.marker;
        while (n != 0 && m < 4) {
            m = z.next_in[p] == mark[m] ? ++m : (z.next_in[p] != 0 ? 0 : 4 - m);
            ++p;
            --n;
        }
        z.total_in += (long)(p - z.next_in_index);
        z.next_in_index = p;
        z.avail_in = n;
        z.istate.marker = m;
        if (m != 4) {
            return -3;
        }
        long r = z.total_in;
        long w = z.total_out;
        this.inflateReset(z);
        z.total_in = r;
        z.total_out = w;
        z.istate.mode = 7;
        return 0;
    }

    int inflateSyncPoint(ZStream z) {
        if (z == null || z.istate == null || z.istate.blocks == null) {
            return -2;
        }
        return z.istate.blocks.sync_point();
    }
}

