/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

import com.cognos.mobile.location.CartesianComparator;
import com.cognos.mobile.location.KDTree;
import com.cognos.mobile.location.Leaf;
import com.cognos.mobile.location.Location;
import com.cognos.mobile.location.LocationHelper;
import java.util.ArrayList;
import java.util.Collections;

class Branch
implements KDTree.IBranch {
    private KDTree.IBranch left;
    private KDTree.IBranch right;
    private double plane;

    Branch(ArrayList locs) {
        this(locs, 0);
    }

    private Branch(ArrayList locs, int depth) {
        int axis = depth % 3;
        int median = locs.size() / 2;
        Collections.sort(locs, new CartesianComparator(axis));
        this.plane = ((Location)locs.get((int)median)).coords[axis];
        ArrayList leftList = new ArrayList(locs.subList(0, median));
        ArrayList rightList = new ArrayList(locs.subList(median, locs.size()));
        this.right = rightList.size() == 1 ? new Leaf((Location)rightList.get(0)) : new Branch(rightList, ++depth);
        this.left = leftList.size() == 1 ? new Leaf((Location)leftList.get(0)) : new Branch(leftList, depth);
    }

    @Override
    public Location findNN(Location loc, int depth) {
        Location nnLoc;
        int axis = depth % 3;
        if (LocationHelper.isLeft(loc, this.plane, axis)) {
            Location nnChallenger;
            nnLoc = this.left.findNN(loc, depth + 1);
            double radius = LocationHelper.distanceSquared(nnLoc, loc);
            if (LocationHelper.intersect(loc, radius, this.plane, axis) && LocationHelper.distanceSquared(nnChallenger = this.right.findNN(loc, depth + 1), loc) < radius) {
                return nnChallenger;
            }
        } else {
            Location nnChallenger;
            nnLoc = this.right.findNN(loc, depth + 1);
            double radius = LocationHelper.distanceSquared(nnLoc, loc);
            if (LocationHelper.intersect(loc, radius, this.plane, axis) && LocationHelper.distanceSquared(nnChallenger = this.left.findNN(loc, depth + 1), loc) < radius) {
                return nnChallenger;
            }
        }
        return nnLoc;
    }
}

