/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.location.FileReverseGeocoder;
import com.cognos.mobile.location.IReverseGeocoder;
import com.cognos.mobile.location.NoopReverseGeocoder;
import com.cognos.mobile.location.ProjectionReverseGeocoder;
import com.cognos.mobile.location.UtmReverseGeocoder;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class ConfigParser {
    public static IReverseGeocoder parse(String baseDir, String filename) throws CMException {
        try {
            SAXReader xmlReader = new SAXReader();
            FileInputStream in = new FileInputStream(baseDir + "/" + filename);
            Document doc = xmlReader.read((InputStream)in);
            in.close();
            XPath xp = doc.createXPath("/location/*[@active='true']");
            List l = xp.selectNodes((Object)doc);
            if (l != null && l.size() > 0) {
                final ArrayList<IReverseGeocoder> geocoders = new ArrayList<IReverseGeocoder>();
                for (Element tEl : l) {
                    if (tEl.getName().equals("file")) {
                        geocoders.add(new FileReverseGeocoder(doc, (Node)tEl, baseDir));
                        continue;
                    }
                    if (tEl.getName().equals("utm")) {
                        geocoders.add(new UtmReverseGeocoder(doc, tEl));
                        continue;
                    }
                    if (tEl.getName().equals("projection")) {
                        geocoders.add(new ProjectionReverseGeocoder(doc, tEl));
                        continue;
                    }
                    if (tEl.getName().equals("noop")) {
                        geocoders.add(new NoopReverseGeocoder());
                        continue;
                    }
                    throw new CMException(1503, "unrecognized provider type '" + tEl.getName() + "'");
                }
                if (geocoders.size() == 1) {
                    return (IReverseGeocoder)geocoders.get(0);
                }
                return new IReverseGeocoder(){

                    @Override
                    public Hashtable reverseGeocode(double latitude, double longitude) {
                        Hashtable ret = null;
                        for (IReverseGeocoder rg : geocoders) {
                            Hashtable h = rg.reverseGeocode(latitude, longitude);
                            if (ret == null) {
                                ret = h;
                                continue;
                            }
                            ret.putAll(h);
                        }
                        return ret;
                    }
                };
            }
        }
        catch (Throwable t) {
            throw new CMException(1503, t);
        }
        return null;
    }
}

