/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.location.IReverseGeocoder;
import com.cognos.mobile.location.KDTree;
import com.cognos.mobile.location.LocationProfile;
import com.cognos.mobile.vm.VM;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Node;

public class FileReverseGeocoder
implements IReverseGeocoder {
    private static final Class CLASS = FileReverseGeocoder.class;
    private KDTree kdTree;
    private String[] fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public FileReverseGeocoder(Document doc, Node el, String baseDir) throws IOException, CMException {
        super();
        fieldsHT = new Hashtable<String, Integer>();
        fieldsAL = new ArrayList<String>();
        filename = baseDir + "/" + el.valueOf("@filename");
        xp = doc.createXPath("child::regex");
        regexpsL = xp.selectNodes((Object)el);
        regexps = new RegexpEntry[regexpsL.size()];
        i = 0;
        for (Node rexgexpN : regexpsL) {
            regexps[i] = new RegexpEntry();
            l = rexgexpN.valueOf("@latitude");
            if (l != null && l.length() > 0) {
                regexps[i].latitudeIndex = Integer.parseInt(l);
            }
            if ((l = rexgexpN.valueOf("@longitude")) != null && l.length() > 0) {
                regexps[i].longitudeIndex = Integer.parseInt(l);
            }
            re = rexgexpN.getText().trim();
            regexps[i].regex = Pattern.compile(re);
            xp = doc.createXPath("child::capture-group");
            captureGroups = xp.selectNodes((Object)rexgexpN);
            regexps[i].fields = new FieldEntry[captureGroups.size()];
            j = 0;
            for (Node captureGroupN : captureGroups) {
                regexps[i].fields[j] = new FieldEntry();
                regexps[i].fields[j].captureGroupIndex = Integer.parseInt(captureGroupN.valueOf("@index"));
                fieldName = captureGroupN.valueOf("@name");
                overallIndex = (Integer)fieldsHT.get(fieldName);
                if (overallIndex == null) {
                    overallIndex = new Integer(fieldsAL.size());
                    fieldsAL.add(fieldName);
                    fieldsHT.put(fieldName, overallIndex);
                }
                regexps[i].fields[j].fieldIndex = overallIndex;
                ++j;
            }
            ++i;
        }
        this.fields = new String[fieldsAL.size()];
        fieldsAL.toArray(this.fields);
        fieldsList = CMStringHelper.join(this.fields, ", ");
        VM.log(FileReverseGeocoder.CLASS, 0, "reading file '" + filename + " with " + regexps.length + " patterns");
        locations = new ArrayList<LocationProfile>();
        fis = new FileInputStream(filename);
        lineNumber = 1;
        try {
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            totalMatches = -1;
            totalNonMatches = -1;
            exceptions = 0;
            totalSkipped = -1;
            fst = new String[]{"first", "second", "third"};
            while ((line = br.readLine()) != null) {
                matched = false;
                for (i = 0; i < regexps.length; ++i) {
                    matcher = regexps[i].regex.matcher(line);
                    if (!matcher.find()) continue;
                    if (regexps[i].latitudeIndex > 0 && regexps[i].longitudeIndex > 0) {
                        try {
                            fieldValues = new String[this.fields.length];
                            latitude = Double.parseDouble(matcher.group(regexps[i].latitudeIndex));
                            longitude = Double.parseDouble(matcher.group(regexps[i].longitudeIndex));
                            for (j = 0; j < regexps[i].fields.length; ++j) {
                                fieldValues[regexps[i].fields[j].fieldIndex] = matcher.group(regexps[i].fields[j].captureGroupIndex);
                            }
                            locations.add(new LocationProfile(latitude, longitude, 0.0, fieldValues));
                            if (++totalMatches >= 3) ** GOTO lbl85
                            VM.log(FileReverseGeocoder.CLASS, 1, fst[totalMatches] + " match (line " + lineNumber + "):");
                            VM.log(FileReverseGeocoder.CLASS, 1, "'" + line + "'");
                            VM.log(FileReverseGeocoder.CLASS, 1, "lat " + latitude + ", long " + longitude + ", [" + fieldsList + "] = [" + CMStringHelper.join(fieldValues, ", ") + "]");
                        }
                        catch (Exception e) {
                            VM.log(FileReverseGeocoder.CLASS, 2, "exception '" + e.toString() + "' while parsing line " + lineNumber + " ('" + line + "') with pattern '" + regexps[i].regex.pattern() + "'");
                            VM.log(FileReverseGeocoder.CLASS, 2, "  matched: '" + matcher.group() + "'");
                            for (j = 0; j < matcher.groupCount(); ++j) {
                                VM.log(FileReverseGeocoder.CLASS, 2, "  group " + j + ": '" + matcher.group(j) + "'");
                            }
                            if (++exceptions <= 5) ** GOTO lbl85
                            throw new CMException(1503, "too many exceptions in '" + filename + "'");
                        }
                    } else if (++totalSkipped < 3) {
                        VM.log(FileReverseGeocoder.CLASS, 1, fst[totalSkipped] + " skip (line " + lineNumber + "):");
                        VM.log(FileReverseGeocoder.CLASS, 1, "'" + line + "'");
                    }
lbl85:
                    // 6 sources

                    matched = true;
                    break;
                }
                if (!matched && ++totalNonMatches < 3) {
                    VM.log(FileReverseGeocoder.CLASS, 1, fst[totalNonMatches] + " non-match (line " + lineNumber + "):");
                    VM.log(FileReverseGeocoder.CLASS, 1, "'" + line + "'");
                }
                ++lineNumber;
            }
            VM.log(FileReverseGeocoder.CLASS, 1, "read " + (lineNumber - 1) + " lines (" + (totalMatches + 1) + " matched; " + (totalNonMatches + 1) + " unmatched; " + (totalSkipped + 1) + " skipped)");
            this.kdTree = new KDTree(locations);
        }
        catch (IOException e) {
            VM.log(FileReverseGeocoder.CLASS, 2, "exception '" + e.toString() + "' while parsing line " + lineNumber);
        }
        finally {
            fis.close();
        }
    }

    @Override
    public Hashtable reverseGeocode(double latitude, double longitude) {
        LocationProfile location = (LocationProfile)this.kdTree.findNN(latitude, longitude);
        Hashtable<String, String> ret = new Hashtable<String, String>();
        if (location == null) {
            VM.log(CLASS, 2, "reverseGeocode - location unavailable");
        } else {
            for (int i = 0; i < location.attributes.length; ++i) {
                if (location.attributes[i] == null) continue;
                ret.put(this.fields[i], location.attributes[i]);
            }
        }
        return ret;
    }
}

