/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

public class Location {
    private static final double RADIUS = 6371.0;
    public final double latitude;
    public final double longitude;
    public final double accuracy;
    public final double[] coords;
    private final double rads;

    public Location(double latitude, double longitude, double accuracy) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.accuracy = accuracy;
        this.rads = Math.PI / 180;
        double latRads = latitude * this.rads;
        double lonRads = longitude * this.rads;
        double cosLatRads = Math.cos(latRads);
        this.coords = new double[3];
        this.coords[0] = cosLatRads * Math.cos(lonRads);
        this.coords[1] = cosLatRads * Math.sin(lonRads);
        this.coords[2] = Math.sin(latRads);
    }

    public double getDistanceFrom(Location loc) {
        double d = this.getDistanceFrom(loc.latitude, loc.longitude);
        return d;
    }

    public double getDistanceFrom(double lat, double lon) {
        double a = Math.sin(this.latitude * this.rads) * Math.sin(lat * this.rads) + Math.cos(this.latitude * this.rads) * Math.cos(lat * this.rads) * Math.cos((lon - this.longitude) * this.rads);
        if (Math.abs(a) > 1.0) {
            a = 1.0;
        }
        double d = Math.acos(a) * 6371.0;
        return d;
    }

    public String toString() {
        return "lat " + this.latitude + ", long " + this.longitude + ", acc " + this.accuracy;
    }
}

