/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.location.ILocationProvider;
import com.cognos.mobile.model.ui.IntChoice;
import com.cognos.mobile.model.ui.IntChoiceResponse;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;

public class LocationServices
implements MobileServiceProxy.ServerRequestModifier,
IEventListener {
    private static final Class CLASS = LocationServices.class;
    private final IClientApplication clientApplication;
    private final VMOptions options;
    private IConfiguration serverSettings;
    private ILocationProvider locationProvider = null;

    public LocationServices(IClientApplication clientApplication, VMOptions options, IEventManager eventManager) {
        this.clientApplication = clientApplication;
        this.options = options;
        eventManager.addEventListener(this);
    }

    public boolean showUseLocationUIOnOptionsPage() {
        return this.enabledOnServer() && this.clientApplication.locationServicesAreSupported();
    }

    public IntChoiceResponse getLocationChoices(IResourceManager res) {
        IntChoiceResponse response = new IntChoiceResponse();
        if (this.showUseLocationUIOnOptionsPage()) {
            switch (this.options.getUseLocation()) {
                case 0: {
                    response.selectedIndex = 0;
                    break;
                }
                case 1: {
                    response.selectedIndex = 1;
                    break;
                }
                case 2: {
                    response.selectedIndex = 2;
                }
            }
            response.choices = new IntChoice[]{new IntChoice(res.loadString(CMIDs.LOCATION_NEVER), 0), new IntChoice(res.loadString(CMIDs.LOCATION_ASK), 1), new IntChoice(res.loadString(CMIDs.LOCATION_ALWAYS), 2)};
        } else {
            response.selectedIndex = 0;
            response.choices = new IntChoice[]{new IntChoice(res.loadString(CMIDs.LOCATION_NO), 0)};
        }
        return response;
    }

    public IntChoiceResponse getGPSAlwaysOnChoices(IResourceManager res) {
        IntChoiceResponse response = new IntChoiceResponse();
        if (this.showUseLocationUIOnOptionsPage()) {
            switch (this.options.getGPSAlwaysOn()) {
                case 0: {
                    response.selectedIndex = 0;
                    break;
                }
                case 1: {
                    response.selectedIndex = 1;
                    break;
                }
                case 2: {
                    response.selectedIndex = 2;
                }
            }
            response.choices = new IntChoice[]{new IntChoice(res.loadString(CMIDs.LOCATION_NEVER), 0), new IntChoice(res.loadString(CMIDs.LOCATION_ASK), 1), new IntChoice(res.loadString(CMIDs.LOCATION_ALWAYS), 2)};
        } else {
            response.selectedIndex = 0;
            response.choices = new IntChoice[]{new IntChoice(res.loadString(CMIDs.LOCATION_NO), 0)};
        }
        return response;
    }

    public void refreshState(int useLocation) throws CMException {
        boolean NOT_SET = false;
        boolean DISABLED = true;
        int ENABLED = 2;
        int goalState = 0;
        goalState = useLocation == 1 || useLocation == 2 ? (this.enabledOnServer() ? (this.clientApplication.locationServicesAreSupported() ? 2 : 1) : 1) : 1;
        if (this.isEnabled()) {
            if (goalState == 1) {
                this.locationProvider.stop();
                this.locationProvider = null;
            }
        } else if (goalState == 2) {
            this.locationProvider = this.clientApplication.createLocationProvider(this.serverSettings);
        }
    }

    public boolean isEnabled() {
        return this.locationProvider != null;
    }

    public ILocationProvider.Loc getLocation() throws CMException {
        if (this.locationProvider != null) {
            try {
                ILocationProvider.Loc loc = this.locationProvider.getLocation();
                return loc;
            }
            catch (Throwable t) {
                try {
                    this.locationProvider.stop();
                    this.locationProvider = this.clientApplication.createLocationProvider(this.serverSettings);
                    if (this.locationProvider == null) {
                        return null;
                    }
                    ILocationProvider.Loc loc = this.locationProvider.getLocation();
                    return loc;
                }
                catch (Throwable t2) {
                    String msg = "unable to obtain location: first error '" + t.toString() + "', second error '" + t2.toString() + "'";
                    VM.log(CLASS, 3, msg);
                    throw new CMException(1502, msg, t);
                }
            }
        }
        return null;
    }

    @Override
    public void modify(IServerRequest request) throws CMException {
        String arg;
        int useLocation;
        if (!(this.locationProvider == null || (useLocation = this.options.getUseLocation()) != 1 && useLocation != 2 || (arg = request.getArgument(CMUrlConstants.PARAM_LOCATION_AVAILABLE[0])) != null && arg.length() != 0 || (arg = request.getArgument(CMUrlConstants.PARAM_LOCATION_LONGITUDE[0])) != null && arg.length() != 0)) {
            request.setArgument(CMUrlConstants.PARAM_LOCATION_AVAILABLE[0], "true");
        }
    }

    @Override
    public void onEvent(IEvent event) {
        switch (event.getCode()) {
            case 8: {
                this.serverSettings = (IConfiguration)event.getArgument();
                if (this.locationProvider != null) {
                    this.locationProvider.stop();
                    this.locationProvider = null;
                }
                try {
                    this.refreshState(this.options.getUseLocation());
                    break;
                }
                catch (CMException e) {
                    VM.log(CLASS, 3, e);
                }
            }
        }
    }

    private boolean enabledOnServer() {
        String asm = this.options.getSessionCookieProperty("asm");
        return asm != null && asm.indexOf("L") != -1;
    }
}

