/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.location.IReverseGeocoder;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionFactory;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.XPath;

public class ProjectionReverseGeocoder
implements IReverseGeocoder {
    private final String[] x_columns;
    private final String[] y_columns;
    private final Projection projection;

    public ProjectionReverseGeocoder(Document doc, Element root) throws CMException {
        ArrayList<String> xs = new ArrayList<String>();
        ArrayList<String> ys = new ArrayList<String>();
        XPath xp = doc.createXPath("columns");
        List columns = xp.selectNodes((Object)root);
        for (Element colEl : columns) {
            Attribute xAttr = colEl.attribute("x");
            Attribute yAttr = colEl.attribute("y");
            if (xAttr == null || yAttr == null) continue;
            xs.add(xAttr.getText());
            ys.add(yAttr.getText());
        }
        this.x_columns = new String[xs.size()];
        this.y_columns = new String[ys.size()];
        xs.toArray(this.x_columns);
        ys.toArray(this.y_columns);
        xp = doc.createXPath("proj4");
        Element e = (Element)xp.selectSingleNode((Object)root);
        if (e == null) {
            throw new CMException(1503, "required element 'proj4' is missing");
        }
        String[] args = CMStringHelper.split(e.getText(), ' ', true);
        this.projection = ProjectionFactory.fromPROJ4Specification((String[])args);
    }

    @Override
    public Hashtable reverseGeocode(double latitude, double longitude) {
        Point2D.Double src = new Point2D.Double(longitude, latitude);
        Point2D.Double dst = new Point2D.Double();
        this.projection.transform(src, dst);
        Hashtable<String, String> ret = new Hashtable<String, String>();
        for (int i = 0; i < this.x_columns.length; ++i) {
            ret.put(this.x_columns[i], Integer.toString((int)dst.x));
            ret.put(this.y_columns[i], Integer.toString((int)dst.y));
        }
        return ret;
    }
}

