/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

import com.cognos.mobile.location.KDTree;
import com.cognos.mobile.location.Location;
import com.cognos.mobile.location.LocationProfile;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ReverseGeoCoder {
    private KDTree tree;

    private ReverseGeoCoder() {
    }

    public static ReverseGeoCoder loadGeoProfiles(ArrayList locs) {
        ReverseGeoCoder ret = new ReverseGeoCoder();
        ret.tree = new KDTree(locs);
        return ret;
    }

    public static ReverseGeoCoder loadGeoProfiles(InputStream source) {
        ArrayList<LocationProfile> locations = new ArrayList<LocationProfile>();
        BufferedReader in = new BufferedReader(new InputStreamReader(source));
        try {
            while (in.ready()) {
                String[] strs = in.readLine().split("\t");
                if (strs.length < 3) continue;
                double lat = Double.parseDouble(strs[0]);
                double lon = Double.parseDouble(strs[1]);
                String xml = strs[2];
                locations.add(new LocationProfile(lat, lon, 0.0, new String[]{xml}));
            }
            return ReverseGeoCoder.loadGeoProfiles(locations);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LocationProfile findNN(Location loc) {
        if (this.tree == null) {
            return null;
        }
        return (LocationProfile)this.tree.findNN(loc.latitude, loc.longitude);
    }
}

