/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.location;

import com.cognos.mobile.location.IReverseGeocoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.XPath;

public class UtmReverseGeocoder
implements IReverseGeocoder {
    private final String[] x_columns;
    private final String[] y_columns;
    private double x_multiplier = 1.0;
    private double x_offset = 0.0;
    private double y_multiplier = 1.0;
    private double y_offset = 0.0;

    public UtmReverseGeocoder(Document doc, Element root) {
        Attribute a;
        ArrayList<String> xs = new ArrayList<String>();
        ArrayList<String> ys = new ArrayList<String>();
        XPath xp = doc.createXPath("columns");
        List columns = xp.selectNodes((Object)root);
        for (Element colEl : columns) {
            Attribute xAttr = colEl.attribute("x");
            Attribute yAttr = colEl.attribute("y");
            if (xAttr == null || yAttr == null) continue;
            xs.add(xAttr.getText());
            ys.add(yAttr.getText());
        }
        this.x_columns = new String[xs.size()];
        this.y_columns = new String[ys.size()];
        xs.toArray(this.x_columns);
        ys.toArray(this.y_columns);
        xp = doc.createXPath("x_transform");
        Element e = (Element)xp.selectSingleNode((Object)root);
        if (e != null) {
            a = e.attribute("multiplier");
            if (a != null) {
                this.x_multiplier = Double.parseDouble(a.getText());
            }
            if ((a = e.attribute("offset")) != null) {
                this.x_offset = Double.parseDouble(a.getText());
            }
        }
        if ((e = (Element)(xp = doc.createXPath("y_transform")).selectSingleNode((Object)root)) != null) {
            a = e.attribute("multiplier");
            if (a != null) {
                this.y_multiplier = Double.parseDouble(a.getText());
            }
            if ((a = e.attribute("offset")) != null) {
                this.y_offset = Double.parseDouble(a.getText());
            }
        }
    }

    private int INT(double d) {
        return (int)d;
    }

    @Override
    public Hashtable reverseGeocode(double latitude, double longitude) {
        double B2 = latitude;
        double C2 = longitude;
        double Y2 = 6378137.0;
        double Z2 = 6356752.314;
        double AK2 = (Y2 - Z2) / (Y2 + Z2);
        double AO2 = Y2 * (1.0 - AK2 + 5.0 * AK2 * AK2 / 4.03 * (1.0 - AK2) + 81.0 * AK2 * AK2 * AK2 * AK2 / 64.03 * (1.0 - AK2));
        double P2 = B2 * Math.PI / 180.0;
        double AQ2 = 15.0 * Y2 * AK2 * AK2 / 16.0 * (1.0 - AK2 + 3.0 * AK2 * AK2 / 4.0 * (1.0 - AK2));
        double AP2 = 3.0 * Y2 * AK2 / 2.0 * (1.0 - AK2 - 7.0 * AK2 * AK2 / 8.0 * (1.0 - AK2) + 55.0 * AK2 * AK2 * AK2 * AK2 / 64.0);
        double AR2 = 35.0 * Y2 * AK2 * AK2 * AK2 / 48.0 * (1.0 - AK2 + 11.0 * AK2 * AK2 / 16.0);
        double AS2 = 315.0 * Y2 * AK2 * AK2 * AK2 * AK2 / 51.0 * (1.0 - AK2);
        double AN2 = AO2 * P2 - AP2 * Math.sin(2.0 * P2) + AQ2 * Math.sin(4.0 * P2) - AR2 * Math.sin(6.0 * P2) + AS2 * Math.sin(8.0 * P2);
        double AH2 = 0.9996;
        double AW2 = AN2 * AH2;
        double AI2 = Math.sqrt(1.0 - Z2 / Y2 * (Z2 / Y2));
        double AM2_temp = AI2 * Math.sin(P2);
        double AM2 = Y2 / Math.sqrt(1.0 - AM2_temp * AM2_temp);
        double AV2 = 4.84813681109536E-6;
        double AX2 = AM2 * Math.sin(P2) * Math.cos(P2) * AV2 * AV2 * AH2 * 1.0E8 / 2.0;
        double H2 = C2 < 0.0 ? (double)this.INT((180.0 + C2) / 6.0) + 1.0 : (double)this.INT(C2 / 6.0) + 31.0;
        double J2 = 6.0 * H2 - 183.0;
        double AT2 = C2 - J2;
        double AU2 = AT2 * 3600.0 / 10000.0;
        double AJ2 = AI2 * AI2 / (1.0 - AI2 * AI2);
        double AY2 = AV2 * AV2 * AV2 * AV2 * AM2 * Math.sin(P2) * Math.cos(P2) * Math.cos(P2) * Math.cos(P2) / 24.0 * (5.0 - Math.tan(P2) * Math.tan(P2) + 9.0 * AJ2 * Math.cos(P2) * Math.cos(P2) + 4.0 * AJ2 * AJ2 * Math.cos(P2) * Math.cos(P2) * Math.cos(P2) * Math.cos(P2)) * AH2 * 1.0E16;
        double V2 = AW2 + AX2 * AU2 * AU2 + AY2 * AU2 * AU2 * AU2 * AU2;
        double K2 = B2 > 0.0 ? V2 : 1.0E7 + V2;
        double AZ2 = AM2 * Math.cos(P2) * AV2 * AH2 * 10000.0;
        double BA2 = AV2 * Math.cos(P2) * (AV2 * Math.cos(P2)) * (AV2 * Math.cos(P2)) * (AM2 / 6.0) * (1.0 - Math.tan(P2) * Math.tan(P2) + AJ2 * Math.cos(P2) * Math.cos(P2)) * AH2 * 1.0E12;
        double L2 = 500000.0 + (AZ2 * AU2 + BA2 * AU2 * AU2 * AU2);
        double utm_east = L2 * this.x_multiplier + this.x_offset;
        double utm_north = K2 * this.y_multiplier + this.y_offset;
        Hashtable<String, Double> ret = new Hashtable<String, Double>();
        for (int i = 0; i < this.x_columns.length; ++i) {
            ret.put(this.x_columns[i], new Double(utm_east));
            ret.put(this.y_columns[i], new Double(utm_north));
        }
        return ret;
    }
}

