/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.logging;

import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.logging.ILGLogger;
import com.cognos.mobile.vm.VMOptions;
import java.io.PrintStream;

public class ConsoleLogger
implements ILGLogger,
IEventListener {
    private static final String[] SEVERITY_DESC = new String[]{"DEBUG", "INFO", "WARN", "ERROR"};
    private int min = 0;
    private boolean formatted;
    private final PrintStream out;
    private final PrintStream err;

    public ConsoleLogger(IEventManager eventManager) {
        this(eventManager, 0, false);
    }

    public ConsoleLogger(IEventManager eventManager, int min_severity, boolean justTheMessage) {
        this(eventManager, min_severity, justTheMessage, System.out, System.err);
    }

    public ConsoleLogger(IEventManager eventManager, int min_severity, boolean justTheMessage, PrintStream out, PrintStream err) {
        this.formatted = !justTheMessage;
        this.min = min_severity;
        this.out = out;
        this.err = err;
        eventManager.addEventListener(this);
    }

    private String format(Class clazz, int severity, String message, Throwable t) {
        if (!this.formatted) {
            return message;
        }
        return "[" + clazz.getName() + "] " + SEVERITY_DESC[severity] + " " + message + (t == null ? "" : t.toString());
    }

    @Override
    public void log(Class clazz, int severity, String message, Throwable t) {
        if (!this.wouldLog(clazz, severity)) {
            return;
        }
        String m = this.format(clazz, severity, message, t);
        if (severity == 3) {
            this.err.println(m);
        } else {
            this.out.println(m);
        }
    }

    @Override
    public boolean wouldLog(Class clazz, int severity) {
        return severity >= this.min;
    }

    @Override
    public void onEvent(IEvent event) {
        switch (event.getCode()) {
            case 11: {
                this.min = ((VMOptions)event.getArgument()).getMinSeverity();
            }
        }
    }

    @Override
    public void dispose() {
    }
}

