/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.logging;

import com.cognos.mobile.common.CMCircularLogger;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.logging.ILGLogger;
import com.cognos.mobile.vm.VMOptions;
import java.io.PrintStream;
import java.util.Date;

public class LGLoggerStream
implements ILGLogger,
IEventListener {
    private static int MAX_LENGTH_FOR_IN_MEMORY_LOG = 150;
    private int minSeverity;
    private String[] logMatches;
    private PrintStream printStream;
    private CMCircularLogger mostRecent = null;

    public LGLoggerStream(IEventManager eventManager, PrintStream printStream, int minSeverity, String[] logMatches) {
        this.printStream = printStream;
        this.minSeverity = minSeverity;
        this.logMatches = logMatches;
        eventManager.addEventListener(this);
    }

    public void setMinSeverity(int minSeverity) {
        this.minSeverity = minSeverity;
        if (this.mostRecent != null && this.getMaxForMostRecent(minSeverity) != this.mostRecent.getRingSize()) {
            this.mostRecent = null;
        }
    }

    public void setMatches(String[] matches) {
        this.logMatches = matches;
    }

    public void dump(StringBuffer sb) {
        if (this.mostRecent != null) {
            this.mostRecent.dump(sb);
        }
    }

    @Override
    public void onEvent(IEvent event) {
        switch (event.getCode()) {
            case 11: {
                this.minSeverity = ((VMOptions)event.getArgument()).getMinSeverity();
                if (this.mostRecent == null || this.getMaxForMostRecent(this.minSeverity) == this.mostRecent.getRingSize()) break;
                this.mostRecent = null;
            }
        }
    }

    @Override
    public boolean wouldLog(Class clazz, int severity) {
        return severity >= this.minSeverity;
    }

    @Override
    public void log(Class clazz, int severity, String message, Throwable t) {
        if (severity < this.minSeverity) {
            return;
        }
        String className = clazz.getName();
        if (this.logMatches != null && !this.isClassMatched(className)) {
            return;
        }
        className = LGLoggerStream.getClassName(className);
        try {
            Date d = new Date();
            String text = CMStringHelper.formatTime(d) + " [" + className + "] " + message;
            this.printStream.print(text);
            if (this.mostRecent == null) {
                this.mostRecent = new CMCircularLogger(this.getMaxForMostRecent(this.minSeverity), CMCircularLogger.FLAG_NEWLINES);
            } else {
                this.mostRecent.next();
            }
            if (text.length() > MAX_LENGTH_FOR_IN_MEMORY_LOG) {
                this.mostRecent.log(text.substring(0, MAX_LENGTH_FOR_IN_MEMORY_LOG) + "...");
            } else {
                this.mostRecent.log(text);
            }
            if (t != null) {
                t.printStackTrace(this.printStream);
            }
            this.printStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getMaxForMostRecent(int minSeverity) {
        switch (minSeverity) {
            case 0: {
                return 15;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 5;
            }
        }
        return 5;
    }

    private boolean isClassMatched(String category) {
        if (category == null) {
            return false;
        }
        for (int i = 0; i < this.logMatches.length; ++i) {
            int len = Math.min(category.length(), this.logMatches[i].length());
            if (!category.substring(0, len).equals(this.logMatches[i])) continue;
            return true;
        }
        return false;
    }

    private static String getClassName(String className) {
        int index = CMStringHelper.lastIndexOf(className, '.');
        String name = index == -1 ? className : className.substring(index + 1);
        return name;
    }

    @Override
    public void dispose() {
    }
}

