/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.logging;

import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.logging.ILGLogger;
import java.util.Stack;

public class LogBuffer
implements ILGLogger,
IEventListener {
    private final ILGLogger logger;
    private IEventListener l;
    private final Stack items;
    private final int maxSize;

    public LogBuffer(ILGLogger logger, int size) {
        this.logger = logger;
        this.items = new Stack();
        this.maxSize = size;
        if (logger instanceof IEventListener) {
            this.l = (IEventListener)((Object)logger);
        }
    }

    @Override
    public void onEvent(IEvent event) {
        if (this.l != null) {
            this.l.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Class clazz, int severity, String message, Throwable t) {
        if (this.wouldLog(clazz, severity)) {
            Stack stack = this.items;
            synchronized (stack) {
                if (this.items.size() == this.maxSize) {
                    this.items.pop();
                }
                this.items.push(message + (t == null ? "" : t.toString()));
            }
        }
        this.logger.log(clazz, severity, message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getItems() {
        Stack stack = this.items;
        synchronized (stack) {
            String[] r = new String[this.items.size()];
            for (int i = 0; i < this.items.size(); ++i) {
                r[i] = (String)this.items.elementAt(i);
            }
            return r;
        }
    }

    @Override
    public boolean wouldLog(Class clazz, int severity) {
        return this.logger.wouldLog(clazz, severity);
    }

    @Override
    public void dispose() {
    }
}

