/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.model.data;

import com.cognos.mobile.common.C8Helper;
import java.util.Date;
import java.util.Vector;

public class AtomFeedNode {
    private final AtomFeedNode parent;
    private final Vector children = new Vector();
    private final String atomID;
    private String atomTitle;
    private final Date atomUpdated;
    private final String atomContent;
    private final String atomLink;
    private final String cmPath;
    private final String cmStoreID;
    private final String cmObjectClass;
    private int type;
    private boolean leaf;

    public AtomFeedNode() {
        this(null, "", "/", null, "", "", "/", "", "root");
    }

    public AtomFeedNode(AtomFeedNode parent, String atomID, String atomTitle, Date atomUpdated, String atomContentType, String atomLink, String cmPath, String cmStoreID, String cmObjectClass) {
        this.parent = parent;
        this.atomID = atomID;
        this.atomTitle = atomTitle;
        this.atomUpdated = atomUpdated;
        this.atomContent = atomContentType;
        this.atomLink = atomLink;
        this.cmPath = cmPath;
        this.cmStoreID = cmStoreID;
        this.cmObjectClass = cmObjectClass;
        this.type = C8Helper.crackObjectClass(cmObjectClass, null);
    }

    public final AtomFeedNode getParent() {
        return this.parent;
    }

    public final Vector getSiblings() {
        if (this.isRoot()) {
            return new Vector();
        }
        Vector kids = this.getParent().getChildren();
        Vector v = new Vector();
        for (int i = 0; i < kids.size(); ++i) {
            Object o = kids.elementAt(i);
            if (o.equals(this)) continue;
            v.addElement(o);
        }
        return v;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean hasChildren() {
        return this.children.size() != 0;
    }

    public final void setLeaf() {
        this.leaf = true;
    }

    public final boolean isLeaf() {
        return this.leaf;
    }

    public void add(String atomID, String atomTitle, Date atomUpdated, String atomContentType, String atomLink, String cmPath, String cmStoreID, String cmObjectClass) {
        if (C8Helper.crackObjectClass(cmObjectClass, null) != 50) {
            this.children.addElement(new AtomFeedNode(this, atomID, atomTitle, atomUpdated, atomContentType, atomLink, cmPath, cmStoreID, cmObjectClass));
        }
    }

    public Vector getChildren() {
        return this.children;
    }

    public String getAtomTitle() {
        return this.atomTitle;
    }

    public String getAtomFullTitle() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getAtomFullTitle() + "/" + this.atomTitle;
    }

    public String getAtomLink() {
        return this.atomLink;
    }

    public String getCmPath() {
        return this.cmPath;
    }

    public String getCmStoreID() {
        return this.cmStoreID;
    }

    public String getCmObjectClass() {
        return this.cmObjectClass;
    }

    public String toString() {
        return this.getCmStoreID();
    }

    public int getType() {
        return this.type;
    }

    public void setAtomTitle(String atomTitle) {
        this.atomTitle = atomTitle;
    }

    public void setType(int type) {
        this.type = type;
    }
}

